maxprocs
========

`maxprocs` старается решить проблему автотюнинга `GOMAXPROCS`.
Суть проблемы - в Облаке тебе доступны все логические ядра сервера (что зачастую заметно выше твоих лимитов), поэтому Golang начинает использовать овердофига тредов и твою приложеньку троттлят по CPU.

Что бы как-то решить эту ситуацию и существует эта библиотека, которая смотрит на допустимые лимиты/ядра и выставляет "безопасное" значение `GOMAXPROCS`.
Под "безопасными" понимаются следующие значения:
  - не менее 2
  - не более кол-ва логических ядер
  - не более лимитов облака (насколько это вообще возможно определить)

## Usage

Использовать предельно просто, достаточно из `main` (или любого другого удобного места, но лучше поближе к точке входа) позвать:
```go
// Если у тебя есть cgroupfs
maxprocs.AdjustCgroup()

// Если ты в Qloud
maxprocs.AdjustQloud()

// Если ты в Y.Deploy (aka YP/YP.Hard)
maxprocs.AdjustYP()

// Если ты в RTC c YPLite
maxprocs.AdjustYPLite()

// Если ты в RTC c InstanceCTL версии 1.177+
maxprocs.AdjustInstancectl()

// Во всех остальных случаях
maxprocs.AdjustAuto()
```

Если хочется руками потюнить - библиотека уважает переменную окружения `GOMAXPROCS`, можно тюнить сколь угодно долго ;)
