# yo

Утилита для редактирования ya.make-ов и управления директорией vendor
в аркадии.

## Автоматическая генерация ya.make

```bash
$ vim foo/bar/main.go # hack hack hack
$ ya tool yo fix foo # run fix in project root
```

`yo fix` автоматически редактирует список исходников внутри `ya.make` файлов.

`yo fix` применяется рекурсивно на все go пакеты внутри директории.

Если в директории пакета нет `ya.make` файла, то `yo fix` автоматически сгенерирует
нужный `ya.make` файл. Если файл уже есть, то `yo fix` отредактирует его.

**Старайтесь** не трогать `ya.make` руками, если действие может выполнить `yo fix`.

`yo fix` занимается именно редактированием, а не генерацией. `ya.make`
файлы могут содержать макросы, которые невозможно сгенерировать из исходного
кода. `yo fix` старается не трогать части `ya.make`, которые ему не
понятны.

## Работа с vendor

### Шаг 1: Запустить `yo get`

```bash
$ ya tool yo get go.uber.org/zap # get last public version
$ ya tool yo get go.uber.org/zap@v1.14.1 # get v1.14.1
$ ya tool yo get go.uber.org/zap@master # get last untagged version (or @HEAD)
```

`yo get` принимает одно имя модуля, в формате `go get`.

### Шаг 2: Обновить `vendor.policy`

Файл `build/rules/go/vendor.policy` задаёт список разрешённых пакетов. В `vendor/`
хранится исходный код тех пакетов, которые нужны для сборки разрешённых.

Например, в случае с `aws-go`, мы добавляем в `vendor/` не все клиенты, а только `s3`
и `sqs`.

```
ALLOW .* -> vendor/github.com/aws/aws-sdk-go/aws
ALLOW .* -> vendor/github.com/aws/aws-sdk-go/service/s3
ALLOW .* -> vendor/github.com/aws/aws-sdk-go/service/sqs
```

Порядок команд в файле важен. Применяется первое подходящее правило.

```
ALLOW .* -> foo/bar
DENY .* -> foo/bar/zog # этот deny не будет иметь эффекта.
```

### Шаг 3: Запустить `yo vendor`

```
ya tool yo vendor
```

Команда `yo vendor` анализирует изменения в `vendor.policy` и `go.mod`, и обновляет
файлы внутри `vendor/`

`yo vendor` добавляет только те `.go` файлы, которые нужны для сборки
пакетов из `vendor.policy`.

Обычные файлы (`.txt`, `.json` и т.д.) добавляются в `vendor/`
всегда. Это может создавать проблемы с размером коммита, если новая
зависимость принесёт с собой много лишних файлов.

Отфильтровать обычные файлы можно c помощью `.yoignore`. Файлы
`.yoignore` работают точно так же, как `.gitignore`.

Для удобства работы с ними есть команда `yo ignore`.

```
arc st # Какие файлы добавились?

yo ignore github.com/aws/aws-sdk-go '*.json' # Добавим правило и перезапустим vendor
```

По дефолту, модуль добавляется вместе со всеми тестами. Это может создавать проблемы,
когда тесты требуют для своей работы слишком много ненужных зависимостей. Можно
отключить вендор тестов через специальных синтаксис в `vendor.policy`.

```
# github.com/foo/bar - это имя модуля.
DENY .* -> vendor/github.com/foo/bar;test
```

### Шаг 4: Проверить сборку и тесты нового кода

```
$ ya make -r -j0 vendor/my/new/package # проверить конфигурацию
$ ya make -r vendor/my/new/package     # проверить сборку
$ ya make -r -t vendor/my/new/package  # проверить тесты
```

## Как обновить версию yo внутри ya tool

1. Склонировать задачу https://sandbox.yandex-team.ru/task/999930595/view
2. В поле `Svn url for arcadia` удалить ревизию (число после @). Если этого не сделать,
   соберётся старая версия.
3. Дождаться завершения задачи.
4. ID задачи нужно вписать в файл `build/ya.conf.json`.
5. Локальным запуском `ya tool yo version` проверить, что скачалась новая, рабочая версия.
6. Закоммитить изменения.

## Changelog

### 15-12-2021
 - При генерации макроса LICENSE между записями автоматически проставляется оператор AND.

### 26-05-2020
 - Значительно переработана логика работы команды vendor.
   - Добавлена возможность игнорировать файлы через `.yoignore`
   - В vendor копируются только достижимые от `vendor.policy` пакеты
   - Генерируется файл `vendor/modules.txt` совместимый со стандартным тулингом

### 10-10-2019
 - Исправлен баг в обработке RECURSE внутри директории vendor/, из-за которого в некоторых случаях требовались ручные
   действия при обновлении библиотек в vendor
 - Значение макроса OWNER теперь наследуется от корня. Если внутри ya.make не определён OWNER, то OWNER
   будет скопирован с родителя.

### 07-08-2019
 - Используется Аркадийный Go toolchain

### 10-06-2019
 - `yo fix` больше не указывает генерированные файлы в `SRCS`.
 - Поправлен баг в обработке `PROTO_LIBRARY`, из-за которого yo fix удалял SRCS.

### 15-05-2019
 - `yo fix` умеет запускаться не из корня аркадии.

### 19-03-2019
 - Изменена логика обработки `RECURSE`.
   * Теперь yo всегда будет ставить `RECURSE` на `ya.make`-и, которые
     он редактировал (Раньше recurse ставился только на новые
     `ya.make`-и).
   * Теперь yo генерирует `ya.make`-и для промежуточных директорий, не
     содержащих кода.

### 12-02-2019
 - В случае, когда пакет содержит только тесты, `yo fix` использует макрос `GO_TEST`.

### 12-01-2019
 - Улучшена обработка комментариев вне макросов.
 - Корректно обрабатываются пакеты, собирающиеся только под одну платформу.

### 06-01-2019

 - `yo fix` распознаёт комментарии внутри макроса `RECURSE`.
 - Опция `--owner` переименована в `--add-owner` и теперь корректно
   распознаёт список разделённый пробелами.
 - `yo get` удаляет `// indirect` пометки из получившегося `go.mod` файла.
