# Доработанная версия JDBC драйвера Postgresql

Этот драйвер изменяет способ выбора инстанса БД для подключения в кластерной конфигурации БД (мастер-слайв, который
используется в PGaaS).

## Список изменений

1) Не происходит подключение к репликам, которые сильно отстают от мастера. Допустимое время репликации задается
   параметром подключения maxReplicationLag. По умолчанию исключаются реплики отстающие более чем на 10 сек.

2) Если loadBalanceHosts=false (значение по умолчанию), то выбирается ближайший инстанс БД. Близость хоста определяется
   временем выполнения проверки статуса инстанса. В оригинальном драйвере инстансы в этом случае выбираются в порядке
   указанном в URL-е подключения.

3) Проверка статусов инстансов проверяется в отдельном потоке и не влияет на время получения нового соединения. В
   оригинальном драйвере статус инстансов проверялся во время получения соединения, что приводило к большим задержкам в
   случае недоступности одного из инстансов БД.

## Как использовать

Для использования этого драйвера вам потребуется:

1) Указать зависимость в ya.make

 ```
 PEERDIR (
   library/java/ds/pgdriver
 )
 ```

2) Изменить параметры подключения к БД

- Указать класс драйвера

 ```java
 ...
 BasicDataSource dataSource=new BasicDataSource();
 dataSource.setDriverClassName(PGClusterDriver.class.getName());
 ...
 ```

- Изменить протокол подключения к БД с ```jdbc:postgresql:``` на ```jdbc:pgcluster:```

## Основные параметры подключения

* targetServerType - задает роль инстанса к которому необходимо установить соединение. Доступные значения
  any|primary|master|slave|secondary|preferSlave|preferSecondary . По умолчанию any .

- primary|master - подключение будет установлено к мастеру БД.
- slave|secondary - подключение будет установлено к реплике.
- preferSlave|preferSecondary - подключение будет установлено к реплике, а если нет возможности установить
  соединение к реплике, то соединение будет установлено к мастеру БД.
- any - подключение будет установлено к любому инстансу. При выборе инстанса не смотрится на его роль: мастер или
  реплика. Такой тип выбора подходит для случаев, когда нагрузка на изменение данных ничтожна мола по отношению
  к чтению данных.

* hostRecheckSeconds - период обновления информации о статусе инстанса. Обновляется информация о доступности инстанса,
  его роли (мастер или слейв), задержке репликации и удаленности инстанса (времени выполнения ping запроса).
  По умолчанию 10 сек.

* loadBalanceHosts - способ выбора инстанса БД если можно выбрать из нескольких инстансов. Возможные значения false|true.
  По умолчанию false. Если значение false, то соединение будет установлено к хосту наиболее быстро ответившему на запрос
  проверки статуса (как правило такой инстанс находится в том же ДЦ). Если true, то инстанс будет выбран случайным
  образом.

* maxReplicationLag - максимальное отставание репликации в миллисекундах. Если репликация больше указанного значения, то
  инстанс исключается из списка хостов доступных для установления соединения. Значение по умолчанию 10000 мс. Параметр
  добавлен этой реализацией драйвера.
