
def rgb(r, g, b):
    def valid_color(name, c):
        assert 0 <= c <= 255, '{} part of color is invalid, r={}, g={}, b={}'.format(name, r, g, b)
    valid_color('red', r)
    valid_color('green', g)
    valid_color('blue', b)
    return '#{0:02X}{1:02X}{2:02X}'.format(r, g, b)


class Color(object):
    """ Enum for common colors """
    ALICE_BLUE = 'AliceBlue'
    ANTIQUE_WHITE = 'AntiqueWhite'
    AQUA = 'Aqua'
    AQUAMARINE = 'Aquamarine'
    AZURE = 'Azure'
    BEIGE = 'Beige'
    BISQUE = 'Bisque'
    BLACK = 'Black'
    BLANCHED_ALMOND = 'BlanchedAlmond'
    BLUE = 'Blue'
    BLUE_VIOLET = 'BlueViolet'
    BROWN = 'Brown'
    BURLY_WOOD = 'BurlyWood'
    CADET_BLUE = 'CadetBlue'
    CHARTREUSE = 'Chartreuse'
    CHOCOLATE = 'Chocolate'
    CORAL = 'Coral'
    CORNFLOWER_BLUE = 'CornflowerBlue'
    CORNSILK = 'Cornsilk'
    CRIMSON = 'Crimson'
    CYAN = 'Cyan'
    DARK_BLUE = 'DarkBlue'
    DARK_CYAN = 'DarkCyan'
    DARK_GOLDEN_ROD = 'DarkGoldenRod'
    DARK_GRAY = 'DarkGray'
    DARK_GREY = 'DarkGrey'
    DARK_GREEN = 'DarkGreen'
    DARK_KHAKI = 'DarkKhaki'
    DARK_MAGENTA = 'DarkMagenta'
    DARK_OLIVE_GREEN = 'DarkOliveGreen'
    DARK_ORANGE = 'DarkOrange'
    DARK_ORCHID = 'DarkOrchid'
    DARK_RED = 'DarkRed'
    DARK_SALMON = 'DarkSalmon'
    DARK_SEA_GREEN = 'DarkSeaGreen'
    DARK_SLATE_BLUE = 'DarkSlateBlue'
    DARK_SLATE_GRAY = 'DarkSlateGray'
    DARK_SLATE_GREY = 'DarkSlateGrey'
    DARK_TURQUOISE = 'DarkTurquoise'
    DARK_VIOLET = 'DarkViolet'
    DEEP_PINK = 'DeepPink'
    DEEP_SKY_BLUE = 'DeepSkyBlue'
    DIM_GRAY = 'DimGray'
    DIM_GREY = 'DimGrey'
    DODGER_BLUE = 'DodgerBlue'
    FIRE_BRICK = 'FireBrick'
    FLORAL_WHITE = 'FloralWhite'
    FOREST_GREEN = 'ForestGreen'
    FUCHSIA = 'Fuchsia'
    GAINSBORO = 'Gainsboro'
    GHOST_WHITE = 'GhostWhite'
    GOLD = 'Gold'
    GOLDEN_ROD = 'GoldenRod'
    GRAY = 'Gray'
    GREY = 'Grey'
    GREEN = 'Green'
    GREEN_YELLOW = 'GreenYellow'
    HONEY_DEW = 'HoneyDew'
    HOT_PINK = 'HotPink'
    INDIAN_RED = 'IndianRed'
    INDIGO = 'Indigo'
    IVORY = 'Ivory'
    KHAKI = 'Khaki'
    LAVENDER = 'Lavender'
    LAVENDER_BLUSH = 'LavenderBlush'
    LAWN_GREEN = 'LawnGreen'
    LEMON_CHIFFON = 'LemonChiffon'
    LIGHT_BLUE = 'LightBlue'
    LIGHT_CORAL = 'LightCoral'
    LIGHT_CYAN = 'LightCyan'
    LIGHT_GOLDEN_ROD_YELLOW = 'LightGoldenRodYellow'
    LIGHT_GRAY = 'LightGray'
    LIGHT_GREY = 'LightGrey'
    LIGHT_GREEN = 'LightGreen'
    LIGHT_PINK = 'LightPink'
    LIGHT_SALMON = 'LightSalmon'
    LIGHT_SEA_GREEN = 'LightSeaGreen'
    LIGHT_SKY_BLUE = 'LightSkyBlue'
    LIGHT_SLATE_GRAY = 'LightSlateGray'
    LIGHT_SLATE_GREY = 'LightSlateGrey'
    LIGHT_STEEL_BLUE = 'LightSteelBlue'
    LIGHT_YELLOW = 'LightYellow'
    LIME = 'Lime'
    LIME_GREEN = 'LimeGreen'
    LINEN = 'Linen'
    MAGENTA = 'Magenta'
    MAROON = 'Maroon'
    MEDIUM_AQUA_MARINE = 'MediumAquaMarine'
    MEDIUM_BLUE = 'MediumBlue'
    MEDIUM_ORCHID = 'MediumOrchid'
    MEDIUM_PURPLE = 'MediumPurple'
    MEDIUM_SEA_GREEN = 'MediumSeaGreen'
    MEDIUM_SLATE_BLUE = 'MediumSlateBlue'
    MEDIUM_SPRING_GREEN = 'MediumSpringGreen'
    MEDIUM_TURQUOISE = 'MediumTurquoise'
    MEDIUM_VIOLET_RED = 'MediumVioletRed'
    MIDNIGHT_BLUE = 'MidnightBlue'
    MINT_CREAM = 'MintCream'
    MISTY_ROSE = 'MistyRose'
    MOCCASIN = 'Moccasin'
    NAVAJO_WHITE = 'NavajoWhite'
    NAVY = 'Navy'
    OLD_LACE = 'OldLace'
    OLIVE = 'Olive'
    OLIVE_DRAB = 'OliveDrab'
    ORANGE = 'Orange'
    ORANGE_RED = 'OrangeRed'
    ORCHID = 'Orchid'
    PALE_GOLDEN_ROD = 'PaleGoldenRod'
    PALE_GREEN = 'PaleGreen'
    PALE_TURQUOISE = 'PaleTurquoise'
    PALE_VIOLET_RED = 'PaleVioletRed'
    PAPAYA_WHIP = 'PapayaWhip'
    PEACH_PUFF = 'PeachPuff'
    PERU = 'Peru'
    PINK = 'Pink'
    PLUM = 'Plum'
    POWDER_BLUE = 'PowderBlue'
    PURPLE = 'Purple'
    REBECCA_PURPLE = 'RebeccaPurple'
    RED = 'Red'
    ROSY_BROWN = 'RosyBrown'
    ROYAL_BLUE = 'RoyalBlue'
    SADDLE_BROWN = 'SaddleBrown'
    SALMON = 'Salmon'
    SANDY_BROWN = 'SandyBrown'
    SEA_GREEN = 'SeaGreen'
    SEA_SHELL = 'SeaShell'
    SIENNA = 'Sienna'
    SILVER = 'Silver'
    SKY_BLUE = 'SkyBlue'
    SLATE_BLUE = 'SlateBlue'
    SLATE_GRAY = 'SlateGray'
    SLATE_GREY = 'SlateGrey'
    SNOW = 'Snow'
    SPRING_GREEN = 'SpringGreen'
    STEEL_BLUE = 'SteelBlue'
    TAN = 'Tan'
    TEAL = 'Teal'
    THISTLE = 'Thistle'
    TOMATO = 'Tomato'
    TURQUOISE = 'Turquoise'
    VIOLET = 'Violet'
    WHEAT = 'Wheat'
    WHITE = 'White'
    WHITE_SMOKE = 'WhiteSmoke'
    YELLOW = 'Yellow'
    YELLOW_GREEN = 'YellowGreen'
