__all__ = [
    'SegmentationMajorityVote',
]
import crowdkit.aggregation.base
import pandas
import typing


class SegmentationMajorityVote(crowdkit.aggregation.base.BaseImageSegmentationAggregator):
    """Segmentation Majority Vote - chooses a pixel if more than half of workers voted.

    This method implements a straightforward approach to the image segmentations aggregation:
    it assumes that if pixel is not inside in the worker's segmentation, this vote counts
    as 0, otherwise, as 1. Next, the `SegmentationEM` aggregates these categorical values
    for each pixel by the Majority Vote.

    The method also supports weighted majority voting if `skills` were provided to `fit` method.

    Doris Jung-Lin Lee. 2018.
    Quality Evaluation Methods for Crowdsourced Image Segmentation
    <https://ilpubs.stanford.edu:8090/1161/1/main.pdf>

    Args:
        default_skill: A default skill value for missing skills.

    Examples:
        >>> import numpy as np
        >>> import pandas as pd
        >>> from crowdkit.aggregation import SegmentationMajorityVote
        >>> df = pd.DataFrame(
        >>>     [
        >>>         ['t1', 'p1', np.array([[1, 0], [1, 1]])],
        >>>         ['t1', 'p2', np.array([[0, 1], [1, 1]])],
        >>>         ['t1', 'p3', np.array([[0, 1], [1, 1]])]
        >>>     ],
        >>>     columns=['task', 'worker', 'segmentation']
        >>> )
        >>> result = SegmentationMajorityVote().fit_predict(df)
    Attributes:
        segmentations_ (Series): Tasks' segmentations.
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's aggregated segmentation.

        on_missing_skill (str): How to handle assignments done by workers with unknown skill.
            Possible values:
                    * "error" — raise an exception if there is at least one assignment done by user with unknown skill;
                    * "ignore" — drop assignments with unknown skill values during prediction. Raise an exception if there is no 
                    assignments with known skill for any task;
                    * value — default value will be used if skill is missing.
    """

    def fit(
        self,
        data: pandas.DataFrame,
        skills: pandas.Series = None
    ) -> 'SegmentationMajorityVote':
        """Fit the model.
        Args:
            data (DataFrame): Workers' segmentations.
                A pandas.DataFrame containing `worker`, `task` and `segmentation` columns'.

            skills (Series): workers' skills.
                A pandas.Series index by workers and holding corresponding worker's skill
        Returns:
            SegmentationMajorityVote: self.
        """
        ...

    def fit_predict(
        self,
        data: pandas.DataFrame,
        skills: pandas.Series = None
    ) -> pandas.Series:
        """Fit the model and return the aggregated segmentations.
        Args:
            data (DataFrame): Workers' segmentations.
                A pandas.DataFrame containing `worker`, `task` and `segmentation` columns'.

            skills (Series): workers' skills.
                A pandas.Series index by workers and holding corresponding worker's skill
        Returns:
            Series: Tasks' segmentations.
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's aggregated segmentation.
        """
        ...

    def __init__(
        self,
        on_missing_skill: str = 'error',
        default_skill: typing.Optional[float] = None
    ) -> None:
        """Method generated by attrs for class SegmentationMajorityVote.
        """
        ...

    segmentations_: pandas.Series
    on_missing_skill: str
    default_skill: typing.Optional[float]
