__all__ = [
    'SegmentationRASA',
]
import crowdkit.aggregation.base
import pandas
import typing


class SegmentationRASA(crowdkit.aggregation.base.BaseImageSegmentationAggregator):
    """Segmentation RASA - chooses a pixel if sum of weighted votes of each workers' more than 0.5.

    Algorithm works iteratively, at each step, the workers are reweighted in proportion to their distances
    to the current answer estimation. The distance is considered as $1 - IOU$. Modification of the RASA method
    for texts.

    Jiyi Li.
    A Dataset of Crowdsourced Word Sequences: Collections and Answer Aggregation for Ground Truth Creation.
    *Proceedings of the First Workshop on Aggregating and Analysing Crowdsourced Annotations for NLP*,
    pages 24–28 Hong Kong, China, November 3, 2019.
    <https://doi.org/10.18653/v1/D19-5904>

    Args:
        n_iter: A number of iterations.

    Examples:
        >>> import numpy as np
        >>> import pandas as pd
        >>> from crowdkit.aggregation import SegmentationRASA
        >>> df = pd.DataFrame(
        >>>     [
        >>>         ['t1', 'p1', np.array([[1, 0], [1, 1]])],
        >>>         ['t1', 'p2', np.array([[0, 1], [1, 1]])],
        >>>         ['t1', 'p3', np.array([[0, 1], [1, 1]])]
        >>>     ],
        >>>     columns=['task', 'worker', 'segmentation']
        >>> )
        >>> result = SegmentationRASA().fit_predict(df)
    Attributes:
        segmentations_ (Series): Tasks' segmentations.
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's aggregated segmentation.
    """

    def fit(self, data: pandas.DataFrame) -> 'SegmentationRASA':
        """Fit the model.
        Args:
            data (DataFrame): Workers' segmentations.
                A pandas.DataFrame containing `worker`, `task` and `segmentation` columns'.

        Returns:
            SegmentationRASA: self.
        """
        ...

    def fit_predict(self, data: pandas.DataFrame) -> pandas.Series:
        """Fit the model and return the aggregated segmentations.
        Args:
            data (DataFrame): Workers' segmentations.
                A pandas.DataFrame containing `worker`, `task` and `segmentation` columns'.

        Returns:
            Series: Tasks' segmentations.
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's aggregated segmentation.
        """
        ...

    def __init__(
        self,
        n_iter: int = 10,
        tol: float = 1e-05
    ) -> None:
        """Method generated by attrs for class SegmentationRASA.
        """
        ...

    segmentations_: pandas.Series
    n_iter: int
    tol: float
    loss_history_: typing.List[float]
