__all__ = [
    'TextSummarization',
]
import crowdkit.aggregation.base
import pandas
import transformers.modeling_utils
import transformers.tokenization_utils
import typing


class TextSummarization(crowdkit.aggregation.base.BaseTextsAggregator):
    """Text Aggregation through Summarization

    The method uses a pre-trained language model for summarization to aggregate crowdsourced texts.
    For each task, texts are concateneted by ` | ` token and passed as a model's input. If
    `n_permutations` is not `None`, texts are random shuffled `n_permutations` times and then
    outputs are aggregated with `permutation_aggregator` if provided. If `permutation_aggregator`
    is not provided, the resulting aggregate is the most common output over permuted inputs.

    **To use pretrained model and tokenizer from `transformers`, you need to install [torch](https://pytorch.org/get-started/locally/#start-locally)**

    M. Orzhenovskii,
    "Fine-Tuning Pre-Trained Language Model for Crowdsourced Texts Aggregation,"
    Proceedings of the 2nd Crowd Science Workshop: Trust, Ethics, and Excellence in Crowdsourced Data Management at Scale, 2021, pp. 8-14.
    <https://ceur-ws.org/Vol-2932/short1.pdf>

    S. Pletenev,
    "Noisy Text Sequences Aggregation as a Summarization Subtask,"
    Proceedings of the 2nd Crowd Science Workshop: Trust, Ethics, and Excellence in Crowdsourced Data Management at Scale, 2021, pp. 15-20.
    <https://ceur-ws.org/Vol-2932/short2.pdf>

    Args:
        tokenizer: [Pre-trained tokenizer](https://huggingface.co/transformers/main_classes/tokenizer.html#pretrainedtokenizer).
        model: [Pre-trained model](https://huggingface.co/transformers/main_classes/model.html#pretrainedmodel) for text summarization.
        concat_token: Token used for the workers' texts concatenation.
            Default value: ` | `.
        num_beams: Number of beams for beam search. 1 means no beam search.
            Default value: `16`.
        n_permutations: Number of input permutations to use. If `None`, use a single permutation according to the input's order.
            Default value: `None`.
        permutation_aggregator: Text aggregation method to use for aggregating outputs of multiple input permutations if `use_permutations` flag is set.
            Default value: `None`.
        device: Device to use such as `cpu` or `cuda`.
            Default value: `cpu`.
    Example:
        >>> import torch
        >>> from transformers import AutoModelForSeq2SeqLM, AutoTokenizer, AutoConfig
        >>> from crowdkit.aggregation import TextSummarization
        >>> device = 'cuda' if torch.cuda.is_available() else 'cpu'
        >>> mname = "toloka/t5-large-for-text-aggregation"
        >>> tokenizer = AutoTokenizer.from_pretrained(mname)
        >>> model = AutoModelForSeq2SeqLM.from_pretrained(mname)
        >>> agg = TextSummarization(tokenizer, model, device=device)
        >>> result = agg.fit_predict(df)
        ...
    Attributes:
        texts_ (Series): Tasks' texts.
            A pandas.Series indexed by `task` such that `result.loc[task, text]`
            is the task's text.
    """

    def fit_predict(self, data: pandas.DataFrame) -> pandas.Series:
        """Run the aggregation and return the aggregated texts.
        Args:
            data (DataFrame): Workers' text outputs.
                A pandas.DataFrame containing `task`, `worker` and `text` columns.
        Returns:
            Series: Tasks' texts.
                A pandas.Series indexed by `task` such that `result.loc[task, text]`
                is the task's text.
        """
        ...

    def __init__(
        self,
        tokenizer: transformers.tokenization_utils.PreTrainedTokenizer,
        model: transformers.modeling_utils.PreTrainedModel,
        concat_token: str = ' | ',
        num_beams: int = 16,
        n_permutations: typing.Optional[int] = None,
        permutation_aggregator: typing.Optional[crowdkit.aggregation.base.BaseTextsAggregator] = None,
        device: str = 'cpu'
    ) -> None:
        """Method generated by attrs for class TextSummarization.
        """
        ...

    texts_: pandas.Series
    tokenizer: transformers.tokenization_utils.PreTrainedTokenizer
    model: transformers.modeling_utils.PreTrainedModel
    concat_token: str
    num_beams: int
    n_permutations: typing.Optional[int]
    permutation_aggregator: typing.Optional[crowdkit.aggregation.base.BaseTextsAggregator]
    device: str
