# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2017-08-07 18:11
from __future__ import unicode_literals
from django.conf import settings
from django.db import migrations

from dir_data_sync import OPERATING_MODE_NAMES


def init_operating_mode(apps, schema_editor):

    OperatingModeModel = apps.get_model("dir_data_sync", "OperatingMode")
    OperatingModeModel.objects.create(
        name=OPERATING_MODE_NAMES.free,
        limits=settings.DIRSYNC_OPERATING_MODE_LIMITS_BY_MODE_NAME[OPERATING_MODE_NAMES.free]
    )
    OperatingModeModel.objects.create(
        name=OPERATING_MODE_NAMES.paid,
        limits=settings.DIRSYNC_OPERATING_MODE_LIMITS_BY_MODE_NAME[OPERATING_MODE_NAMES.paid]
    )


def remove_operating_mode(apps, schema_editor):
    OperatingModeModel = apps.get_model("dir_data_sync", "OperatingMode")
    OperatingModeModel.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('dir_data_sync', '0007_add_operatingmode_and_orgstatistics'),
    ]

    operations = [
        migrations.RunPython(init_operating_mode, remove_operating_mode),
    ]
