# django-celery-monitoring

Библиотека позволяет мониторить упавшие celery-таски,
используя django-celery-results (django-db бэкенд), а также перезапускать их из django-админки.

Перезапуск работает только для тасков с аргументами, сериализуемыми через json.

## Как подключить?

* Нужно, чтобы бэкендом для celery-results был `django-db` – в конфигах `CELERY_RESULT_BACKEND = 'django-db'`
* Добавить `django_celery_monitoring` в `INSTALLED_APPS`
* Добавить в `urls.py` url до вьюхи `django_celery_monitoring.views.MonitoringCeleryView`.
Вьюха отдаёт 200, если упавших тасков нет, 400 – если есть.
* Настроить проверку juggler, на этот url

## Перезапуск тасков

В админке есть действие "перезапустить". 
Это корректно работает, только если аргументы можно сериализовать через json. 
Идеально, если `CELERY_TASK_SERIALIZER = 'json'` (по умолчанию в celery >= 4)

Перезапуск работает только для упавших тасков. 

Есть возможность перезапускать celery chain,
начиная с упавшего таска (если в chain все таски immutable)
Для этого нужно:
* Задать в конфигах расширенный бэкенд для результатов `CELERY_RESULT_BACKEND = 'django-db-ext'`, 
для проектов в Аркадии надо указать полный путь до бэкенда `CELERY_RESULT_BACKEND = 'django_celery_monitoring.backends:DatabaseExtendedBackend'`
* Добавить в основной класс таска миксин `django_celery_monitoring.mixins.CachedChainTaskMixin`

## Дополнительные возможности

### Удаление старых успешных тасков
* В конфигах указываем кол-во дней, после которых успешно выполненные таски удалятся
```python
CELERY_MONITORING_EXPIRE_DAYS = 30  # по умолчанию 7
```
* Добавляем куда-нибудь в cron функцию `django_celery_monitoring.utils.clean_old_celery_results`

### Автоматический фейл зависших тасков
Чтобы таски, зависшие более чем на сутки, не пропадали из поля зрения,
можно сделать так, чтобы они автоматом "падали" и попадали на мониторинги.
Для этого добавляем в cron функцию `django_celery_monitoring.utils.fail_aborted_celery_results`,
например, на каждый час.

Лучше использовать вместе с конфигом `CELERY_TRACK_STARTED = True`,
благодаря которому таски попадают в БД сразу после начала выполнения.

### Скрытие тасков с мониторов (mute)
В админке есть возможность скрыть конкретный таск с мониторов,
а также скрыть все таски какого-либо типа.
