# coding: utf-8

from __future__ import unicode_literals

from ids.registry import registry
from .base import DirectoryStaticRepository


@registry.add_simple
class SingleUserRepository(DirectoryStaticRepository):
    # документация АПИ – https://api.directory.ws.yandex.ru/docs/playground.html#spisok-sotrudnikov

    RESOURCES = 'single_user'

    def getiter_from_service(self, lookup):
        uid = lookup.pop('uid')
        return self.connector.get(
            resource=self.RESOURCES,
            params=lookup,
            url_vars={'uid': uid}
        )
