# Общее описание

django-tanker — это приложение для интеграции с Танкером: загрузки и выгрузки
переводов.

Система работает поверх стандарной джанговской интернационализации/локализации.

Для подготовки проекта к переводу следует воспользоваться документацией
https://docs.djangoproject.com/en/dev/topics/i18n/translation/


# Настройка

В settings.py проекта необходимо добавить `django_tanker` в `INSTALLED_APPS`:

    INSTALLED_APPS = [
        ...
        'django_tanker',
        ...
    ]

В конце settings.py нужно добавить импорт дефолтных настроек django_tanker:

    from django_tanker.settings import *

Далее необходимо указать project_id, название кейсета для проекта:

    TANKER_ID = 'tv'
    TANKER_KEYSET = 'веб-морда'

Далее опционально указываем ветку или ревизию в танкере, которую
использовать для работы с переводами:

    TANKER_REVISION = 'master'  # если используете master, то можно не указывать настройку

Остальные возможные настройки и их описания можно узнать в самом модуле
`django_tanker.settings`

## Кейсеты для приложений

Если в проекте есть свои локальные приложения, то в них тоже может быть свой набор
переводов. Чтобы указать кейсеты для этих переводов, существует настройка `TANKER_APP_KEYSETS`:

    TANKER_APP_KEYSETS = {
        'cray': 'app',
    }

где 'cray' — это имя приложения, а 'app' — это название кейсета, куда будут загружены
ключи этого приложения для перевода.

## Рекомендации по разделению проекта на кейсеты

Оптимальней всего заводить отдельные кейсты для каждого приложения в проекте.
Для самого проекта тоже иметь отдельный кейсет — в нем скорей всего будут
ключи из шаблонов.

## Обработка не только `django.po` файлов

В качестве `TANKER_KEYSET` (и значений в `TANKER_APP_KEYSETS`) может выступать дикт,
где ключами являются имена *.po файлов, а значениями -- имя кейсета,
куда данные из этого файла загружаются:

    TANKER_KEYSET = {'django.po': 'веб-морда',
                     'djangojs.po': 'js веб-морды'}


# Перевод проекта


## Первичная загрузка данных для перевода

Для начала надо запустить краулер над кодом проекта, чтобы он собрал все обернутые
в вызовы gettext строки и создал исходные *.po файлы. Это нужно проделать для
всех языков, которые доожен поддерживать сервис. Для этого используется команда:

    $ ./manage.py makemessages -l [ru, uk, ...]

После того, как исходные файлы для перевода созданы, их можно загрузить в Танкер.
При этом будут созданы кейсеты в соответствии с настройками. Для этого в
django-tanker есть специальная команда `tankerupload`:

    $ ./manage.py tankerupload


## Выгрузка перевода

После того, как вы получили нотификацию о том, что перевод готов, его можно
выгрузить:

    $ ./manage.py tankerdownload

После того, как команда отработает, *.po файлы обновятся, и в них будет
содержаться актуальный перевод.

Далее необходимо скомпилировать обновленные файлы перевода:

    $ ./manage.py compilemessages

Теперь можно коммитить результат в свой VCS и закатывать пакет.

## Создание ветки в танкере

Если вам нужна ветка в танкере, ее можно создать

    $ ./manage.py tankerputbranch  --branch='branch name' --from='master'

Cоздает ветку "branch name", если ее не было. Печатает в stdout последний ref в этой ветке.

## Удаление ветки в танкере

    $ ./manage.py tankerputbranch  --branch='branch name'

Удаляем ветку "branch name"

## Обновление файлов перевода

Принцип повседневной работы с Танкером очень похож на работу с VCS.

Забрать внешние изменения, накатить свои изменения и отправить результат в
Танкер. В общем виде это выражается такой последовательностью команд:

    $ ./manage.py tankerdownload
    $ ./manage.py makemessages -a
    $ ./manage.py tankerupload

