# Balance
`toloka.metrics.metrics.Balance` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/metrics.py#L143)

```python
Balance(
    self,
    balance_name: Optional[str] = None,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Traking your Toloka balance.


Returns only one metric: don't spend and don't reserved money on your acount.

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`balance_name`|**Optional\[str\]**|<p>Metric name. Default &#x27;toloka_requester_balance&#x27;.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector([Balance(toloka_client=toloka_client)], print_metric)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.metrics.Balance.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
