# NewMessageThreads
`toloka.metrics.metrics.NewMessageThreads` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/metrics.py#L342)

```python
NewMessageThreads(
    self,
    count_name: Optional[str] = None,
    projects_name: Dict[str, str] = ...,
    pools_name: Dict[str, str] = ...,
    join_events: bool = False,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Tracking the new messages


Could count messages in projects or pools. If you want to track messages count in several projects/pools, don't get several
NewMessageThreads instance. You can gather all in one instance.

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`count_name`|**Optional\[str\]**|<p>Metric name for a count of new messages.</p>
`projects_name`|**Dict\[str, str\]**|<p>Dictionary that allows count messages on exact projects. {project_id: line_name}</p>
`pools_name`|**Dict\[str, str\]**|<p>Dictionary that allows count messages on exact pools. {pool_id: line_name}</p>
`join_events`|**bool**|<p>Count all events in one point. Default False. &quot;Values&quot; never join.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector
(
    [
        NewMessageThreads(
            toloka_client=toloka_client,
            count_name='messages_count'
            pools_name={'123': 'my_train_pool', '456': 'my_working_pool'},
            projects_name={'01': 'pedestrian_proj', '02': 'checking_proj'},
            join_events=True,
        )
    ],
    print_metric
)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.metrics.NewMessageThreads.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
