# NewUserBonuses
`toloka.metrics.metrics.NewUserBonuses` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/metrics.py#L185)

```python
NewUserBonuses(
    self,
    count_name: Optional[str] = None,
    money_name: Optional[str] = None,
    join_events: bool = False,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Tracking the new user bonuses - count or money amount.

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`count_name`|**Optional\[str\]**|<p>Metric name for a count of new bonuses.</p>
`money_name`|**Optional\[str\]**|<p>Metric name for amount of money in new bonuses.</p>
`join_events`|**bool**|<p>Count all events in one point.  Default False.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector([NewUserBonuses(toloka_client=toloka_client)], print_metric)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.metrics.NewUserBonuses.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
