# NewUserSkills
`toloka.metrics.metrics.NewUserSkills` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/metrics.py#L259)

```python
NewUserSkills(
    self,
    skill_id: str,
    count_name: Optional[str] = None,
    value_name: Optional[str] = None,
    join_events: bool = False,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Tracking the new user skill values

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`skill_id`|**str**|<p>Which skill we will be tracking.</p>
`count_name`|**Optional\[str\]**|<p>Metric name for a count of new skill assignments. When skill changes it counts to.</p>
`value_name`|**Optional\[str\]**|<p>Metric name for exact values of new skill level for each skill assignment. It could be useful to track mean value or some medians.</p>
`join_events`|**bool**|<p>Count all events in one point.  Default False. &quot;Values&quot; never join.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector
(
    [
        NewUserSkills(
            toloka_client=toloka_client,
            count_name='count',
            value_name='values',
        )
    ],
    print_metric
)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.metrics.NewUserSkills.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
