# AssignmentsInPool
`toloka.metrics.pool_metrics.AssignmentsInPool` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/pool_metrics.py#L201)

```python
AssignmentsInPool(
    self,
    pool_id: str,
    submitted_name: Optional[str] = None,
    accepted_name: Optional[str] = None,
    rejected_name: Optional[str] = None,
    skipped_name: Optional[str] = None,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Tracking the count of assignments in different states in the pool.


Metrics starts gathering if they name are set. If the metric name is set to None, they don't gathering.

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`pool_id`|**str**|<p>From which pool track metrics.</p>
`submitted_name`|**Optional\[str\]**|<p>Metric name for a count of submitted assignments. Default &#x27;submitted_assignments_in_pool&#x27;.</p>
`accepted_name `|**-**|<p>Metric name for a count of accepted assignments. Default &#x27;accepted_assignments_in_pool&#x27;.</p>
`rejected_name `|**-**|<p>Metric name for a count of rejected assignments. Default &#x27;rejected_assignments_in_pool&#x27;.</p>
`skipped_name`|**Optional\[str\]**|<p>Metric name for a count of skipped assignments. Default None.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector([AssignmentsInPool(pool_id, toloka_client=toloka_client)], print_metric)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.pool_metrics.AssignmentsInPool.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
