# PoolCompletedPercentage
`toloka.metrics.pool_metrics.PoolCompletedPercentage` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/pool_metrics.py#L155)

```python
PoolCompletedPercentage(
    self,
    pool_id: str,
    percents_name: Optional[str] = None,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

Track pool completion in percentage


You can't gather this metric from a pool with infinite task suites. For example, if you have infinite overlap on a pool.

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`pool_id`|**str**|<p>From which pool track metrics.</p>
`percents_name`|**Optional\[str\]**|<p>Metric name for pool completion percentage. Default &#x27;completion_percentage&#x27;.</p>
`toloka_client`|**Optional\[[TolokaClient](toloka.client.TolokaClient.md)\]**|<p>Client for connection to Toloka. You can set toloka_client for several metrics via &quot;bind_client&quot; function.</p>

**Examples:**

How to collect this metric:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector([PoolCompletedPercentage(pool_id, toloka_client=toloka_client)], print_metric)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.pool_metrics.PoolCompletedPercentage.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
