# WorkersByFilterOnPool
`toloka.metrics.pool_metrics.WorkersByFilterOnPool` | [Source code](https://github.com/Toloka/toloka-kit/blob/v0.1.26/src/metrics/pool_metrics.py#L374)

```python
WorkersByFilterOnPool(
    self,
    pool_id: str,
    workers_name: Optional[str] = None,
    interval_hours: int = 1,
    *,
    toloka_client: Optional[TolokaClient] = None,
    atoloka_client: Optional[AsyncTolokaClient] = None,
    timeout: timedelta = ...
)
```

The number of active performers matching the pool filters for the last hours (default 1 hour)

## Parameters Description

| Parameters | Type | Description |
| :----------| :----| :-----------|
`pool_id`|**str**|<p>From which pool track metrics.</p>
`workers_name`|**Optional\[str\]**|<p>Metric name for a count of workers.</p>
`interval_hours`|**int**|<p>Counts unical workers on this hours interval. Default 1.</p>

**Examples:**

How to collect this metrics:
```python
def print_metric(metric_dict):
    print(metric_dict)
collector = MetricCollector([WorkersByFilterOnPool(pool_id, toloka_client=toloka_client)], print_metric)
asyncio.run(collector.run())
```
## Methods Summary

| Method | Description |
| :------| :-----------|
[get_line_names](toloka.metrics.pool_metrics.WorkersByFilterOnPool.get_line_names.md)| Returns a list of metric names that can be generated by this class instance.
