"""Module for aggregating results

For example, when you need to decide whether a cat or a dog is in the picture, and you ask more than one performers.
In this case, you need to decide on the final answer and sometimes calculate the probability. This module will help you do this.
Aggregation works on the Toloka server side.

In these cases, we strongly recommend using our [crowd-kit](https://github.com/Toloka/crowd-kit) solution.
It will allow you to:
- use more different aggregation methods,
- perform aggregation on your side
"""

__all__ = [
    'AggregatedSolutionType',
    'PoolAggregatedSolutionRequest',
    'TaskAggregatedSolutionRequest',
    'WeightedDynamicOverlapTaskAggregatedSolutionRequest',
    'AggregatedSolution',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class AggregatedSolutionType(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    WEIGHTED_DYNAMIC_OVERLAP = 'WEIGHTED_DYNAMIC_OVERLAP'
    DAWID_SKENE = 'DAWID_SKENE'


class PoolAggregatedSolutionRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Request that allows you to aggregate results in a specific pool

    Responses to all completed tasks will be aggregated.
    See an example of how to use it in "TolokaClient.aggregate_solutions_by_pool".

    Attributes:
        type: Aggregation type.
            WEIGHTED_DYNAMIC_OVERLAP - Aggregation of responses in a pool with dynamic overlap.
            DAWID_SKENE - Dawid-Skene aggregation model.
                A. Philip Dawid and Allan M. Skene. 1979.
                Maximum Likelihood Estimation of Observer Error-Rates Using the EM Algorithm.
                Journal of the Royal Statistical Society. Series C (Applied Statistics), Vol. 28, 1 (1979), 20–28.
                [https://doi.org/10.2307/2346806](https://doi.org/10.2307/2346806)
        pool_id: In which pool to aggregate the results.
        answer_weight_skill_id: A skill that determines the weight of the performer's response.
        fields: Output data fields to use for aggregating responses. For best results, each of these fields
            must have a limited number of response options.
    """

    class Field(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(self, *, name: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class PoolAggregatedSolutionRequest.Field.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        name: typing.Optional[str]

    def __init__(
        self,
        *,
        type: typing.Union[AggregatedSolutionType, str, None] = None,
        pool_id: typing.Optional[str] = None,
        answer_weight_skill_id: typing.Optional[str] = None,
        fields: typing.Optional[typing.List[Field]] = None
    ) -> None:
        """Method generated by attrs for class PoolAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    type: typing.Optional[AggregatedSolutionType]
    pool_id: typing.Optional[str]
    answer_weight_skill_id: typing.Optional[str]
    fields: typing.Optional[typing.List[Field]]


class TaskAggregatedSolutionRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Base class for run aggregation on a single task

    Attributes:
        task_id: Answers for which task to aggregate.
        pool_id: In which pool this task.
    """

    def __init__(
        self,
        *,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class TaskAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]


class WeightedDynamicOverlapTaskAggregatedSolutionRequest(TaskAggregatedSolutionRequest):
    """Request that allows you to run WeightedDynamicOverlap aggregation on a single task

    Attributes:
        task_id: Answers for which task to aggregate.
        pool_id: In which pool this task.
        answer_weight_skill_id: A skill that determines the weight of the performer's response.
        fields: Output data fields to use for aggregating responses. For best results, each of these fields
            must have a limited number of response options.
    """

    class Field(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(self, *, name: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class WeightedDynamicOverlapTaskAggregatedSolutionRequest.Field.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        name: typing.Optional[str]

    def __init__(
        self,
        *,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        answer_weight_skill_id: typing.Optional[str] = None,
        fields: typing.Optional[typing.List[Field]] = None
    ) -> None:
        """Method generated by attrs for class WeightedDynamicOverlapTaskAggregatedSolutionRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    answer_weight_skill_id: typing.Optional[str]
    fields: typing.Optional[typing.List[Field]]


class AggregatedSolution(toloka.client.primitives.base.BaseTolokaObject):
    """Aggregated response to the task

    Attributes:
        pool_id: In which pool the results were aggregated.
        task_id: The answer for which task was aggregated.
        confidence: Confidence in the aggregate response.
        output_values: Output data fields and aggregate response.
    """

    def __init__(
        self,
        *,
        pool_id: typing.Optional[str] = None,
        task_id: typing.Optional[str] = None,
        confidence: typing.Optional[float] = None,
        output_values: typing.Optional[typing.Dict[str, typing.Any]] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolution.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    pool_id: typing.Optional[str]
    task_id: typing.Optional[str]
    confidence: typing.Optional[float]
    output_values: typing.Optional[typing.Dict[str, typing.Any]]
