__all__ = [
    'AppProject',
    'App',
    'AppItem',
    'AppItemsCreateRequest',
    'AppBatch',
    'AppBatchCreateRequest',
]
import datetime
import decimal
import toloka.client.primitives.base
import toloka.client.project.field_spec
import toloka.util._extendable_enum
import typing


class _AppError(toloka.client.primitives.base.BaseTolokaObject):
    """Attributes:
        code: String error code.
        message: Detailed description of the error.
        payload: Additional information about the error. May have different structure for different errors.
    """

    def __init__(
        self,
        *,
        code: typing.Optional[str] = None,
        message: typing.Optional[str] = None,
        payload: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class _AppError.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class AppProject(toloka.client.primitives.base.BaseTolokaObject):
    """An App project with the parameters that you specify when creating it. It will have the interface and quality
    control already pre-configured, decomposition done, and everything ready to use: all you need is to upload batches
    and send them for labeling.

    Attributes:
        app_id:
        parent_app_project_id:
        name:
        parameters:
        id:
        status: Project statuses for asynchronous creation. Allowed values:
            * CREATING
            * READY
            * ARCHIVE
            * ERROR
        created:
        item_price:
        errors:
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        CREATING = 'CREATING'
        READY = 'READY'
        ARCHIVED = 'ARCHIVED'
        ERROR = 'ERROR'

    def __init__(
        self,
        *,
        app_id: typing.Optional[str] = None,
        parent_app_project_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        parameters: typing.Optional[typing.Dict] = None,
        id: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        created: typing.Optional[datetime.datetime] = None,
        item_price: typing.Optional[decimal.Decimal] = None,
        errors: typing.Optional[typing.List[_AppError]] = None
    ) -> None:
        """Method generated by attrs for class AppProject.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    app_id: typing.Optional[str]
    parent_app_project_id: typing.Optional[str]
    name: typing.Optional[str]
    parameters: typing.Optional[typing.Dict]
    id: typing.Optional[str]
    status: typing.Optional[Status]
    created: typing.Optional[datetime.datetime]
    item_price: typing.Optional[decimal.Decimal]
    errors: typing.Optional[typing.List[_AppError]]


class App(toloka.client.primitives.base.BaseTolokaObject):
    """An example of a standard task that you want to solve using Toloka. Unlike project templates, you don't have to
    set up everything yourself.

    Attributes:
        id: ID of the App.
        name:
        image: Image.
        description: Overview.
        constraints_description: Description of limitations.
        default_item_price: Default processing cost per work item.
        param_spec: Specification of parameters for creating a project.
        input_spec: Schema of input data in Toloka format.
        output_spec: Schema of output data in Toloka format.
        examples: Task examples.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        image: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        constraints_description: typing.Optional[str] = None,
        default_item_price: typing.Optional[decimal.Decimal] = None,
        param_spec: typing.Optional[typing.Dict] = None,
        input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        examples: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class App.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    name: typing.Optional[str]
    image: typing.Optional[str]
    description: typing.Optional[str]
    constraints_description: typing.Optional[str]
    default_item_price: typing.Optional[decimal.Decimal]
    param_spec: typing.Optional[typing.Dict]
    input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    examples: typing.Optional[typing.Any]


class AppItem(toloka.client.primitives.base.BaseTolokaObject):
    """A work item with data. It's uploaded into the batch with other items to be collectively sent for labeling.
    In a TSV file with tasks, each line is a work item.

    Attributes:
        batch_id: ID of the batch that includes the item.
        input_data: The item data following the App schema.
        id: Item ID.
        app_project_id: ID of the app project that includes the batch with this item.
        created:
        updated:
        status: Processing status. If the item has the NEW status, it can be edited. In other statuses, the item is
            immutable. Allowed values:
            * NEW - new;
            * PROCESSING - being processed;
            * COMPLETED - processing complete;
            * ERROR - error during processing;
            * CANCELLED - processing canceled;
            * ARCHIVE - item has been archived;
            * NO_MONEY - not enough money for processing.
        output_data: Processing result.
        errors:
        created_at: Date and time when the item was created.
        started_at: Date and time when the item processing started.
        finished_at: Date and time when the item processing was completed.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        NEW = 'NEW'
        PROCESSING = 'PROCESSING'
        COMPLETED = 'COMPLETED'
        ERROR = 'ERROR'
        CANCELLED = 'CANCELLED'
        ARCHIVE = 'ARCHIVE'
        NO_MONEY = 'NO_MONEY'

    def __init__(
        self,
        *,
        batch_id: typing.Optional[str] = None,
        input_data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        id: typing.Optional[str] = None,
        app_project_id: typing.Optional[str] = None,
        created: typing.Optional[datetime.datetime] = None,
        updated: typing.Optional[datetime.datetime] = None,
        status: typing.Union[Status, str, None] = None,
        output_data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        errors: typing.Optional[typing.List[_AppError]] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        started_at: typing.Optional[datetime.datetime] = None,
        finished_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppItem.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    batch_id: typing.Optional[str]
    input_data: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    app_project_id: typing.Optional[str]
    created: typing.Optional[datetime.datetime]
    updated: typing.Optional[datetime.datetime]
    status: typing.Optional[Status]
    output_data: typing.Optional[typing.Dict[str, typing.Any]]
    errors: typing.Optional[typing.List[_AppError]]
    created_at: typing.Optional[datetime.datetime]
    started_at: typing.Optional[datetime.datetime]
    finished_at: typing.Optional[datetime.datetime]


class AppItemsCreateRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Request Body.

    Attributes:
        batch_id: Batch ID.
        items: list of items.
    """

    def __init__(
        self,
        *,
        batch_id: typing.Optional[str] = None,
        items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = None
    ) -> None:
        """Method generated by attrs for class AppItemsCreateRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    batch_id: typing.Optional[str]
    items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]]


class AppBatch(toloka.client.primitives.base.BaseTolokaObject):
    """A batch of data that you send for labeling at a time. The batch consists of work items.

    Attributes:
        id: Batch ID.
        app_project_id: Project ID.
        name:
        status: The state of the batch, calculated based on the states of items comprising it. Allowed values:
            * NEW
            * PROCESSING
            * COMPLETED
            * ERROR
            * CANCELLED
            * ARCHIVE
            * NO_MONEY
        items_count: Number of items in the batch.
        item_price: The cost of processing per item in a batch.
        cost: The cost of processing per batch.
        created_at: Date and time when the batch was created.
        started_at: Date and time when batch processing started.
        finished_at: Date and time when batch processing was completed.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        NEW = 'NEW'
        PROCESSING = 'PROCESSING'
        COMPLETED = 'COMPLETED'
        ERROR = 'ERROR'
        CANCELLED = 'CANCELLED'
        ARCHIVE = 'ARCHIVE'
        NO_MONEY = 'NO_MONEY'

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        app_project_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        items_count: typing.Optional[int] = None,
        item_price: typing.Optional[decimal.Decimal] = None,
        cost: typing.Optional[decimal.Decimal] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        started_at: typing.Optional[datetime.datetime] = None,
        finished_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppBatch.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    app_project_id: typing.Optional[str]
    name: typing.Optional[str]
    status: typing.Optional[Status]
    items_count: typing.Optional[int]
    item_price: typing.Optional[decimal.Decimal]
    cost: typing.Optional[decimal.Decimal]
    created_at: typing.Optional[datetime.datetime]
    started_at: typing.Optional[datetime.datetime]
    finished_at: typing.Optional[datetime.datetime]


class AppBatchCreateRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Request Body.

    Attributes:
        items: The item data following the App schema.
    """

    def __init__(self, *, items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = None) -> None:
        """Method generated by attrs for class AppBatchCreateRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]]
