__all__ = [
    'RecipientsSelectType',
    'Folder',
    'Interlocutor',
    'MessageThread',
    'MessageThreadReply',
    'MessageThreadFolders',
    'MessageThreadCompose',
]
import datetime
import toloka.client.filter
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class RecipientsSelectType(toloka.util._extendable_enum.ExtendableStrEnum):
    """Method for specifying recipients.

    Attributes:
        DIRECT: specify user IDs.
        FILTER: select users using filter.
        ALL: send a message to all users who have tried to complete your tasks at least once.
    """

    DIRECT = 'DIRECT'
    FILTER = 'FILTER'
    ALL = 'ALL'


class Folder(toloka.util._extendable_enum.ExtendableStrEnum):
    """Folders for a thread.
    """

    INBOX = 'INBOX'
    OUTBOX = 'OUTBOX'
    AUTOMATIC_NOTIFICATION = 'AUTOMATIC_NOTIFICATION'
    IMPORTANT = 'IMPORTANT'
    UNREAD = 'UNREAD'


class Interlocutor(toloka.client.primitives.base.BaseTolokaObject):
    """Information about the sender or recipient.

    Attributes:
        id: ID of the sender or recipient.
        role: Role of the sender or recipient in Toloka.
        myself: Marks a sender or recipient with your ID. f the ID belongs to you, the value is specified true.
    """

    class InterlocutorRole(toloka.util._extendable_enum.ExtendableStrEnum):
        """Role of the sender or recipient in Toloka.

        Attributes:
            USER: Performer.
            REQUESTER: Customer.
            ADMINISTRATOR: Administrator.
            SYSTEM: For messages sent automatically.
        """

        USER = 'USER'
        REQUESTER = 'REQUESTER'
        ADMINISTRATOR = 'ADMINISTRATOR'
        SYSTEM = 'SYSTEM'

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        role: typing.Union[InterlocutorRole, str, None] = None,
        myself: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class Interlocutor.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    role: typing.Optional[InterlocutorRole]
    myself: typing.Optional[bool]


class MessageThread(toloka.client.primitives.base.BaseTolokaObject):
    """Message thread.

    The sent message is added to the new message thread. Until the first response is received the message chain is in
    the folder UNREAD. If there are several addresses in the chain and one of them responds, a new message chain
    will be created
    Attributes:
        id: Message thread ID.
        topic: Message thread title.
        interlocutors_inlined: Access information about the sender and recipients.
            * True - information is available in the field interlocutors.
            * False - information is available on a separate request.
        interlocutors: Information about the sender and recipients, sorted by IDs.
        messages_inlined: Access to message threads:
            * True — The message is available in the messages field.
            * False — The message is available in a separate request.
        messages: Messages in the thread. Sorted by creation date (new first).
        meta: Meta
        answerable: Ability to reply to a message:
            * True — The performer can respond to the message.
            * False — The performer cannot respond to the message.
        folders: Folders where the thread is located.
        compose_details: For messages that you sent: details of the POST request for creating the message.
        created: The date the first message in the chain was created.
    """

    class ComposeDetails(toloka.client.primitives.base.BaseTolokaObject):
        """For messages that you sent: details of the POST request for creating the message.

        Attributes:
            recipients_select_type: Method for specifying recipients.
            recipients_ids: List of recipients IDs.
            recipients_filter: Condition to filter recipients.
        """

        def __init__(
            self,
            *,
            recipients_select_type: typing.Union[RecipientsSelectType, str, None] = None,
            recipients_ids: typing.Optional[typing.List[str]] = None,
            recipients_filter: typing.Optional[toloka.client.filter.FilterCondition] = None
        ) -> None:
            """Method generated by attrs for class MessageThread.ComposeDetails.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        recipients_select_type: typing.Optional[RecipientsSelectType]
        recipients_ids: typing.Optional[typing.List[str]]
        recipients_filter: typing.Optional[toloka.client.filter.FilterCondition]

    class Meta(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(
            self,
            *,
            pool_id: typing.Optional[str] = None,
            project_id: typing.Optional[str] = None,
            assignment_id: typing.Optional[str] = None
        ) -> None:
            """Method generated by attrs for class MessageThread.Meta.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        pool_id: typing.Optional[str]
        project_id: typing.Optional[str]
        assignment_id: typing.Optional[str]

    class Message(toloka.client.primitives.base.BaseTolokaObject):
        """Message in the thread.

        Attributes:
            text: Message text.
            from_: Information about the sender.
            created: Date the message was created.
        """

        def __init__(
            self,
            *,
            text: typing.Optional[typing.Dict[str, str]] = None,
            from_: typing.Optional[Interlocutor] = None,
            created: typing.Optional[datetime.datetime] = None
        ) -> None:
            """Method generated by attrs for class MessageThread.Message.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        text: typing.Optional[typing.Dict[str, str]]
        from_: typing.Optional[Interlocutor]
        created: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        topic: typing.Optional[typing.Dict[str, str]] = None,
        interlocutors_inlined: typing.Optional[bool] = None,
        interlocutors: typing.Optional[typing.List[Interlocutor]] = None,
        messages_inlined: typing.Optional[bool] = None,
        messages: typing.Optional[typing.List[Message]] = None,
        meta: typing.Optional[Meta] = None,
        answerable: typing.Optional[bool] = None,
        folders: typing.Optional[typing.List[Folder]] = None,
        compose_details: typing.Optional[ComposeDetails] = None,
        created: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class MessageThread.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    topic: typing.Optional[typing.Dict[str, str]]
    interlocutors_inlined: typing.Optional[bool]
    interlocutors: typing.Optional[typing.List[Interlocutor]]
    messages_inlined: typing.Optional[bool]
    messages: typing.Optional[typing.List[Message]]
    meta: typing.Optional[Meta]
    answerable: typing.Optional[bool]
    folders: typing.Optional[typing.List[Folder]]
    compose_details: typing.Optional[ComposeDetails]
    created: typing.Optional[datetime.datetime]


class MessageThreadReply(toloka.client.primitives.base.BaseTolokaObject):
    """Reply to message thread.

    Attributes:
        text: Message text. You can provide text in several languages (the message will come in the user's language).
            Format: {"<language RU / EN/TR/ID / FR>": "<message text>"}.
    """

    def __init__(self, *, text: typing.Optional[typing.Dict[str, str]] = None) -> None:
        """Method generated by attrs for class MessageThreadReply.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    text: typing.Optional[typing.Dict[str, str]]


class MessageThreadFolders(toloka.client.primitives.base.BaseTolokaObject):
    """Add a message thread to one or more folders

    Attributes:
        folders: Folders to add/remove a message thread to/from.
    """

    def __init__(self, *, folders: typing.Optional[typing.List[Folder]] = None) -> None:
        """Method generated by attrs for class MessageThreadFolders.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    folders: typing.Optional[typing.List[Folder]]


class MessageThreadCompose(toloka.client.primitives.base.BaseTolokaObject):
    """Sent message to perfromer

    Attributes:
        recipients_select_type: Method for specifying recipients
        topic: Post title. You can provide a title in several languages (the message will come in the user's language).
            Format: "<language RU/EN/TR/ID/FR>": "<topic text>".
        text: Message text. You can provide text in several languages (the message will come in the user's language).
            Format: "<language RU/EN/TR/ID/FR>": "<message text>".
        answerable: Ability to reply to a message:
            * True — Users can respond to the message.
            * False — Users can't respond to the message.
        recipients_ids: List of IDs of users to whom the message will be sent.
        recipients_filter: Filter to select recipients.
    """

    def unstructure(self) -> typing.Optional[dict]: ...

    def __init__(
        self,
        *,
        recipients_select_type: typing.Union[RecipientsSelectType, str, None] = None,
        topic: typing.Optional[typing.Dict[str, str]] = None,
        text: typing.Optional[typing.Dict[str, str]] = None,
        answerable: typing.Optional[bool] = None,
        recipients_ids: typing.Optional[typing.List[str]] = None,
        recipients_filter: typing.Optional[toloka.client.filter.FilterCondition] = None
    ) -> None:
        """Method generated by attrs for class MessageThreadCompose.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    recipients_select_type: typing.Optional[RecipientsSelectType]
    topic: typing.Optional[typing.Dict[str, str]]
    text: typing.Optional[typing.Dict[str, str]]
    answerable: typing.Optional[bool]
    recipients_ids: typing.Optional[typing.List[str]]
    recipients_filter: typing.Optional[toloka.client.filter.FilterCondition]
