__all__ = [
    'BaseFieldV1',
    'AudioFieldV1',
    'ButtonRadioFieldV1',
    'GroupFieldOption',
    'ButtonRadioGroupFieldV1',
    'CheckboxFieldV1',
    'CheckboxGroupFieldV1',
    'DateFieldV1',
    'EmailFieldV1',
    'FileFieldV1',
    'ImageAnnotationFieldV1',
    'ListFieldV1',
    'MediaFileFieldV1',
    'NumberFieldV1',
    'PhoneNumberFieldV1',
    'RadioGroupFieldV1',
    'SelectFieldV1',
    'TextFieldV1',
    'TextAnnotationFieldV1',
    'TextareaFieldV1',
]
import toloka.client.project.template_builder.base
import toloka.util._extendable_enum
import typing


class BaseFieldV1Metaclass(toloka.client.project.template_builder.base.VersionedBaseComponentMetaclass):
    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        **kwargs
    ): ...


class BaseFieldV1(toloka.client.project.template_builder.base.BaseComponent, metaclass=BaseFieldV1Metaclass):
    """Fields for entering data, such as a text field or drop-down list.

    Attributes:
        data: Data with values that will be processed or changed.
        label: Label above the component.
        hint: Hint text.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class BaseFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]


class AudioFieldV1(BaseFieldV1):
    """Component for recording audio.

    Works in the mobile app. In a browser, this component opens a window for uploading an audio file.

    Attributes:
        data: Data with values that will be processed or changed.
        multiple: Determines whether multiple audio files can be recorded (or uploaded):
            False (default) — forbidden.
            True — allowed.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        multiple: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class AudioFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    multiple: typing.Optional[typing.Any]


class ButtonRadioFieldV1(BaseFieldV1):
    """A component in the form of a button.

    The user makes a choice by clicking on it.

    The size of the button depends on the size of the label.

    Attributes:
        data: Data with values that will be processed or changed.
        value_to_set: The value of the output data when the button is clicked.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        value_to_set: typing.Optional[typing.Any] = None,
        *,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ButtonRadioFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    value_to_set: typing.Optional[typing.Any]


class GroupFieldOption(toloka.client.project.template_builder.base.BaseTemplate):
    """Option.

    Attributes:
        value: Returned value.
        label: The text on the object.
        hint: Additional information.
    """

    def __init__(
        self,
        value: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        *,
        hint: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class GroupFieldOption.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    value: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    hint: typing.Optional[typing.Any]


class ButtonRadioGroupFieldV1(BaseFieldV1):
    """A component with buttons that allow the user to choose between the specified values.

    The minimum number of elements is one. Any type of data can be returned.

    The size of the button is determined by the length of the text on it.

    Attributes:
        data: Data with values that will be processed or changed.
        options: Array of information about the buttons.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.

    Examples:
        How to add buttons for classification task.

        >>> classification_buttons = tb.fields.ButtonRadioGroupFieldV1(
        >>>     tb.data.OutputData(path='class'),
        >>>     [
        >>>         tb.fields.GroupFieldOption('Cat', 'cat'),
        >>>         tb.fields.GroupFieldOption('Dog', 'dog'),
        >>>     ],
        >>>     validation=tb.conditions.RequiredConditionV1(hint='Choose one of the answer options'),
        >>> )
        ...
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]] = None,
        *,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ButtonRadioGroupFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]]


class CheckboxFieldV1(BaseFieldV1):
    """Checkbox.

    Attributes:
        data: Data with values that will be processed or changed.
        disabled: Property that disables the component. If true, the component will not be unavailable.
        preserve_false: Property that specifies whether to return false values in the results. By default, if the
            component returns false, this result will not be added to the output. To add false to the results, specify
            "preserveFalse": true.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        preserve_false: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class CheckboxFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    preserve_false: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]


class CheckboxGroupFieldV1(BaseFieldV1):
    """A group of options for selecting one or more responses.

    Attributes:
        data: Data with values that will be processed or changed.
        options: Options, where value is the key that the option controls, and label is the text near the option.
        disabled: If `true', the options are inactive.
        preserve_false: Property that specifies whether to return false values in the results. By default, if the
            component returns false, this result will not be added to the output. To add false to the results, specify
            "preserveFalse": true.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        preserve_false: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class CheckboxGroupFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    preserve_false: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]


class DateFieldV1(BaseFieldV1):
    """A component for entering the date and time in the desired format and range.

    You can set a list of dates that the user cannot select.

    Attributes:
        data: Data with values that will be processed or changed.
        format: Format of the date entered by the user:
            * date-time — date and time.
            * date — date only.
        block_list: List of dates that the user cannot select.
            * block_list[]: Date that the user cannot select.
        max: The latest date and time in the YYYY-MM-DD hh:mm format that the user can select. Where:
            * YYYY is the year.
            * MM is the month.
            * DD is the day.
            * hh is the time in hours.
            * mm is the time in minutes.
        min: The earliest date and time in the YYYY-MM-DD hh:mm format that the user can select. Where:
            * YYYY is the year.
            * MM is the month.
            * DD is the day.
            * hh is the time in hours.
            * mm is the time in minutes.
        placeholder: A semi-transparent label that is shown in the box when it is empty.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        format: typing.Optional[typing.Any] = None,
        *,
        block_list: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]] = None,
        max: typing.Optional[typing.Any] = None,
        min: typing.Optional[typing.Any] = None,
        placeholder: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class DateFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    format: typing.Optional[typing.Any]
    block_list: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]]
    max: typing.Optional[typing.Any]
    min: typing.Optional[typing.Any]
    placeholder: typing.Optional[typing.Any]


class EmailFieldV1(BaseFieldV1):
    """Creates a field for entering an email address.

    Checks that the text contains the @ character. You can set other conditions yourself.

    Attributes:
        data: Data with values that will be processed or changed.
        placeholder: A semi-transparent label that is shown in an empty field.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        placeholder: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class EmailFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    placeholder: typing.Optional[typing.Any]


class FileFieldV1(BaseFieldV1):
    """This component can be used for uploading files. It's displayed in the interface as an upload button.

    You can restrict the file types to upload in the "accept" property. By default, only one file can be uploaded,
    but you can allow multiple files in the "multiple" property.

    If a user logs in from a mobile device, it's more convenient to use field.media-file — it's adapted for mobile
    devices and makes it easier to upload photos and videos.

    Attributes:
        data: Data with values that will be processed or changed.
        accept: A list of file types that can be uploaded. By default, you can upload any files.
            Specify the types in the [certain format](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types).
            For example, you can allow only images to be uploaded by adding the image/jpeg and image/png types.
        multiple: Determines whether multiple files can be uploaded:
            * false (default) — forbidden.
            * true — allowed.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        accept: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]]] = None,
        *,
        multiple: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class FileFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    accept: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]]]
    multiple: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]


class ImageAnnotationFieldV1(BaseFieldV1):
    """Adds an interface for selecting areas in images.

    If you need to select different types of objects, classify the areas using the labels property.

    You can select areas using points, polygons, and rectangles. In the shapes property, you can keep some of the
    selection modes and hide the rest.

    Attributes:
        data: Data with values that will be processed or changed.
        image: The image you want to select areas in.
        disabled: Determines whether adding and deleting areas is allowed:
            * false (default) — Allowed.
            * true — Not allowed.
            You can use this feature when creating an interface to check whether the selection is correct,
             or if you need to allow selection only when a certain condition is met.
        full_height: If true, the element takes up all the vertical free space. The element is set to a minimum height
            of 400 pixels.
        labels: Used to classify areas.
            You can add several area types. When adding an area type, a button to select it appears in the interface,
            and when setting a new value, a new area selection color is added.
            This feature is instrumental if you need to select different types of objects: you can use one color to
            select cars and a different one for pedestrians.
        min_width: Minimum width of the element in pixels. Takes priority over max_width.
        ratio: An array of two numbers that sets the relative dimensions of the sides: width (first number) to height
            (second number). Not valid if full_height=true.
        shapes: Used to add and hide selection modes: points, polygons, and rectangles. All three modes are available
            by default.
            Use this property if you only need to keep certain modes. Modes with the true value are available.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    class Label(toloka.client.project.template_builder.base.BaseTemplate):
        """At least two objects must be added to the array.

        Attributes:
            label: Text on the button for selecting a selection color.
            value: The value to be written to the labels property data. Displayed to users as color options when
                selecting areas.
        """

        def __init__(
            self,
            label: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
            value: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None
        ) -> None:
            """Method generated by attrs for class ImageAnnotationFieldV1.Label.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        label: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
        value: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]

    class Shape(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        POINT = 'point'
        POLYGON = 'polygon'
        RECTANGLE = 'rectangle'

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        image: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        full_height: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        labels: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Label]]]] = None,
        min_width: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]] = None,
        ratio: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]]]] = None,
        shapes: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.Dict[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Shape], typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ImageAnnotationFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    image: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    full_height: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    labels: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Label]]]]
    min_width: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]]
    ratio: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]]]]
    shapes: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.Dict[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Shape], typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]]]


class ListFieldV1(BaseFieldV1):
    """A component that allows the user to add and remove list items, such as text fields to fill in.

    This way you can allow the user to give multiple answers to a question.

    The list items can contain any component, including a list of other components. For example, this allows you to
    create a table where you can add and delete rows.

    To add a new list item, the user clicks the button. To remove an item, they click on the x on the right (it appears
    when hovering over a list item).

    To prevent the user from adding too many list items, set the maximum list length. You can also use the editable
    property to block users from changing a component, like when a certain event occurs.

    Attributes:
        data: Data with values that will be processed or changed.
        render: Interface template for list items, such as a text field.
            In nested field.* components, use data.relative for recording responses, otherwise all the list items will
            have the same value.
        button_label: Text on the button for adding list items.
        direction: The direction of the list.
        editable: A property that indicates whether adding and removing list items is allowed. Set false to disable.
            By default it is true (allowed).
        max_length: Maximum number of list items.
        size: The distance between list items. Acceptable values in ascending order: s, m (default).
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        render: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        button_label: typing.Optional[typing.Any] = None,
        direction: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, toloka.client.project.template_builder.base.ListDirection]] = None,
        editable: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        max_length: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]] = None,
        size: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, toloka.client.project.template_builder.base.ListSize]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ListFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    render: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    button_label: typing.Optional[typing.Any]
    direction: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, toloka.client.project.template_builder.base.ListDirection]]
    editable: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    max_length: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]]
    size: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, toloka.client.project.template_builder.base.ListSize]]


class MediaFileFieldV1(BaseFieldV1):
    """Adds buttons for different types of uploads: uploading photos or videos, selecting files from the file manager or choosing from the gallery. In the accept property, select which buttons you need.

    By default, only one file can be uploaded, but you can allow multiple files in the multiple property.

    This component is convenient when using mobile devices. To upload files from a computer, it's better to use
    field.file for a more flexible configuration of the file types.

    Attributes:
        data: Data with values that will be processed or changed.
        accept: Adds different buttons for four types of uploads. Pass the true value for the ones that you need.
            For example, if you need a button for uploading files from the gallery, add the "gallery": true property
        multiple: Determines whether multiple files can be uploaded:
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.

    Examples:
        How to allow performers to upload images and make photos.

        >>> image_loader = tb.fields.MediaFileFieldV1(
        >>>     label='Upload a photo',
        >>>     data=tb.data.OutputData(path='image'),
        >>>     validation=tb.conditions.RequiredConditionV1(),
        >>>     accept=tb.fields.MediaFileFieldV1.Accept(photo=True, gallery=True),
        >>>     multiple=False,
        >>> )
        ...
    """

    class Accept(toloka.client.project.template_builder.base.BaseTemplate):
        """Adds different buttons for four types of uploads.

        Attributes:
            file_system: Adds a button for uploading files from the file manager.
            gallery: Adds a button for uploading files from the gallery.
            photo: Adds a button for uploading images.
            video: Adds a button for uploading videos.
        """

        def __init__(
            self,
            *,
            file_system: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
            gallery: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
            photo: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
            video: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None
        ) -> None:
            """Method generated by attrs for class MediaFileFieldV1.Accept.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        file_system: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
        gallery: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
        photo: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
        video: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        accept: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Accept]] = None,
        *,
        multiple: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class MediaFileFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    accept: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Accept]]
    multiple: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]


class NumberFieldV1(BaseFieldV1):
    """A component that allows you to enter a number.

    The box already has validation: by default, users can enter only numbers and decimal separators. They can use either
    a dot or a comma as a separator, but there will always be a dot in the output.

    When the user is entering a number, the separator automatically changes to the one specified in the regional
    settings. For Russia, the separator is a comma.

    Negative numbers are allowed by default. To disable them, use the validation property. Pressing the up or down arrow
    keys will increase or decrease the number by one.

    Attributes:
        data: Data with values that will be processed or changed.
        maximum: Maximum number that can be entered.
        minimum: Minimum number that can be entered.
        placeholder: A semi-transparent label that is shown in the box when it is empty.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        maximum: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, int]] = None,
        minimum: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, int]] = None,
        placeholder: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class NumberFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    maximum: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, int]]
    minimum: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, int]]
    placeholder: typing.Optional[typing.Any]


class PhoneNumberFieldV1(BaseFieldV1):
    """Creates a field for entering a phone number.

    Allows entering numbers, spaces, and the +, ( ), - characters. Only numbers and the + character at the beginning
    will remain in the data. For example, if you enter +7 (012) 345-67-89, the data gets the +70123456789 value.

    Attributes:
        data: Data with values that will be processed or changed.
        placeholder: A semi-transparent label that is shown in an empty field.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        placeholder: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class PhoneNumberFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    placeholder: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]


class RadioGroupFieldV1(BaseFieldV1):
    """A component for selecting one value out of several options. It is designed as a group of circles arranged vertically.

    If you want it to look like normal buttons, use field.button-radio-group.

    The minimum number of buttons is one. Any type of data can be returned.

    Attributes:
        data: Data with values that will be processed or changed.
        options: List of options to choose from
        disabled: This property prevents clicking the button. If the value is true, the button is not active (the user
            will not be able to click it).
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.

    Examples:
        How to add label selector to interface.

        >>> radio_group_field = tb.fields.RadioGroupFieldV1(
        >>>     tb.data.OutputData(path='result'),
        >>>     [
        >>>         tb.fields.GroupFieldOption('Cat', 'cat'),
        >>>         tb.fields.GroupFieldOption('Dog', 'dog'),
        >>>     ],
        >>>     validation=tb.conditions.RequiredConditionV1()
        >>> )
        ...
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class RadioGroupFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, GroupFieldOption]]]]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]


class SelectFieldV1(BaseFieldV1):
    """Button for selecting from a drop-down list.

    Use this component when the list is long and only one option can be chosen.

    For short lists (2-4 items), it's better to use field.radio-group or field.button-radio-group, where all the
    options are visible at once.

    To allow selecting multiple options, use the field.checkbox-group component.

    Attributes:
        data: Data with values that will be processed or changed.
        options: Options to choose from.
        placeholder: The text that will be displayed if none of the options is selected.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    class Option(toloka.client.project.template_builder.base.BaseTemplate):
        """Options to choose from.

        Attributes:
            label: The name of the option to display in the list.
            value: The value to write to the data in the data property.
        """

        def __init__(
            self,
            label: typing.Optional[typing.Any] = None,
            value: typing.Optional[typing.Any] = None
        ) -> None:
            """Method generated by attrs for class SelectFieldV1.Option.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        label: typing.Optional[typing.Any]
        value: typing.Optional[typing.Any]

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Option]]]] = None,
        *,
        placeholder: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class SelectFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    options: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Option]]]]
    placeholder: typing.Optional[typing.Any]


class TextFieldV1(BaseFieldV1):
    """A component that allows entering a single line of text.

    Attributes:
        data: Data with values that will be processed or changed.
        disabled: If true, editing is not available.
        placeholder: A semi-transparent label that is shown in the box when it is empty.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        placeholder: typing.Optional[typing.Any] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TextFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    placeholder: typing.Optional[typing.Any]


class TextAnnotationFieldV1(BaseFieldV1):
    """A component for text segmentation.

    Use it to select multiple words, individual words, or letters in the text and label them with values. You can create
    multiple categories to label parts of the text, like all nouns and adjectives.

    You can use plugin.field.text-annotation.hotkeys to assign keyboard shortcuts for selecting categories.

    Attributes:
        data: Data with values that will be processed or changed.
        adjust: If the property value is set to words, only words can be selected in the text. If you don't use this
            property, any part of a line can be selected.
        content: The text where the performer has to select part of a line.
        disabled: This property blocks the component. If true, the component is unavailable to the performer. The
            default value is false.
        labels: A category.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    class Label(toloka.client.project.template_builder.base.BaseTemplate):
        """Attributes:
            label: Specify the category name in the label property.
            value: Specify the category value in the value property.
        """

        def __init__(
            self,
            label: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
            value: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None
        ) -> None:
            """Method generated by attrs for class TextAnnotationFieldV1.Label.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        label: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
        value: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        adjust: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        content: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        labels: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Label]]]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TextAnnotationFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    adjust: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
    content: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    labels: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Label]]]]


class TextareaFieldV1(BaseFieldV1):
    """Box for entering multi-line text.

    Use in tasks that require an extended response. For single-line responses, use the field.text component.

    The size of the box does not automatically adjust to the length of the text. Users can change the height by
    dragging the lower-right corner. To change the default size of the box, use the rows property.

    Note that formatting is not available in the text box.

    Attributes:
        data: Data with values that will be processed or changed.
        disabled: If true, editing is not available.
        placeholder: A semi-transparent label that is shown when the box is empty. Use it to provide an example or a
            hint for the response.
        resizable: Changing the box size. When set to true (the default value), the user can change the height. To
            prevent resizing, set the value to false.
        rows: The height of the text box in lines.
        hint: Hint text.
        label: Label above the component.
        validation: Validation based on condition.
    """

    def __init__(
        self,
        data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        *,
        disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        placeholder: typing.Optional[typing.Any] = None,
        resizable: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]] = None,
        rows: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]] = None,
        hint: typing.Optional[typing.Any] = None,
        label: typing.Optional[typing.Any] = None,
        validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TextareaFieldV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    data: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    hint: typing.Optional[typing.Any]
    label: typing.Optional[typing.Any]
    validation: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    version: typing.Optional[str]
    disabled: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    placeholder: typing.Optional[typing.Any]
    resizable: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, bool]]
    rows: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, float]]
