__all__ = [
    'SortItemSelf',
    'SortItemsSelf',
    'SortOrder',
    'BaseSortItem',
    'BaseSortItems',
    'SearchRequestMetaclass',
    'BaseSearchRequest',
    'ProjectSearchRequest',
    'ProjectSortItems',
    'PoolSearchRequest',
    'PoolSortItems',
    'TrainingSearchRequest',
    'TrainingSortItems',
    'SkillSearchRequest',
    'SkillSortItems',
    'AssignmentSearchRequest',
    'AssignmentSortItems',
    'AggregatedSolutionSearchRequest',
    'AggregatedSolutionSortItems',
    'TaskSearchRequest',
    'TaskSortItems',
    'TaskSuiteSearchRequest',
    'TaskSuiteSortItems',
    'AttachmentSearchRequest',
    'AttachmentSortItems',
    'UserSkillSearchRequest',
    'UserSkillSortItems',
    'UserRestrictionSearchRequest',
    'UserRestrictionSortItems',
    'UserBonusSearchRequest',
    'UserBonusSortItems',
    'MessageThreadSearchRequest',
    'MessageThreadSortItems',
    'WebhookSubscriptionSearchRequest',
    'WebhookSubscriptionSortItems',
    'AppProjectSearchRequest',
    'AppProjectSortItems',
    'AppSearchRequest',
    'AppSortItems',
    'AppItemSearchRequest',
    'AppItemSortItems',
    'AppBatchSearchRequest',
    'AppBatchSortItems',
]
import datetime
import enum
import toloka.client.app
import toloka.client.assignment
import toloka.client.attachment
import toloka.client.message_thread
import toloka.client.pool
import toloka.client.primitives.base
import toloka.client.project
import toloka.client.training
import toloka.client.user_restriction
import toloka.client.webhook_subscription
import typing


SortItemSelf = typing.TypeVar('SortItemSelf', bound='BaseSortItem')

SortItemsSelf = typing.TypeVar('SortItemsSelf', bound='BaseSortItems')

class SortOrder(enum.Enum):
    """An enumeration.
    """

    ASCENDING = 1
    DESCENDING = 2


class BaseSortItem(toloka.client.primitives.base.BaseTolokaObject):
    def unstructure(self): ...

    @classmethod
    def structure(cls: typing.Type[SortItemSelf], value: typing.Union[SortItemSelf, str]) -> SortItemSelf: ...

    @classmethod
    def for_fields(
        cls,
        qualname: str,
        sort_fields: typing.List[str]
    ): ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSortItem.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class BaseSortItems(toloka.client.primitives.base.BaseTolokaObject):
    def unstructure(self): ...

    @classmethod
    def structure(cls, items): ...

    @classmethod
    def for_fields(
        cls,
        qualname: str,
        sort_fields: typing.List[str],
        docstring: typing.Optional[str] = None
    ): ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class SearchRequestMetaclass(toloka.client.primitives.base.BaseTolokaObjectMetaclass):
    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        kw_only=False,
        **kwargs
    ): ...


class BaseSearchRequest(toloka.client.primitives.base.BaseTolokaObject, metaclass=SearchRequestMetaclass):
    """Base class for all search request classes
    """

    class CompareFields:
        ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class ProjectSearchRequest(BaseSearchRequest):
    """Parameters for searching projects

    Attributes:
        status: Status of the project, from Project.ProjectStatus:
            * ACTIVE
            * ARCHIVED
        id_lt: Projects with an ID less than the specified value.
        id_lte: Projects with an ID less than or equal to the specified value.
        id_gt: Projects with an ID greater than the specified value.
        id_gte: Projects with an ID greater than or equal to the specified value.
        created_lt: Projects created before the specified date.
        created_lte: Projects created before or on the specified date.
        created_gt: Projects created after the specified date.
        created_gte: Projects created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.project.Project.ProjectStatus] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class ProjectSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.project.Project.ProjectStatus]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class ProjectSortItems(BaseSortItems):
    """Parameters for sorting project search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Project ID in ascending order.
            * created - Project creation date in UTC in yyyy-MM-DD format (ascending).
            * public_name - Project name (in alphabetical order).
            * private_comment - Comment on the project (in alphabetical order).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.ProjectSortItems(['-public_name', 'id'])
        >>> result = toloka_client.find_projects(status='ACTIVE', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            PUBLIC_NAME = 'public_name'
            PRIVATE_COMMENT = 'private_comment'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class ProjectSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class ProjectSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class PoolSearchRequest(BaseSearchRequest):
    """Parameters for searching pools

    Attributes:
        status: Pool status
            * OPEN
            * CLOSED
            * ARCHIVED
            * LOCKED
        project_id: ID of the project to which the pool is attached.
        id_lt: Pools with an ID less than the specified value.
        id_lte: Pools with an ID less than or equal to the specified value.
        id_gt: Pools with an ID greater than the specified value.
        id_gte: Pools with an ID greater than or equal to the specified value.
        created_lt: Pools created before the specified date.
        created_lte: Pools created before or on the specified date.
        created_gt: Pools created after the specified date.
        created_gte: Pools created after or on the specified date.
        last_started_lt: Pools that were last opened before the specified date.
        last_started_lte: Pools that were last opened on or before the specified date.
        last_started_gt: Pools that were last opened after the specified date.
        last_started_gte: Pools that were last opened on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        last_started: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.pool.Pool.Status] = None,
        project_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        last_started_lt: typing.Optional[datetime.datetime] = None,
        last_started_lte: typing.Optional[datetime.datetime] = None,
        last_started_gt: typing.Optional[datetime.datetime] = None,
        last_started_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class PoolSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.pool.Pool.Status]
    project_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    last_started_lt: typing.Optional[datetime.datetime]
    last_started_lte: typing.Optional[datetime.datetime]
    last_started_gt: typing.Optional[datetime.datetime]
    last_started_gte: typing.Optional[datetime.datetime]


class PoolSortItems(BaseSortItems):
    """Parameters for sorting pool search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Pool ID in ascending order.
            * created - Pool creation date in UTC in yyyy-MM-DD format (ascending).
            * last_started - The date the pool was last started (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.PoolSortItems(['-last_started', 'id'])
        >>> result = toloka_client.find_pools(status='OPEN', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            LAST_STARTED = 'last_started'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class PoolSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class PoolSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TrainingSearchRequest(BaseSearchRequest):
    """Parameters for searching training pools

    Attributes:
        status: Training pool status:
            * OPEN
            * CLOSED
            * ARCHIVED
            * LOCKED
        project_id: ID of the project to which the training pool is attached.
        id_lt: Training pools with an ID less than the specified value.
        id_lte: Training pools with an ID less than or equal to the specified value.
        id_gt: Training pools with an ID greater than the specified value.
        id_gte: Training pools with an ID greater than or equal to the specified value.
        created_lt: Training pools created before the specified date.
        created_lte: Training pools created before or on the specified date.
        created_gt: Training pools created after the specified date.
        created_gte: Training pools created after or on the specified date.
        last_started_lt: Training pools that were last opened before the specified date.
        last_started_lte: Training pools that were last opened on or before the specified date.
        last_started_gt: Training pools that were last opened after the specified date.
        last_started_gte: Training pools that were last opened on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        last_started: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.training.Training.Status] = None,
        project_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        last_started_lt: typing.Optional[datetime.datetime] = None,
        last_started_lte: typing.Optional[datetime.datetime] = None,
        last_started_gt: typing.Optional[datetime.datetime] = None,
        last_started_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class TrainingSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.training.Training.Status]
    project_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    last_started_lt: typing.Optional[datetime.datetime]
    last_started_lte: typing.Optional[datetime.datetime]
    last_started_gt: typing.Optional[datetime.datetime]
    last_started_gte: typing.Optional[datetime.datetime]


class TrainingSortItems(BaseSortItems):
    """Parameters for sorting training pool search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Training pool ID in ascending order.
            * created - Training pool creation date in UTC in yyyy-MM-DD format (ascending).
            * last_started - The date the pool was last started (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.TrainingSortItems(['-last_started', 'id'])
        >>> result = toloka_client.find_trainings(status='OPEN', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            LAST_STARTED = 'last_started'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TrainingSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TrainingSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class SkillSearchRequest(BaseSearchRequest):
    """Parameters for searching skill

    Attributes:
        name: Skill name.
        id_lt: Skills with an ID less than the specified value.
        id_lte: Skills with an ID less than or equal to the specified value.
        id_gt: Skills with an ID greater than the specified value.
        id_gte: Skills with an ID greater than or equal to the specified value.
        created_lt: Skills created before the specified date.
        created_lte: Skills created before or on the specified date.
        created_gt: Skills created after the specified date.
        created_gte: Skills created on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        name: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class SkillSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class SkillSortItems(BaseSortItems):
    """Parameters for sorting skill search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Skill ID in ascending order.
            * created - Skill creation date in UTC in yyyy-MM-DD format (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.SkillSortItems(['-created', 'id'])
        >>> result = toloka_client.find_skills(name='Image annotation', sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class SkillSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class SkillSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AssignmentSearchRequest(BaseSearchRequest):
    """Parameters for searching assignment

    Attributes:
        status: Status of an assigned task suite (Detailed status description in Assignment.Status):
            * ACTIVE
            * SUBMITTED
            * ACCEPTED
            * REJECTED
            * SKIPPED
            * EXPIRED
        task_id: The task ID in suites generated automatically using "smart mixing".
            You will get responses for task suites that contain the specified task.
        task_suite_id: ID of a task suite.
        pool_id: Pool ID.
        user_id: Performer ID.
        id_lt: Task suites with an assignment ID less than the specified value.
        id_lte: Task suites with an assignment ID less than or equal to the specified value.
        id_gt: Task suites with an assignment ID greater than the specified value.
        id_gte: Task suites with an assignment ID greater than or equal to the specified value.
        created_lt: Task suites assigned before the specified date.
        created_lte: Task suites assigned before or on the specified date.
        created_gt: Task suites assigned after the specified date.
        created_gte: Task suites assigned after or on the specified date.
        submitted_lt: Task suites completed before the specified date.
        submitted_lte: Task suites completed before or on the specified date.
        submitted_gt: Task suites completed after the specified date.
        submitted_gte: Task suites completed after or on the specified date.
        accepted_lt: Task suites accepted before the specified date.
        accepted_lte: Task suites accepted before or on the specified date.
        accepted_gt: Task suites accepted after the specified date.
        accepted_gte: Task suites accepted after or on the specified date.
        rejected_lt: Task suites rejected before the specified date.
        rejected_lte: Task suites rejected before or on the specified date.
        rejected_gt: Task suites rejected after the specified date.
        rejected_gte: Task suites rejected after or on the specified date.
        skipped_lt: Task suites skipped before the specified date.
        skipped_lte: Task suites skipped before or on the specified date.
        skipped_gt: Task suites skipped after the specified date.
        skipped_gte: Task suites skipped after or on the specified date.
        expired_lt: Task suites expired before the specified date.
        expired_lte: Task suites expired before or on the specified date.
        expired_gt: Task suites expired after the specified date.
        expired_gte: Task suites expired after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        submitted: datetime.datetime
        accepted: datetime.datetime
        rejected: datetime.datetime
        skipped: datetime.datetime
        expired: datetime.datetime

    def unstructure(self) -> typing.Optional[dict]: ...

    def __init__(
        self,
        status: typing.Union[str, toloka.client.assignment.Assignment.Status, typing.List[typing.Union[str, toloka.client.assignment.Assignment.Status]]] = None,
        task_id: typing.Optional[str] = None,
        task_suite_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        user_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        submitted_lt: typing.Optional[datetime.datetime] = None,
        submitted_lte: typing.Optional[datetime.datetime] = None,
        submitted_gt: typing.Optional[datetime.datetime] = None,
        submitted_gte: typing.Optional[datetime.datetime] = None,
        accepted_lt: typing.Optional[datetime.datetime] = None,
        accepted_lte: typing.Optional[datetime.datetime] = None,
        accepted_gt: typing.Optional[datetime.datetime] = None,
        accepted_gte: typing.Optional[datetime.datetime] = None,
        rejected_lt: typing.Optional[datetime.datetime] = None,
        rejected_lte: typing.Optional[datetime.datetime] = None,
        rejected_gt: typing.Optional[datetime.datetime] = None,
        rejected_gte: typing.Optional[datetime.datetime] = None,
        skipped_lt: typing.Optional[datetime.datetime] = None,
        skipped_lte: typing.Optional[datetime.datetime] = None,
        skipped_gt: typing.Optional[datetime.datetime] = None,
        skipped_gte: typing.Optional[datetime.datetime] = None,
        expired_lt: typing.Optional[datetime.datetime] = None,
        expired_lte: typing.Optional[datetime.datetime] = None,
        expired_gt: typing.Optional[datetime.datetime] = None,
        expired_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AssignmentSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[typing.List[toloka.client.assignment.Assignment.Status]]
    task_id: typing.Optional[str]
    task_suite_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    user_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    submitted_lt: typing.Optional[datetime.datetime]
    submitted_lte: typing.Optional[datetime.datetime]
    submitted_gt: typing.Optional[datetime.datetime]
    submitted_gte: typing.Optional[datetime.datetime]
    accepted_lt: typing.Optional[datetime.datetime]
    accepted_lte: typing.Optional[datetime.datetime]
    accepted_gt: typing.Optional[datetime.datetime]
    accepted_gte: typing.Optional[datetime.datetime]
    rejected_lt: typing.Optional[datetime.datetime]
    rejected_lte: typing.Optional[datetime.datetime]
    rejected_gt: typing.Optional[datetime.datetime]
    rejected_gte: typing.Optional[datetime.datetime]
    skipped_lt: typing.Optional[datetime.datetime]
    skipped_lte: typing.Optional[datetime.datetime]
    skipped_gt: typing.Optional[datetime.datetime]
    skipped_gte: typing.Optional[datetime.datetime]
    expired_lt: typing.Optional[datetime.datetime]
    expired_lte: typing.Optional[datetime.datetime]
    expired_gt: typing.Optional[datetime.datetime]
    expired_gte: typing.Optional[datetime.datetime]


class AssignmentSortItems(BaseSortItems):
    """Parameters for sorting assignment search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - ID for issuing a set of tasks (in ascending order).
            * created - Date of issue of the set of tasks in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).
            * submitted - Date of completion of the set of tasks in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).
            * accepted - Date the set of tasks was accepted in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).
            * rejected - Date the set of tasks was rejected in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).
            * skipped - Date the set of tasks was skipped in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).
            * expired - Date the set of tasks was expired in UTC in ISO 8601 format YYYY-MM-DDThh:mm:ss[.sss] (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.AssignmentSortItems(['-submitted', 'id'])
        >>> result = toloka_client.find_assignments(status='SUBMITTED', sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            SUBMITTED = 'submitted'
            ACCEPTED = 'accepted'
            REJECTED = 'rejected'
            SKIPPED = 'skipped'
            EXPIRED = 'expired'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AssignmentSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AssignmentSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AggregatedSolutionSearchRequest(BaseSearchRequest):
    """Parameters for searching aggregated solution

    Attributes:
        task_id_lt: Jobs with an ID greater than the specified value.
        task_id_lte: Jobs with an ID greater than or equal to the specified value.
        task_id_gt: Jobs with an ID less than the specified value.
        task_id_gte: Jobs with an ID less than or equal to the specified value.
    """

    class CompareFields:
        task_id: str

    def __init__(
        self,
        task_id_lt: typing.Optional[str] = None,
        task_id_lte: typing.Optional[str] = None,
        task_id_gt: typing.Optional[str] = None,
        task_id_gte: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolutionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id_lt: typing.Optional[str]
    task_id_lte: typing.Optional[str]
    task_id_gt: typing.Optional[str]
    task_id_gte: typing.Optional[str]


class AggregatedSolutionSortItems(BaseSortItems):
    """Parameters for sorting aggregated solution search results

    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * task_id - In ascending order.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            TASK_ID = 'task_id'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AggregatedSolutionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AggregatedSolutionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TaskSearchRequest(BaseSearchRequest):
    """Parameters for searching tasks

    Attributes:
        pool_id: The ID of the pool to get tasks from.
        overlap: Tasks with an overlap equal to the specified value.
        id_lt: Tasks with an ID less than the specified value.
        id_lte: Tasks with an ID less than or equal to the specified value.
        id_gt: Tasks with an ID greater than the specified value.
        id_gte: Tasks with an ID greater than or equal to the specified value.
        created_lt: Tasks created before the specified date.
        created_lte: Tasks created before or on the specified date.
        created_gt: Tasks created after the specified date.
        created_gte: Tasks created after or on the specified date.
        overlap_lt: Tasks with an overlap less than the specified value.
        overlap_lte: Tasks with an overlap less than or equal to the specified value.
        overlap_gt: Tasks with an overlap greater than the specified value.
        overlap_gte: Tasks with an overlap greater than or equal to the specified value.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        overlap: int

    def __init__(
        self,
        pool_id: typing.Optional[str] = None,
        overlap: typing.Optional[int] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        overlap_lt: typing.Optional[int] = None,
        overlap_lte: typing.Optional[int] = None,
        overlap_gt: typing.Optional[int] = None,
        overlap_gte: typing.Optional[int] = None
    ) -> None:
        """Method generated by attrs for class TaskSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    pool_id: typing.Optional[str]
    overlap: typing.Optional[int]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    overlap_lt: typing.Optional[int]
    overlap_lte: typing.Optional[int]
    overlap_gt: typing.Optional[int]
    overlap_gte: typing.Optional[int]


class TaskSortItems(BaseSortItems):
    """Parameters for sorting task search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Job ID (in ascending order).
            * created - Date of creation of the task in UTC in the format YYYY-MM-DD (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.TaskSortItems(['-created', 'id'])
        >>> result = toloka_client.find_tasks(pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TaskSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TaskSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TaskSuiteSearchRequest(BaseSearchRequest):
    """Parameters for searching task suites

    Attributes:
        task_id: The task ID in suites generated automatically using "smart mixing".
            You will get task suites that contain the specified task.
        pool_id: ID of the pool to get task suites from.
        overlap: Suites with an overlap equal to the specified value.
        id_lt: Task suites with an ID less than the specified value.
        id_lte: Task suites with an ID less than or equal to the specified value.
        id_gt: Task suites with an ID greater than the specified value.
        id_gte: Task suites with an ID greater than or equal to the specified value.
        created_lt: Task suites created before the specified date.
        created_lte: Task suites created before or on the specified date.
        created_gt: Task suites created after the specified date.
        created_gte: Task suites created after or on the specified date.
        overlap_lt: Suites with an overlap less than the specified value.
        overlap_lte: Suites with an overlap less than or equal to the specified value.
        overlap_gt: Suites with an overlap greater than the specified value.
        overlap_gte: Suites with an overlap greater than or equal to the specified value.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        overlap: int

    def __init__(
        self,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        overlap: typing.Optional[int] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        overlap_lt: typing.Optional[int] = None,
        overlap_lte: typing.Optional[int] = None,
        overlap_gt: typing.Optional[int] = None,
        overlap_gte: typing.Optional[int] = None
    ) -> None:
        """Method generated by attrs for class TaskSuiteSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    overlap: typing.Optional[int]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    overlap_lt: typing.Optional[int]
    overlap_lte: typing.Optional[int]
    overlap_gt: typing.Optional[int]
    overlap_gte: typing.Optional[int]


class TaskSuiteSortItems(BaseSortItems):
    """Parameters for sorting task suite search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Task set ID (in ascending order).
            * created - Date of creation of the set of tasks in UTC in the format YYYY-MM-DD (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.TaskSuiteSortItems(['-created', 'id'])
        >>> result = toloka_client.find_task_suites(pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TaskSuiteSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TaskSuiteSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AttachmentSearchRequest(BaseSearchRequest):
    """Parameters for searching attachment

    Attributes:
        name: File name.
        type: Attachment type. Currently the key can have only one value - ASSIGNMENT_ATTACHMENT.
        user_id: ID of the user who uploaded the file(s).
        assignment_id: Assignment ID.
        pool_id: Pool ID.
        owner_id: Optional[str]
        owner_company_id: Optional[str]
        id_lt: Files with an ID less than the specified value.
        id_lte: Files with an ID less than or equal to the specified value.
        id_gt: Files with an ID greater than the specified value.
        id_gte: Files with an ID greater than or equal to the specified value.
        created_lt: Files uploaded by users before the specified date.
        created_lte: Files uploaded by users before or on the specified date.
        created_gt: Files uploaded by users after the specified date.
        created_gte: Files uploaded by users after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        name: typing.Optional[str] = None,
        type: typing.Optional[toloka.client.attachment.Attachment.Type] = None,
        user_id: typing.Optional[str] = None,
        assignment_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        owner_id: typing.Optional[str] = None,
        owner_company_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AttachmentSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
    type: typing.Optional[toloka.client.attachment.Attachment.Type]
    user_id: typing.Optional[str]
    assignment_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    owner_id: typing.Optional[str]
    owner_company_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class AttachmentSortItems(BaseSortItems):
    """Parameters for sorting attachment search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - File ID in ascending order.
            * created - Date of sending the file in UTC in the yyyy-MM-DD format (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.AttachmentSortItems(['-created', 'id'])
        >>> result = toloka_client.find_attachments(pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AttachmentSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AttachmentSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserSkillSearchRequest(BaseSearchRequest):
    """Parameters for searching user skill

    Attributes:
        user_id: Performer ID.
        skill_id: Skill ID.
        id_lt: Skills with an ID less than the specified value.
        id_lte: Skills with an ID less than or equal to the specified value.
        id_gt: Skills with an ID greater than the specified value.
        id_gte: Skills with an ID greater than or equal to the specified value.
        created_lt: Skills created before the specified date.
        created_lte: Skills created before or on the specified date.
        created_gt: Skills created after the specified date.
        created_gte: Skills created on or after the specified date.
        modified_lt: Skills that changed before the specified date.
        modified_lte: Skills that changed before the specified date.
        modified_gt: Skills changed after the specified date.
        modified_gte: Skills created on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        modified: datetime.datetime

    def __init__(
        self,
        user_id: typing.Optional[str] = None,
        skill_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        modified_lt: typing.Optional[datetime.datetime] = None,
        modified_lte: typing.Optional[datetime.datetime] = None,
        modified_gt: typing.Optional[datetime.datetime] = None,
        modified_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserSkillSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    user_id: typing.Optional[str]
    skill_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    modified_lt: typing.Optional[datetime.datetime]
    modified_lte: typing.Optional[datetime.datetime]
    modified_gt: typing.Optional[datetime.datetime]
    modified_gte: typing.Optional[datetime.datetime]


class UserSkillSortItems(BaseSortItems):
    """Parameters for sorting user skill search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Skill ID in ascending order.
            * created - Date the skill was created in UTC in the yyyy-MM-DD format (ascending).
            * modified - Date the skill was modified in UTC in the yyyy-MM-DD format (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.UserSkillSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_skills(skill_id=my_useful_skill_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            MODIFIED = 'modified'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserSkillSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserSkillSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserRestrictionSearchRequest(BaseSearchRequest):
    """Parameters for searching user restriction

    Attributes:
        scope: The scope of the ban
            * ALL_PROJECTS
            * PROJECT
            * POOL
        user_id: Performer ID.
        project_id: The ID of the project that is blocked.
        pool_id: The ID of the pool that is blocked.
        id_lt: Bans with an ID less than the specified value.
        id_lte: Bans with an ID less than or equal to the specified value.
        id_gt: Bans with an ID greater than the specified value.
        id_gte: Bans with an ID greater than or equal to the specified value.
        created_lt: Bans created before the specified date.
        created_lte: Bans created before or on the specified date.
        created_gt: Bans created after the specified date.
        created_gte: Bans created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        scope: typing.Optional[toloka.client.user_restriction.UserRestriction.Scope] = None,
        user_id: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserRestrictionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    scope: typing.Optional[toloka.client.user_restriction.UserRestriction.Scope]
    user_id: typing.Optional[str]
    project_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class UserRestrictionSortItems(BaseSortItems):
    """Parameters for sorting user restriction search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - User restriction ID in ascending order.
            * created - Creation date in UTC format yyyy-MM-DD (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.UserRestrictionSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_restrictions(pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserRestrictionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserRestrictionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserBonusSearchRequest(BaseSearchRequest):
    """Parameters for searching user bonus

    Attributes:
        user_id: Performer ID.
        assignment_id: ID of the performer's response to the task a reward is issued for.
        private_comment: Comments for the requester.
        id_lt: Bonuses with an ID less than the specified value.
        id_lte: Bonuses with an ID less than or equal to the specified value.
        id_gt: Bonuses with an ID greater than the specified value.
        id_gte: Bonuses with an ID greater than or equal to the specified value.
        created_lt: Bonuses awarded before the specified date.
        created_lte: Bonuses awarded before or on the specified date.
        created_gt: Bonuses awarded after the specified date.
        created_gte: Bonuses awarded after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        user_id: typing.Optional[str] = None,
        assignment_id: typing.Optional[str] = None,
        private_comment: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserBonusSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    user_id: typing.Optional[str]
    assignment_id: typing.Optional[str]
    private_comment: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class UserBonusSortItems(BaseSortItems):
    """Parameters for sorting user bonus search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Bonus ID in ascending order.
            * created - Creation date in UTC format yyyy-MM-DD (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.UserBonusSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_bonuses(user_id=best_performer_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserBonusSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserBonusSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class MessageThreadSearchRequest(BaseSearchRequest):
    """Parameters for searching message threads

    Attributes:
        folder: Folders to search for the thread
        folder_ne: Folders to not search for the thread
        id_lt: Threads with an ID less than the specified value.
        id_lte: Threads with an ID less than or equal to the specified value.
        id_gt: Threads with an ID greater than the specified value.
        id_gte: Threads with an ID greater than or equal to the specified value.
        created_lt: Threads created before the specified date.
        created_lte: Threads created before or on the specified date.
        created_gt: Threads created after the specified date.
        created_gte: Threads created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def unstructure(self) -> typing.Optional[dict]: ...

    def __init__(
        self,
        folder: typing.Union[str, toloka.client.message_thread.Folder, typing.List[typing.Union[str, toloka.client.message_thread.Folder]]] = None,
        folder_ne: typing.Union[str, toloka.client.message_thread.Folder, typing.List[typing.Union[str, toloka.client.message_thread.Folder]]] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class MessageThreadSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    folder: typing.Optional[typing.List[toloka.client.message_thread.Folder]]
    folder_ne: typing.Optional[typing.List[toloka.client.message_thread.Folder]]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class MessageThreadSortItems(BaseSortItems):
    """Parameters for sorting message thread search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Thread ID in ascending order.
            * created - Creation date in UTC format yyyy-MM-DD (ascending).
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class MessageThreadSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class MessageThreadSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class WebhookSubscriptionSearchRequest(BaseSearchRequest):
    """Parameters for searching webhook-subscriptions.

    Attributes:
        event_type: Event type.
        pool_id: ID of the pool for which subscription information is requested.
        id_lt: Subscriptions with an ID less than the specified value.
        id_lte: Subscriptions with an ID less than or equal to the specified value.
        id_gt: Subscriptions with an ID greater than the specified value.
        id_gte: Subscriptions with an ID greater than or equal to the specified value.
        created_lt: Subscriptions created before the specified date.
        created_lte: Subscriptions created before or on the specified date.
        created_gt: Subscriptions created after the specified date.
        created_gte: Subscriptions created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        event_type: typing.Optional[toloka.client.webhook_subscription.WebhookSubscription.EventType] = None,
        pool_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class WebhookSubscriptionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_type: typing.Optional[toloka.client.webhook_subscription.WebhookSubscription.EventType]
    pool_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class WebhookSubscriptionSortItems(BaseSortItems):
    """Parameters for sorting webhook-subscriptions search results

    You can specify multiple parameters.
    To change the sorting direction (sort in descending order), add a hyphen before the parameter. For example, sort=-id.

    Attributes:
        items: Fields by which to sort. Possible values:
            * id - Subscription ID (in ascending order).
            * created - Date of creation of the subscription in UTC in the format YYYY-MM-DD (ascending).

    Example:
        How to specify and use SortItems.

        >>> sort = toloka.client.search_requests.WebhookSubscriptionSortItems(['-created', 'id'])
        >>> result = toloka_client.find_webhook_subscriptions(event_type=some_event_type, pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class WebhookSubscriptionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class WebhookSubscriptionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppProjectSearchRequest(BaseSearchRequest):
    """Parameters for searching App projects.

    Attributes:
        app_id: App ID that the projects belong to.
        parent_app_project_id: ID of the App project used for cloning. It's specified only if you created an App project
            by cloning another App project. You can clone projects in the web version of Toloka.
        status: project status.
        after_id: ID of the project used for cursor pagination.
        scope: projects created by a specified range of requesters:
            * MY - Only by me;
            * COMPANY - By anyone from the company;
            * REQUESTER_LIST - By requesters with the specified IDs.
        requester_ids: List of requester IDs separated by a comma, for scope = REQUESTER_LIST.
        id_gt: projects with an ID greater than the specified value.
        id_gte: projects with an ID greater than or equal to the specified value.
        id_lt: projects with an ID less than the specified value.
        id_lte: projects with an ID less than or equal to the specified value.
        name_gt: projects with a name lexicographically greater than the specified value.
        name_gte: projects with a name lexicographically greater than or equal to the specified value.
        name_lt: projects with a name lexicographically less than the specified value.
        name_lte: projects with a name lexicographically less than or equal to the specified value.
        created_gt: projects created after the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_gte: projects created after or on the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_lt: projects created before the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_lte: projects created before or on the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
    """

    class Scope(enum.Enum):
        """An enumeration.
        """

        MY = 'MY'
        COMPANY = 'COMPANY'
        REQUESTER_LIST = 'REQUESTER_LIST'

    class CompareFields:
        id: str
        name: str
        created: datetime.datetime

    def __init__(
        self,
        app_id: typing.Optional[str] = None,
        parent_app_project_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppProject.Status] = None,
        after_id: typing.Optional[str] = None,
        scope: typing.Optional[Scope] = None,
        requester_ids: typing.Union[str, typing.List[str]] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        name_lt: typing.Optional[str] = None,
        name_lte: typing.Optional[str] = None,
        name_gt: typing.Optional[str] = None,
        name_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppProjectSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    app_id: typing.Optional[str]
    parent_app_project_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppProject.Status]
    after_id: typing.Optional[str]
    scope: typing.Optional[Scope]
    requester_ids: typing.Optional[typing.List[str]]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    name_lt: typing.Optional[str]
    name_lte: typing.Optional[str]
    name_gt: typing.Optional[str]
    name_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class AppProjectSortItems(BaseSortItems):
    """Parameters for sorting App projects search results.

    You can specify multiple parameters separated by a comma. To change the sorting direction to descending, add the
    minus sign before the parameter. For example, sort=-id.

    Attributes:
        items: The order and direction of sorting the results. Available parameters:
            * id - by id;
            * name - by name;
            * created — by the creation date. The date is specified in UTC in the YYYY-MM-DD format.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            NAME = 'name'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppProjectSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppProjectSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppSearchRequest(BaseSearchRequest):
    """Parameters for searching Apps.

    Attributes:
        after_id: The ID of the App used for cursor pagination.
        id_gt: only with an ID greater than the specified value.
        id_gte: only with an ID greater than or equal to the specified value.
        id_lt: only with an ID less than the specified value.
        id_lte: only with an ID less than or equal to the specified value.
        name_gt: only with a name lexicographically greater than the specified value.
        name_gte: only with a name lexicographically greater than or equal to the specified value.
        name_lt: only with a name lexicographically less than the specified value.
        name_lte: only with a name lexicographically less than or equal to the specified value.
    """

    class CompareFields:
        id: str
        name: str

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        name_lt: typing.Optional[str] = None,
        name_lte: typing.Optional[str] = None,
        name_gt: typing.Optional[str] = None,
        name_gte: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class AppSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    name_lt: typing.Optional[str]
    name_lte: typing.Optional[str]
    name_gt: typing.Optional[str]
    name_gte: typing.Optional[str]


class AppSortItems(BaseSortItems):
    """Parameters for sorting Apps search results.

    You can specify multiple parameters separated by a comma. To change the sorting direction to descending, add the
    minus sign before the parameter. For example, sort=-id.

    Attributes:
        items: The order and direction of sorting the results. Available parameters:
            * id - by id;
            * name - by name;
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            NAME = 'name'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppItemSearchRequest(BaseSearchRequest):
    """Parameters for searching App items.

    Attributes:
        after_id: ID of the item used for cursor pagination.
        batch_id: Batch ID.
        status: items in this status.
        id_gt: items with an ID greater than the specified value.
        id_gte: items with an ID greater than or equal to the specified value.
        id_lt: items with an ID less than the specified value.
        id_lte: items with an ID less than or equal to the specified value.
        created_gt: items created after the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_gte: items created after the specified date, inclusive. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_lt: items created before the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_lte: items created before the specified date, inclusive. The date is specified in UTC in ISO 8601
            format: YYYY-MM-DDThh:mm:ss[.sss].
    """

    class CompareFields:
        id: str
        created_at: datetime.datetime

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        batch_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppItem.Status] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_at_lt: typing.Optional[datetime.datetime] = None,
        created_at_lte: typing.Optional[datetime.datetime] = None,
        created_at_gt: typing.Optional[datetime.datetime] = None,
        created_at_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppItemSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    batch_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppItem.Status]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_at_lt: typing.Optional[datetime.datetime]
    created_at_lte: typing.Optional[datetime.datetime]
    created_at_gt: typing.Optional[datetime.datetime]
    created_at_gte: typing.Optional[datetime.datetime]


class AppItemSortItems(BaseSortItems):
    """Parameters for sorting App items search results.

    You can specify multiple parameters separated by a comma. To change the sorting direction to descending, add the
    minus sign before the parameter. For example, sort=-id.

    Attributes:
        items: The order and direction of sorting the results. Available parameters:
            * id - by id;
            * created — by creation date. The date is specified in UTC in the YYYY-MM-DD format.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED_AT = 'created_at'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppItemSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppItemSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppBatchSearchRequest(BaseSearchRequest):
    """Parameters for searching batches in the App project.

    Attributes:
        after_id: ID of the batch used for cursor pagination
        status: batches with this status.
        id_gt: batches with an ID greater than the specified value.
        id_gte: batches with an ID greater than or equal to the specified value.
        id_lt: batches with an ID less than the specified value.
        id_lte: batches with an ID less than or equal to the specified value.
        name_gt: batches with the name lexicographically greater than the specified value.
        name_gte: batches with a name lexicographically greater than or equal to the specified value.
        name_lt: batches with a name lexicographically less than the specified value.
        name_lte: batches with a name lexicographically less than or equal to the specified value.
        created_gt: batches created after the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_gte: batches created after the specified date, inclusive. The date is specified in UTC in ISO 8601
            format: YYYY-MM-DDThh:mm:ss[.sss].
        created_lt: batches created before the specified date. The date is specified in UTC in ISO 8601 format:
            YYYY-MM-DDThh:mm:ss[.sss].
        created_lte: batches created before the specified date, inclusive. The date is specified in UTC in ISO 8601
            format: YYYY-MM-DDThh:mm:ss[.sss].
    """

    class CompareFields:
        id: str
        name: str
        created_at: datetime.datetime

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppBatch.Status] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        name_lt: typing.Optional[str] = None,
        name_lte: typing.Optional[str] = None,
        name_gt: typing.Optional[str] = None,
        name_gte: typing.Optional[str] = None,
        created_at_lt: typing.Optional[datetime.datetime] = None,
        created_at_lte: typing.Optional[datetime.datetime] = None,
        created_at_gt: typing.Optional[datetime.datetime] = None,
        created_at_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppBatchSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppBatch.Status]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    name_lt: typing.Optional[str]
    name_lte: typing.Optional[str]
    name_gt: typing.Optional[str]
    name_gte: typing.Optional[str]
    created_at_lt: typing.Optional[datetime.datetime]
    created_at_lte: typing.Optional[datetime.datetime]
    created_at_gt: typing.Optional[datetime.datetime]
    created_at_gte: typing.Optional[datetime.datetime]


class AppBatchSortItems(BaseSortItems):
    """Parameters for sorting App batch search results.

    You can specify multiple parameters separated by a comma. To change the sorting direction to descending, add the
    minus sign before the parameter. For example, sort=-id.

    Attributes:
        items: The order and direction of sorting the results. Available parameters:
            * id - by id;
            * name - by name;
            * created — by creation date. The date is specified in UTC in the YYYY-MM-DD format.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            NAME = 'name'
            CREATED_AT = 'created_at'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppBatchSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppBatchSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]
