__all__ = [
    'AggregatedSolutionSearchResult',
    'AssignmentSearchResult',
    'AttachmentSearchResult',
    'MessageThreadSearchResult',
    'ProjectSearchResult',
    'PoolSearchResult',
    'SkillSearchResult',
    'TaskSearchResult',
    'TaskSuiteSearchResult',
    'TrainingSearchResult',
    'UserBonusSearchResult',
    'UserRestrictionSearchResult',
    'UserSkillSearchResult',
    'WebhookSubscriptionSearchResult',
    'AppProjectSearchResult',
    'AppSearchResult',
    'AppItemSearchResult',
    'AppBatchSearchResult',
]
import toloka.client.aggregation
import toloka.client.app
import toloka.client.assignment
import toloka.client.attachment
import toloka.client.message_thread
import toloka.client.pool
import toloka.client.primitives.base
import toloka.client.project
import toloka.client.skill
import toloka.client.task
import toloka.client.task_suite
import toloka.client.training
import toloka.client.user_bonus
import toloka.client.user_restriction
import toloka.client.user_skill
import toloka.client.webhook_subscription
import typing


class AggregatedSolutionSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found AggregatedSolutions and whether there is something else on the original request

    Attributes:
        items: List of found AggregatedSolution
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.aggregation.AggregatedSolution]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolutionSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.aggregation.AggregatedSolution]]
    has_more: typing.Optional[bool]


class AssignmentSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found assignments and whether there is something else on the original request

    It's better to use TolokaClient.get_assignments(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found assignments
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.assignment.Assignment]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AssignmentSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.assignment.Assignment]]
    has_more: typing.Optional[bool]


class AttachmentSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found attachments and whether there is something else on the original request

    It's better to use TolokaClient.get_attachments(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found Attachment
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.attachment.Attachment]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AttachmentSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.attachment.Attachment]]
    has_more: typing.Optional[bool]


class MessageThreadSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found message chains and whether there is something else on the original request

    It's better to use TolokaClient.get_message_threads(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found MessageThread
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.message_thread.MessageThread]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class MessageThreadSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.message_thread.MessageThread]]
    has_more: typing.Optional[bool]


class ProjectSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found projects and whether there is something else on the original request

    It's better to use TolokaClient.get_projects(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found projects
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.project.Project]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class ProjectSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.project.Project]]
    has_more: typing.Optional[bool]


class PoolSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found pools and whether there is something else on the original request

    It's better to use TolokaClient.get_pools(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found pools
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.pool.Pool]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class PoolSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.pool.Pool]]
    has_more: typing.Optional[bool]


class SkillSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found skills and whether there is something else on the original request

    It's better to use TolokaClient.get_skill(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found skills
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.skill.Skill]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class SkillSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.skill.Skill]]
    has_more: typing.Optional[bool]


class TaskSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found tasks and whether there is something else on the original request

    It's better to use TolokaClient.get_tasks(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found tasks
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.task.Task]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class TaskSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.task.Task]]
    has_more: typing.Optional[bool]


class TaskSuiteSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found sets of tasks and whether there is something else on the original request

    It's better to use TolokaClient.get_task_suites(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found sets of tasks
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.task_suite.TaskSuite]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class TaskSuiteSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.task_suite.TaskSuite]]
    has_more: typing.Optional[bool]


class TrainingSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found training pools and whether there is something else on the original request

    It's better to use TolokaClient.get_trainings(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found training pools
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.training.Training]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class TrainingSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.training.Training]]
    has_more: typing.Optional[bool]


class UserBonusSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found user bonuses and whether there is something else on the original request

    It's better to use TolokaClient.get_user_bonuses(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found user bonuses
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.user_bonus.UserBonus]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class UserBonusSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.user_bonus.UserBonus]]
    has_more: typing.Optional[bool]


class UserRestrictionSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found user restrictions and whether there is something else on the original request

    It's better to use TolokaClient.get_user_restrictions(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found user restrictions
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.user_restriction.UserRestriction]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class UserRestrictionSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.user_restriction.UserRestriction]]
    has_more: typing.Optional[bool]


class UserSkillSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found user skills and whether there is something else on the original request

    It's better to use TolokaClient.get_user_skills(), which already implements the correct handling of the search result.

    Attributes:
        items: List of found user skills
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.user_skill.UserSkill]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class UserSkillSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.user_skill.UserSkill]]
    has_more: typing.Optional[bool]


class WebhookSubscriptionSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found subscriptions and whether there is something else on the original request

    It's better to use TolokaClient.get_webhook_subscriptions(),
    which already implements the correct handling of the search result.

    Attributes:
        items: List of found subscriptions
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.List[toloka.client.webhook_subscription.WebhookSubscription]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class WebhookSubscriptionSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[toloka.client.webhook_subscription.WebhookSubscription]]
    has_more: typing.Optional[bool]


class AppProjectSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found App projects and whether there is something else on the original request.

    It's better to use TolokaClient.get_app_projects(),
    which already implements the correct handling of the search result.

    Attributes:
        items: List of found App projects.
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        content: typing.Optional[typing.List[toloka.client.app.AppProject]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AppProjectSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    content: typing.Optional[typing.List[toloka.client.app.AppProject]]
    has_more: typing.Optional[bool]


class AppSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found Apps and whether there is something else on the original request.

    It's better to use TolokaClient.get_apps(),
    which already implements the correct handling of the search result.

    Attributes:
        items: List of found Apps.
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        content: typing.Optional[typing.List[toloka.client.app.App]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AppSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    content: typing.Optional[typing.List[toloka.client.app.App]]
    has_more: typing.Optional[bool]


class AppItemSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found work items in the App project and whether there is something else on the original request.

    It's better to use TolokaClient.get_app_items(),
    which already implements the correct handling of the search result.

    Attributes:
        items: List of found work items in the App project.
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        content: typing.Optional[typing.List[toloka.client.app.AppItem]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AppItemSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    content: typing.Optional[typing.List[toloka.client.app.AppItem]]
    has_more: typing.Optional[bool]


class AppBatchSearchResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list of found batches in the App project and whether there is something else on the original request.

    It's better to use TolokaClient.get_app_batches(),
    which already implements the correct handling of the search result.

    Attributes:
        items: List of found batches in the App project.
        has_more: Whether the list is complete:
            * True - Not all elements are included in the output due to restrictions in the limit parameter.
            * False - The output lists all the items.
    """

    def __init__(
        self,
        *,
        content: typing.Optional[typing.List[toloka.client.app.AppBatch]] = None,
        has_more: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class AppBatchSearchResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    content: typing.Optional[typing.List[toloka.client.app.AppBatch]]
    has_more: typing.Optional[bool]
