__all__ = [
    'TaskDistributionFunction',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class TaskDistributionFunction(toloka.client.primitives.base.BaseTolokaObject):
    """Issue of tasks with uneven frequency

    Can be used for:
    - Distribution of tasks with majority opinion verification.
    - Issuing control tasks with uneven frequency. Allows you to change the frequency of verification as the user completes tasks.
    - Issuing training tasks with uneven frequency. Allows you to change the frequency of training tasks as the user completes tasks.

    Attributes:
        scope: How to count tasks completed by the user:
            * POOL - Count completed pool tasks.
            * PROJECT - Count completed project tasks.
        distribution: Distribution of tasks within an interval. Parameter has only one possible:
            value - UNIFORM.
        window_days: Period in which completed tasks are counted (number of days).
        intervals: Interval borders and number of tasks in an interval.
    """

    class Scope(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        PROJECT = 'PROJECT'
        POOL = 'POOL'

    class Distribution(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        UNIFORM = 'UNIFORM'

    class Interval(toloka.client.primitives.base.BaseTolokaObject):
        """Interval borders and number of tasks in an interval

        Attributes:
            from_: Start of the interval (number of task completed by the user in the project or in the pool).
            to: End of the interval (number of task completed by the user in the project or in the pool).
            frequency: Frequency of tasks in an interval. The first task in an interval is a distributed task.
                For example, if you set frequency: 3 tasks number 1, 4, 7 and so on will be distributed tasks.
        """

        def __init__(
            self,
            *,
            from_: typing.Optional[int] = None,
            to: typing.Optional[int] = None,
            frequency: typing.Optional[int] = None
        ) -> None:
            """Method generated by attrs for class TaskDistributionFunction.Interval.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        from_: typing.Optional[int]
        to: typing.Optional[int]
        frequency: typing.Optional[int]

    def __init__(
        self,
        *,
        scope: typing.Union[Scope, str, None] = None,
        distribution: typing.Union[Distribution, str, None] = None,
        window_days: typing.Optional[int] = None,
        intervals: typing.Optional[typing.List[Interval]] = None
    ) -> None:
        """Method generated by attrs for class TaskDistributionFunction.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    scope: typing.Optional[Scope]
    distribution: typing.Optional[Distribution]
    window_days: typing.Optional[int]
    intervals: typing.Optional[typing.List[Interval]]
