# flake8: noqa
import pytest

EXAMPLES = [
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\",\n    \"yandex\": {\n      \"type\": \"helper.search-query\",\n      \"engine\": \"yandex\",\n      \"query\": {\n        \"type\": \"data.input\",\n        \"path\": \"query\"\n      }\n    }\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.alert\",\n        \"theme\": \"info\",\n        \"content\": {\n          \"type\": \"view.text\",\n          \"content\": {\n            \"type\": \"data.input\",\n            \"path\": \"query\"\n          }\n        }\n      },\n      {\n        \"type\": \"view.action-button\",\n        \"label\": \"\u0423\u0442\u043e\u0447\u043d\u0438\u0442\u044c \u0432 \u042f\u043d\u0434\u0435\u043a\u0441\u0435\",\n        \"action\": {\n          \"type\": \"action.open-link\",\n          \"payload\": {\n            \"$ref\": \"vars.yandex\"\n          }\n        }\n      },\n      {\n        \"type\": \"field.button-radio-group\",\n        \"options\": [\n          {\n            \"label\": \"\u0414\u0430\",\n            \"value\": \"yes\"\n          },\n          {\n            \"label\": \"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\",\n            \"value\": \"maybe\"\n          },\n          {\n            \"label\": \"\u041d\u0435\u0442\",\n            \"value\": \"no\"\n          }\n        ],\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        }\n      }\n    ],\n    \"validation\": {\n      \"type\": \"condition.required\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"result\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"yes\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"maybe\"\n      },\n      \"3\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"no\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    },\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\",\n        \"taskWidth\": 500\n      }\n    }\n  ]\n}",
        "lock": {
            "action.open-link": "1.0.1",
            "action.set": "1.0.1",
            "condition.required": "1.1.0",
            "core": "1.3.1",
            "field.button-radio-group": "1.0.1",
            "helper.search-query": "1.1.1",
            "plugin.hotkeys": "1.0.2",
            "plugin.toloka": "1.1.0",
            "view.action-button": "1.0.0",
            "view.alert": "1.0.0",
            "view.list": "1.0.0",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\",\n    \"yandex\": {\n      \"type\": \"helper.search-query\",\n      \"engine\": \"yandex\",\n      \"query\": {\n        \"type\": \"data.input\",\n        \"path\": \"query\"\n      }\n    }\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.alert\",\n        \"theme\": \"info\",\n        \"content\": {\n          \"type\": \"view.text\",\n          \"content\": {\n            \"type\": \"data.input\",\n            \"path\": \"query\"\n          }\n        }\n      },\n      {\n        \"type\": \"view.action-button\",\n        \"label\": \"\u0423\u0442\u043e\u0447\u043d\u0438\u0442\u044c \u0432 \u042f\u043d\u0434\u0435\u043a\u0441\u0435\",\n        \"action\": {\n          \"type\": \"action.open-link\",\n          \"payload\": {\n            \"$ref\": \"vars.yandex\"\n          }\n        }\n      },\n      {\n        \"type\": \"field.button-radio-group\",\n        \"options\": [\n          {\n            \"label\": \"\u0414\u0430\",\n            \"value\": \"yes\"\n          },\n          {\n            \"label\": \"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\",\n            \"value\": \"maybe\"\n          },\n          {\n            \"label\": \"\u041d\u0435\u0442\",\n            \"value\": \"no\"\n          }\n        ],\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        }\n      }\n    ],\n    \"validation\": {\n      \"type\": \"condition.required\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"result\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"yes\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"maybe\"\n      },\n      \"3\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result\"\n        },\n        \"payload\": \"no\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    },\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\",\n        \"taskWidth\": 500\n      }\n    }\n  ]\n}, {\"action.open-link\":\"1.0.1\",\"action.set\":\"1.0.1\",\"condition.required\":\"1.1.0\",\"core\":\"1.3.1\",\"field.button-radio-group\":\"1.0.1\",\"helper.search-query\":\"1.1.1\",\"plugin.hotkeys\":\"1.0.2\",\"plugin.toloka\":\"1.1.0\",\"view.action-button\":\"1.0.0\",\"view.alert\":\"1.0.0\",\"view.list\":\"1.0.0\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.bars\",\n    \"content\": {\n      \"type\": \"view.image\",\n      \"fullHeight\": true,\n      \"scrollable\": true,\n      \"url\": {\n        \"type\": \"data.input\",\n        \"path\": \"screenshot_url\"\n      }\n    },\n    \"barBefore\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.labeled-list\",\n          \"minWidth\": 150,\n          \"items\": [\n            {\n              \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\",\n              \"content\": {\n                \"type\": \"view.link\",\n                \"url\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query\"\n                  },\n                  \"engine\": \"yandex\"\n                },\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"query\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0420\u0435\u0433\u0438\u043e\u043d:\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"region_name\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0414\u0435\u0432\u0430\u0439\u0441:\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"device\"\n                }\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"view.alert\",\n          \"theme\": \"warning\",\n          \"content\": {\n            \"type\": \"view.link\",\n            \"url\": {\n              \"type\": \"data.input\",\n              \"path\": \"url\"\n            }\n          }\n        }\n      ]\n    },\n    \"barAfter\": {\n      \"type\": \"field.button-radio-group\",\n      \"validation\": {\n        \"type\": \"condition.required\"\n      },\n      \"options\": [\n        {\n          \"label\": \"\u0420\u0435\u043b\",\n          \"value\": \"RELEVANT\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0440\u0435\u043b\",\n          \"value\": \"IRRELEVANT\"\n        },\n        {\n          \"label\": \"404\",\n          \"value\": \"_404\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"relevance\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"pager\"\n      }\n    }\n  ]\n}",
        "lock": {
            "condition.required": "1.0.0",
            "core": "1.0.0",
            "field.button-radio-group": "1.0.0",
            "helper.search-query": "1.0.0",
            "layout.bars": "1.0.0",
            "plugin.toloka": "1.0.0",
            "view.alert": "1.0.0",
            "view.image": "1.0.0",
            "view.labeled-list": "1.0.0",
            "view.link": "1.0.0",
            "view.list": "1.0.0",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.bars\",\n    \"content\": {\n      \"type\": \"view.image\",\n      \"fullHeight\": true,\n      \"scrollable\": true,\n      \"url\": {\n        \"type\": \"data.input\",\n        \"path\": \"screenshot_url\"\n      }\n    },\n    \"barBefore\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.labeled-list\",\n          \"minWidth\": 150,\n          \"items\": [\n            {\n              \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\",\n              \"content\": {\n                \"type\": \"view.link\",\n                \"url\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query\"\n                  },\n                  \"engine\": \"yandex\"\n                },\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"query\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0420\u0435\u0433\u0438\u043e\u043d:\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"region_name\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0414\u0435\u0432\u0430\u0439\u0441:\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"device\"\n                }\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"view.alert\",\n          \"theme\": \"warning\",\n          \"content\": {\n            \"type\": \"view.link\",\n            \"url\": {\n              \"type\": \"data.input\",\n              \"path\": \"url\"\n            }\n          }\n        }\n      ]\n    },\n    \"barAfter\": {\n      \"type\": \"field.button-radio-group\",\n      \"validation\": {\n        \"type\": \"condition.required\"\n      },\n      \"options\": [\n        {\n          \"label\": \"\u0420\u0435\u043b\",\n          \"value\": \"RELEVANT\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0440\u0435\u043b\",\n          \"value\": \"IRRELEVANT\"\n        },\n        {\n          \"label\": \"404\",\n          \"value\": \"_404\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"relevance\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"pager\"\n      }\n    }\n  ]\n}, {\"condition.required\":\"1.0.0\",\"core\":\"1.0.0\",\"field.button-radio-group\":\"1.0.0\",\"helper.search-query\":\"1.0.0\",\"layout.bars\":\"1.0.0\",\"plugin.toloka\":\"1.0.0\",\"view.alert\":\"1.0.0\",\"view.image\":\"1.0.0\",\"view.labeled-list\":\"1.0.0\",\"view.link\":\"1.0.0\",\"view.list\":\"1.0.0\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041a \u043a\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 \u043f\u043e \u0443\u0440\u043e\u0432\u043d\u044e \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u0422\u0421 \u0432\u044b\u0448\u0435?\",\n      \"options\": [\n        {\n          \"label\": \"\u041d\u0435\u0442 \u0438\u043b\u0438 \u043f\u043e\u0447\u0442\u0438 \u043d\u0435\u0442 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439\",\n          \"value\": \"YES\"\n        },\n        {\n          \"label\": \"\u0415\u0441\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\n          \"value\": \"NO\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"isDefect4\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"isDefect4\"\n        },\n        \"payload\": \"YES\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"isDefect4\"\n        },\n        \"payload\": \"NO\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.set": "1.0.0",
            "condition.required": "1.0.1",
            "core": "1.2.2",
            "field.radio-group": "1.0.0",
            "layout.columns": "1.0.0",
            "layout.sidebar": "1.0.0",
            "plugin.hotkeys": "1.0.1",
            "view.image": "1.0.2",
            "view.list": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041a \u043a\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 \u043f\u043e \u0443\u0440\u043e\u0432\u043d\u044e \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u0422\u0421 \u0432\u044b\u0448\u0435?\",\n      \"options\": [\n        {\n          \"label\": \"\u041d\u0435\u0442 \u0438\u043b\u0438 \u043f\u043e\u0447\u0442\u0438 \u043d\u0435\u0442 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0439\",\n          \"value\": \"YES\"\n        },\n        {\n          \"label\": \"\u0415\u0441\u0442\u044c \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\n          \"value\": \"NO\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"isDefect4\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"isDefect4\"\n        },\n        \"payload\": \"YES\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"isDefect4\"\n        },\n        \"payload\": \"NO\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.set\":\"1.0.0\",\"condition.required\":\"1.0.1\",\"core\":\"1.2.2\",\"field.radio-group\":\"1.0.0\",\"layout.columns\":\"1.0.0\",\"layout.sidebar\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.1\",\"view.image\":\"1.0.2\",\"view.list\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041e\u0446\u0435\u043d\u0438\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u043e \u0444\u043e\u0442\u043e:\",\n      \"options\": [\n        {\n          \"label\": \"\u0424\u043e\u0442\u043e \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\",\n          \"value\": \"SCREEN_PHOTO\"\n        },\n        {\n          \"label\": \"\u041d\u0435 \u0432\u0441\u0451 \u0422\u0421 \u043f\u043e\u043f\u0430\u043b\u043e \u0432 \u043a\u0430\u0434\u0440 (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"INCOMPLETE_CAPTURE\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0442 \u043e\u0434\u043d\u043e\u0439, \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0438\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0438 \u0422\u0421\",\n          \"value\": \"LACK_OF_PHOTOS\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0447\u0451\u0442\u043a\u043e\u0435 \u0444\u043e\u0442\u043e (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"BLURRY_PHOTO\"\n        },\n        {\n          \"label\": \"\u0422\u0451\u043c\u043d\u043e\u0435 \u0444\u043e\u0442\u043e (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"DARK_PHOTO\"\n        },\n        {\n          \"label\": \"\u0412\u0441\u0451 \u0432 \u043f\u043e\u0440\u044f\u0434\u043a\u0435\",\n          \"value\": \"ALL_GOOD\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"FraudType\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"0\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"ALL_GOOD\"\n      },\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"SCREEN_PHOTO\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"INCOMPLETE_CAPTURE\"\n      },\n      \"3\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"LACK_OF_PHOTOS\"\n      },\n      \"4\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"BLURRY_PHOTO\"\n      },\n      \"5\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"DARK_PHOTO\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.set": "1.0.0",
            "condition.required": "1.0.1",
            "core": "1.2.2",
            "field.radio-group": "1.0.0",
            "layout.columns": "1.0.0",
            "layout.sidebar": "1.0.0",
            "plugin.hotkeys": "1.0.1",
            "view.image": "1.0.2",
            "view.list": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041e\u0446\u0435\u043d\u0438\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0438 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u043e \u0444\u043e\u0442\u043e:\",\n      \"options\": [\n        {\n          \"label\": \"\u0424\u043e\u0442\u043e \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\",\n          \"value\": \"SCREEN_PHOTO\"\n        },\n        {\n          \"label\": \"\u041d\u0435 \u0432\u0441\u0451 \u0422\u0421 \u043f\u043e\u043f\u0430\u043b\u043e \u0432 \u043a\u0430\u0434\u0440 (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"INCOMPLETE_CAPTURE\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0442 \u043e\u0434\u043d\u043e\u0439, \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0438\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0444\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0438 \u0422\u0421\",\n          \"value\": \"LACK_OF_PHOTOS\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0447\u0451\u0442\u043a\u043e\u0435 \u0444\u043e\u0442\u043e (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"BLURRY_PHOTO\"\n        },\n        {\n          \"label\": \"\u0422\u0451\u043c\u043d\u043e\u0435 \u0444\u043e\u0442\u043e (\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u043b\u0438\u0447\u0438\u0442\u044c \u0433\u043e\u0441\u043d\u043e\u043c\u0435\u0440, \u043c\u043e\u0434\u0435\u043b\u044c, \u0446\u0432\u0435\u0442 \u0438\u043b\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043a\u0443\u0437\u043e\u0432\u0430)\",\n          \"value\": \"DARK_PHOTO\"\n        },\n        {\n          \"label\": \"\u0412\u0441\u0451 \u0432 \u043f\u043e\u0440\u044f\u0434\u043a\u0435\",\n          \"value\": \"ALL_GOOD\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"FraudType\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"0\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"ALL_GOOD\"\n      },\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"SCREEN_PHOTO\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"INCOMPLETE_CAPTURE\"\n      },\n      \"3\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"LACK_OF_PHOTOS\"\n      },\n      \"4\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"BLURRY_PHOTO\"\n      },\n      \"5\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"FraudType\"\n        },\n        \"payload\": \"DARK_PHOTO\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.set\":\"1.0.0\",\"condition.required\":\"1.0.1\",\"core\":\"1.2.2\",\"field.radio-group\":\"1.0.0\",\"layout.columns\":\"1.0.0\",\"layout.sidebar\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.1\",\"view.image\":\"1.0.2\",\"view.list\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041e\u0446\u0435\u043d\u0438\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433\u0430:\",\n      \"options\": [\n        {\n          \"label\": \"\u042f\u043d\u0434\u0435\u043a\u0441.\u0422\u0430\u043a\u0441\u0438 (Yango)\",\n          \"value\": \"YANDEX\"\n        },\n        {\n          \"label\": \"\u0423\u0431\u0435\u0440\",\n          \"value\": \"UBER\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u0433\u043b\u044f\u0434\u0435\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0444\u043e\u0442\u043e\",\n          \"value\": \"UNKNOWN\"\n        },\n        {\n          \"label\": \"\u0414\u0440\u0443\u0433\u043e\u0435 \u0431\u0440\u0435\u043d\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\",\n          \"value\": \"OTHER_BRANDING\"\n        },\n        {\n          \"label\": \"\u041f\u0440\u043e\u0447\u0430\u044f \u0440\u0435\u043a\u043b\u0430\u043c\u0430\",\n          \"value\": \"ADS\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0442 \u043d\u0438 \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433\u0430, \u043d\u0438 \u0440\u0435\u043a\u043b\u0430\u043c\u044b\",\n          \"value\": \"BRANDING_FREE\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"BrandingType\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"y\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"YANDEX\"\n      },\n      \"u\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"UBER\"\n      },\n      \"v\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"UNKNOWN\"\n      },\n      \"o\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"OTHER_BRANDING\"\n      },\n      \"a\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"ADS\"\n      },\n      \"n\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"BRANDING_FREE\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.set": "1.0.0",
            "condition.required": "1.0.1",
            "core": "1.2.2",
            "field.radio-group": "1.0.0",
            "layout.columns": "1.0.0",
            "layout.sidebar": "1.0.0",
            "plugin.hotkeys": "1.0.1",
            "view.image": "1.0.2",
            "view.list": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"layout.sidebar\",\n    \"content\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Front\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Back\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        },\n        {\n          \"type\": \"layout.columns\",\n          \"items\": [\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Left\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            },\n            {\n              \"type\": \"view.image\",\n              \"url\": {\n                \"type\": \"data.input\",\n                \"path\": \"Right\"\n              },\n              \"minWidth\": 350,\n              \"rotatable\": true\n            }\n          ]\n        }\n      ]\n    },\n    \"controls\": {\n      \"type\": \"field.radio-group\",\n      \"label\": \"\u041e\u0446\u0435\u043d\u0438\u0442\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433\u0430:\",\n      \"options\": [\n        {\n          \"label\": \"\u042f\u043d\u0434\u0435\u043a\u0441.\u0422\u0430\u043a\u0441\u0438 (Yango)\",\n          \"value\": \"YANDEX\"\n        },\n        {\n          \"label\": \"\u0423\u0431\u0435\u0440\",\n          \"value\": \"UBER\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0437\u0433\u043b\u044f\u0434\u0435\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0444\u043e\u0442\u043e\",\n          \"value\": \"UNKNOWN\"\n        },\n        {\n          \"label\": \"\u0414\u0440\u0443\u0433\u043e\u0435 \u0431\u0440\u0435\u043d\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\",\n          \"value\": \"OTHER_BRANDING\"\n        },\n        {\n          \"label\": \"\u041f\u0440\u043e\u0447\u0430\u044f \u0440\u0435\u043a\u043b\u0430\u043c\u0430\",\n          \"value\": \"ADS\"\n        },\n        {\n          \"label\": \"\u041d\u0435\u0442 \u043d\u0438 \u0431\u0440\u0435\u043d\u0434\u0438\u043d\u0433\u0430, \u043d\u0438 \u0440\u0435\u043a\u043b\u0430\u043c\u044b\",\n          \"value\": \"BRANDING_FREE\"\n        }\n      ],\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"BrandingType\"\n      },\n      \"validation\": {\n        \"type\": \"condition.required\",\n        \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432\"\n      }\n    }\n  },\n  \"plugins\": [\n    {\n      \"y\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"YANDEX\"\n      },\n      \"u\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"UBER\"\n      },\n      \"v\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"UNKNOWN\"\n      },\n      \"o\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"OTHER_BRANDING\"\n      },\n      \"a\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"ADS\"\n      },\n      \"n\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"BrandingType\"\n        },\n        \"payload\": \"BRANDING_FREE\"\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.set\":\"1.0.0\",\"condition.required\":\"1.0.1\",\"core\":\"1.2.2\",\"field.radio-group\":\"1.0.0\",\"layout.columns\":\"1.0.0\",\"layout.sidebar\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.1\",\"view.image\":\"1.0.2\",\"view.list\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\",\n    \"outputLinks\": {\n      \"type\": \"action.set\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"links\"\n      },\n      \"payload\": {\n        \"type\": \"helper.transform\",\n        \"items\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"into\": {\n          \"type\": \"data.local\",\n          \"path\": \"item.url\"\n        }\n      }\n    },\n    \"outputScreenshots\": {\n      \"type\": \"action.set\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"screenshots\"\n      },\n      \"payload\": {\n        \"type\": \"helper.transform\",\n        \"items\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"into\": {\n          \"type\": \"data.local\",\n          \"path\": \"item.screenshot\"\n        }\n      }\n    },\n    \"previewImage\": {\n      \"type\": \"view.image\",\n      \"url\": {\n        \"type\": \"data.input\",\n        \"path\": \"coverImg\",\n        \"default\": \"\"\n      }\n    },\n    \"incomingData\": {\n      \"type\": \"view.labeled-list\",\n      \"minWidth\": 600,\n      \"items\": [\n        {\n          \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"request\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"contentName\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u044f\u0437\u044b\u043a\u0435 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u0430:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"contentNameEng\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0421\u0442\u0440\u0430\u043d\u0430:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"country\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0413\u043e\u0434\u044b \u0432\u044b\u043f\u0443\u0441\u043a\u0430\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"year\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0443\u0436\u043d\u044b\u0435 \u0441\u0435\u0437\u043e\u043d\u044b:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"seasons\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0421\u0435\u0440\u0438\u0439 \u0432 \u0441\u0435\u0437\u043e\u043d\u0435 (\u0434\u043b\u044f \u0441\u0435\u0440\u0438\u0430\u043b\u043e\u0432):\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"episodes\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041f\u0440\u0438\u043c\u0435\u0440\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u0438:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"episodeDurationMin\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"comment\",\n              \"default\": \"\"\n            }\n          }\n        }\n      ]\n    },\n    \"incomingData2\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.action-button\",\n          \"action\": {\n            \"type\": \"action.open-link\",\n            \"payload\": {\n              \"type\": \"data.input\",\n              \"path\": \"kinopoiskLink\",\n              \"default\": \"\"\n            }\n          },\n          \"label\": \"\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0444\u0438\u043b\u044c\u043c\u0430 \u043d\u0430 \u041a\u0438\u043d\u043e\u043f\u043e\u0438\u0441\u043a\u0435\"\n        },\n        {\n          \"type\": \"view.action-button\",\n          \"action\": {\n            \"type\": \"action.open-link\",\n            \"payload\": {\n              \"type\": \"data.input\",\n              \"path\": \"trailer\",\n              \"default\": \"\"\n            }\n          },\n          \"label\": \"\u0422\u0440\u0435\u0439\u043b\u0435\u0440\"\n        }\n      ]\n    },\n    \"yandex\": {\n      \"type\": \"helper.search-query\",\n      \"query\": {\n        \"type\": \"data.input\",\n        \"path\": \"request\",\n        \"default\": \"\"\n      },\n      \"engine\": \"yandex\"\n    },\n    \"vk\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://vk.com/video?len=2&q=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    },\n    \"mail\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://my.mail.ru/video/search?q=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        },\n        \"&duration=medium&duration=long\"\n      ]\n    },\n    \"rutube\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://rutube.ru/search/?query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        },\n        \"&duration=long\"\n      ]\n    },\n    \"youtube\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://www.youtube.com/results?search_query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    },\n    \"dzen\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://zen.yandex.ru/search?query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    }\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.group\",\n        \"label\": {\n          \"type\": \"helper.join\",\n          \"by\": \" \",\n          \"items\": [\n            \"\u041a\u043e\u043d\u0442\u0435\u043d\u0442: \",\n            {\n              \"type\": \"data.input\",\n              \"path\": \"contentType\",\n              \"default\": \"\"\n            },\n            {\n              \"type\": \"helper.join\",\n              \"by\": \"\",\n              \"items\": [\n                \" \\\"\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"contentName\",\n                  \"default\": \"\"\n                },\n                \"\\\"\"\n              ]\n            }\n          ]\n        },\n        \"content\": {\n          \"type\": \"layout.columns\",\n          \"ratio\": [\n            2,\n            2\n          ],\n          \"items\": [\n            {\n              \"$ref\": \"vars.previewImage\"\n            },\n            {\n              \"type\": \"view.list\",\n              \"items\": [\n                {\n                  \"$ref\": \"vars.incomingData\"\n                },\n                {\n                  \"$ref\": \"vars.incomingData2\"\n                }\n              ]\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041f\u043e\u0438\u0441\u043a \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a\",\n        \"content\": {\n          \"type\": \"view.list\",\n          \"items\": [\n            {\n              \"type\": \"view.list\",\n              \"label\": \"\u041f\u043e\u0438\u0449\u0438\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c \u0432 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u044b\u0434\u0430\u0447\u0430 \u042f\u043d\u0434\u0435\u043a\u0441\u0430\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.yandex\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u0438\u0434\u0435\u043e \u0412\u041a\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.vk\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u0438\u0434\u0435\u043e Mail.ru\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.mail\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"Rutube\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.rutube\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"YouTube\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.youtube\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u042f\u043d\u0434\u0435\u043a\u0441.\u0414\u0437\u0435\u043d\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.dzen\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u041e\u0434\u043d\u043e\u043a\u043b\u0430\u0441\u0441\u043d\u0438\u043a\u0438 (\u043d\u0430\u0434\u043e \u0432\u0431\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0443\u043a\u0430\u043c\u0438)\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": \"https://ok.ru/video\"\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"helper.if\",\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": false,\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"noLinks\"\n                }\n              },\n              \"then\": {\n                \"type\": \"field.list\",\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"result\",\n                  \"default\": [\n                    \"\"\n                  ]\n                },\n                \"label\": \"\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0432\u044b\u0434\u0430\u0447\u0435 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043f\u0438\u0440\u0430\u0442\u0441\u0442\u0432\u0430 \u0438 \u0432\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c \u0432 \u043f\u043e\u043b\u044f \u043d\u0438\u0436\u0435\",\n                \"buttonLabel\": \"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0435\u0449\u0451\",\n                \"render\": {\n                  \"type\": \"view.group\",\n                  \"content\": {\n                    \"type\": \"view.list\",\n                    \"items\": [\n                      {\n                        \"type\": \"field.text\",\n                        \"placeholder\": \"\u0421\u0441\u044b\u043b\u043a\u0430 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c\",\n                        \"data\": {\n                          \"type\": \"data.relative\",\n                          \"path\": \"url\"\n                        },\n                        \"validation\": {\n                          \"type\": \"condition.all\",\n                          \"conditions\": [\n                            {\n                              \"type\": \"condition.all\",\n                              \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u044e\u0434\u0430 \u0441\u0441\u044b\u043b\u043a\u0443\",\n                              \"conditions\": [\n                                {\n                                  \"type\": \"condition.schema\",\n                                  \"schema\": {\n                                    \"type\": \"string\",\n                                    \"pattern\": \"^https?://(.{1,63}\\\\.)+.{2,}(/.*)*$\"\n                                  }\n                                },\n                                {\n                                  \"type\": \"condition.not\",\n                                  \"condition\": {\n                                    \"type\": \"condition.empty\"\n                                  }\n                                }\n                              ]\n                            },\n                            {\n                              \"type\": \"condition.less\",\n                              \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0443\u0431\u0440\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u0438\",\n                              \"data\": {\n                                \"type\": \"helper.sum\",\n                                \"items\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.internal\",\n                                    \"path\": \"result\"\n                                  },\n                                  \"into\": {\n                                    \"type\": \"helper.if\",\n                                    \"condition\": {\n                                      \"type\": \"condition.equals\",\n                                      \"data\": {\n                                        \"type\": \"helper.replace\",\n                                        \"data\": {\n                                          \"type\": \"data.local\",\n                                          \"path\": \"item.url\"\n                                        },\n                                        \"find\": \"http://\",\n                                        \"replace\": \"https://\"\n                                      },\n                                      \"to\": {\n                                        \"type\": \"helper.replace\",\n                                        \"data\": {\n                                          \"type\": \"data.relative\",\n                                          \"path\": \"url\"\n                                        },\n                                        \"find\": \"http://\",\n                                        \"replace\": \"https://\"\n                                      }\n                                    },\n                                    \"then\": 1,\n                                    \"else\": 0\n                                  }\n                                }\n                              },\n                              \"then\": 2\n                            },\n                            {\n                              \"hint\": \"\u042d\u0442\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430\",\n                              \"type\": \"condition.not\",\n                              \"condition\": {\n                                \"type\": \"condition.contains\",\n                                \"data\": {\n                                  \"type\": \"helper.replace\",\n                                  \"data\": {\n                                    \"type\": \"data.relative\",\n                                    \"path\": \"url\"\n                                  },\n                                  \"find\": \"http://\",\n                                  \"replace\": \"https://\"\n                                },\n                                \"in\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.input\",\n                                    \"path\": \"foundUrls\",\n                                    \"default\": []\n                                  },\n                                  \"into\": {\n                                    \"type\": \"helper.replace\",\n                                    \"data\": {\n                                      \"type\": \"data.local\",\n                                      \"path\": \"item\"\n                                    },\n                                    \"find\": \"http://\",\n                                    \"replace\": \"https://\"\n                                  }\n                                }\n                              }\n                            },\n                            {\n                              \"type\": \"condition.not\",\n                              \"hint\": \"\u041d\u0430 \u044d\u0442\u043e\u043c \u0434\u043e\u043c\u0435\u043d\u0435 \u043d\u0435\u0442 \u043f\u0438\u0440\u0430\u0442\u0441\u043a\u0438\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439. \u0415\u0441\u043b\u0438 \u044d\u0442\u043e \u043d\u0435 \u0442\u0430\u043a, \u043d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0437\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0443.\",\n                              \"condition\": {\n                                \"type\": \"condition.any\",\n                                \"conditions\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.input\",\n                                    \"path\": \"blackList\",\n                                    \"default\": []\n                                  },\n                                  \"into\": {\n                                    \"type\": \"condition.contains\",\n                                    \"data\": {\n                                      \"type\": \"helper.replace\",\n                                      \"data\": {\n                                        \"type\": \"data.local\",\n                                        \"path\": \"item\"\n                                      },\n                                      \"find\": \"http://\",\n                                      \"replace\": \"https://\"\n                                    },\n                                    \"in\": {\n                                      \"type\": \"helper.join\",\n                                      \"items\": [\n                                        {\n                                          \"type\": \"helper.replace\",\n                                          \"data\": {\n                                            \"type\": \"data.relative\",\n                                            \"path\": \"url\"\n                                          },\n                                          \"find\": \"http://\",\n                                          \"replace\": \"https://\"\n                                        }\n                                      ],\n                                      \"by\": \"\"\n                                    }\n                                  }\n                                }\n                              }\n                            }\n                          ]\n                        }\n                      },\n                      {\n                        \"type\": \"field.file\",\n                        \"data\": {\n                          \"type\": \"data.relative\",\n                          \"path\": \"screenshot\"\n                        },\n                        \"accept\": [\n                          \"image/jpeg\",\n                          \"image/png\"\n                        ],\n                        \"validation\": {\n                          \"type\": \"condition.not\",\n                          \"condition\": {\n                            \"type\": \"condition.empty\",\n                            \"hint\": \"\u043f\u0440\u0438\u043a\u0440\u0435\u043f\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\"\n                          }\n                        }\n                      }\n                    ]\n                  }\n                }\n              }\n            },\n            {\n              \"type\": \"view.divider\"\n            },\n            {\n              \"type\": \"field.checkbox\",\n              \"preserveFalse\": true,\n              \"label\": \"\u0421\u0441\u044b\u043b\u043e\u043a \u043d\u0435\u0442\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"noLinks\"\n              }\n            }\n          ]\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"result\"\n      },\n      \"action\": {\n        \"type\": \"action.bulk\",\n        \"payload\": [\n          {\n            \"$ref\": \"vars.outputLinks\"\n          },\n          {\n            \"$ref\": \"vars.outputScreenshots\"\n          }\n        ]\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"noLinks\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"to\": true\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"result\"\n      },\n      \"condition\": {\n        \"type\": \"condition.not\",\n        \"condition\": {\n          \"type\": \"condition.empty\"\n        }\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.internal\",\n          \"path\": \"noLinks\"\n        },\n        \"payload\": false\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.yandex\"\n        }\n      },\n      \"2\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.vk\"\n        }\n      },\n      \"3\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.mail\"\n        }\n      },\n      \"4\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.rutube\"\n        }\n      },\n      \"5\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.youtube\"\n        }\n      },\n      \"6\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.dzen\"\n        }\n      },\n      \"7\": {\n        \"type\": \"action.open-link\",\n        \"payload\": \"https://ok.ru/video\"\n      },\n      \"up\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"vars.previewImage\"\n        }\n      },\n      \"down\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"vars.previewImage\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    },\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\"\n      }\n    }\n  ]\n}",
        "lock": {
            "action.bulk": "1.0.0",
            "action.open-close": "1.0.0",
            "action.open-link": "1.0.0",
            "action.set": "1.0.0",
            "condition.all": "1.0.1",
            "condition.any": "1.0.1",
            "condition.contains": "1.0.1",
            "condition.empty": "1.0.1",
            "condition.equals": "1.0.1",
            "condition.less": "1.0.1",
            "condition.not": "1.0.0",
            "condition.schema": "1.0.1",
            "core": "1.2.2",
            "field.checkbox": "1.0.0",
            "field.file": "1.1.0",
            "field.list": "1.0.1",
            "field.text": "1.0.0",
            "helper.if": "1.0.0",
            "helper.join": "1.0.0",
            "helper.replace": "1.0.0",
            "helper.search-query": "1.0.0",
            "helper.sum": "1.0.1",
            "helper.transform": "1.0.1",
            "layout.columns": "1.0.0",
            "plugin.hotkeys": "1.0.1",
            "plugin.toloka": "1.0.5",
            "plugin.trigger": "1.0.0",
            "view.action-button": "1.0.0",
            "view.divider": "1.0.0",
            "view.group": "1.0.0",
            "view.image": "1.0.2",
            "view.labeled-list": "1.0.1",
            "view.list": "1.0.0",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\",\n    \"outputLinks\": {\n      \"type\": \"action.set\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"links\"\n      },\n      \"payload\": {\n        \"type\": \"helper.transform\",\n        \"items\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"into\": {\n          \"type\": \"data.local\",\n          \"path\": \"item.url\"\n        }\n      }\n    },\n    \"outputScreenshots\": {\n      \"type\": \"action.set\",\n      \"data\": {\n        \"type\": \"data.output\",\n        \"path\": \"screenshots\"\n      },\n      \"payload\": {\n        \"type\": \"helper.transform\",\n        \"items\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"into\": {\n          \"type\": \"data.local\",\n          \"path\": \"item.screenshot\"\n        }\n      }\n    },\n    \"previewImage\": {\n      \"type\": \"view.image\",\n      \"url\": {\n        \"type\": \"data.input\",\n        \"path\": \"coverImg\",\n        \"default\": \"\"\n      }\n    },\n    \"incomingData\": {\n      \"type\": \"view.labeled-list\",\n      \"minWidth\": 600,\n      \"items\": [\n        {\n          \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"request\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"contentName\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u044f\u0437\u044b\u043a\u0435 \u043e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u0430:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"contentNameEng\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0421\u0442\u0440\u0430\u043d\u0430:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"country\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0413\u043e\u0434\u044b \u0432\u044b\u043f\u0443\u0441\u043a\u0430\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"year\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041d\u0443\u0436\u043d\u044b\u0435 \u0441\u0435\u0437\u043e\u043d\u044b:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"seasons\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u0421\u0435\u0440\u0438\u0439 \u0432 \u0441\u0435\u0437\u043e\u043d\u0435 (\u0434\u043b\u044f \u0441\u0435\u0440\u0438\u0430\u043b\u043e\u0432):\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"episodes\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041f\u0440\u0438\u043c\u0435\u0440\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u0438:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"episodeDurationMin\",\n              \"default\": \"\"\n            }\n          }\n        },\n        {\n          \"label\": \"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:\",\n          \"content\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"type\": \"data.input\",\n              \"path\": \"comment\",\n              \"default\": \"\"\n            }\n          }\n        }\n      ]\n    },\n    \"incomingData2\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.action-button\",\n          \"action\": {\n            \"type\": \"action.open-link\",\n            \"payload\": {\n              \"type\": \"data.input\",\n              \"path\": \"kinopoiskLink\",\n              \"default\": \"\"\n            }\n          },\n          \"label\": \"\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0444\u0438\u043b\u044c\u043c\u0430 \u043d\u0430 \u041a\u0438\u043d\u043e\u043f\u043e\u0438\u0441\u043a\u0435\"\n        },\n        {\n          \"type\": \"view.action-button\",\n          \"action\": {\n            \"type\": \"action.open-link\",\n            \"payload\": {\n              \"type\": \"data.input\",\n              \"path\": \"trailer\",\n              \"default\": \"\"\n            }\n          },\n          \"label\": \"\u0422\u0440\u0435\u0439\u043b\u0435\u0440\"\n        }\n      ]\n    },\n    \"yandex\": {\n      \"type\": \"helper.search-query\",\n      \"query\": {\n        \"type\": \"data.input\",\n        \"path\": \"request\",\n        \"default\": \"\"\n      },\n      \"engine\": \"yandex\"\n    },\n    \"vk\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://vk.com/video?len=2&q=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    },\n    \"mail\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://my.mail.ru/video/search?q=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        },\n        \"&duration=medium&duration=long\"\n      ]\n    },\n    \"rutube\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://rutube.ru/search/?query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        },\n        \"&duration=long\"\n      ]\n    },\n    \"youtube\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://www.youtube.com/results?search_query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    },\n    \"dzen\": {\n      \"type\": \"helper.join\",\n      \"by\": \"\",\n      \"items\": [\n        \"https://zen.yandex.ru/search?query=\",\n        {\n          \"type\": \"data.input\",\n          \"path\": \"contentName\",\n          \"default\": \"\"\n        }\n      ]\n    }\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.group\",\n        \"label\": {\n          \"type\": \"helper.join\",\n          \"by\": \" \",\n          \"items\": [\n            \"\u041a\u043e\u043d\u0442\u0435\u043d\u0442: \",\n            {\n              \"type\": \"data.input\",\n              \"path\": \"contentType\",\n              \"default\": \"\"\n            },\n            {\n              \"type\": \"helper.join\",\n              \"by\": \"\",\n              \"items\": [\n                \" \\\"\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"contentName\",\n                  \"default\": \"\"\n                },\n                \"\\\"\"\n              ]\n            }\n          ]\n        },\n        \"content\": {\n          \"type\": \"layout.columns\",\n          \"ratio\": [\n            2,\n            2\n          ],\n          \"items\": [\n            {\n              \"$ref\": \"vars.previewImage\"\n            },\n            {\n              \"type\": \"view.list\",\n              \"items\": [\n                {\n                  \"$ref\": \"vars.incomingData\"\n                },\n                {\n                  \"$ref\": \"vars.incomingData2\"\n                }\n              ]\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041f\u043e\u0438\u0441\u043a \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a\",\n        \"content\": {\n          \"type\": \"view.list\",\n          \"items\": [\n            {\n              \"type\": \"view.list\",\n              \"label\": \"\u041f\u043e\u0438\u0449\u0438\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c \u0432 \u0440\u0430\u0437\u043d\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u044b\u0434\u0430\u0447\u0430 \u042f\u043d\u0434\u0435\u043a\u0441\u0430\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.yandex\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u0438\u0434\u0435\u043e \u0412\u041a\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.vk\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u0412\u0438\u0434\u0435\u043e Mail.ru\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.mail\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"Rutube\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.rutube\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"YouTube\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.youtube\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u042f\u043d\u0434\u0435\u043a\u0441.\u0414\u0437\u0435\u043d\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": {\n                      \"$ref\": \"vars.dzen\"\n                    }\n                  }\n                },\n                {\n                  \"type\": \"view.action-button\",\n                  \"label\": \"\u041e\u0434\u043d\u043e\u043a\u043b\u0430\u0441\u0441\u043d\u0438\u043a\u0438 (\u043d\u0430\u0434\u043e \u0432\u0431\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0443\u043a\u0430\u043c\u0438)\",\n                  \"action\": {\n                    \"type\": \"action.open-link\",\n                    \"payload\": \"https://ok.ru/video\"\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"helper.if\",\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": false,\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"noLinks\"\n                }\n              },\n              \"then\": {\n                \"type\": \"field.list\",\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"result\",\n                  \"default\": [\n                    \"\"\n                  ]\n                },\n                \"label\": \"\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0432\u044b\u0434\u0430\u0447\u0435 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043f\u0438\u0440\u0430\u0442\u0441\u0442\u0432\u0430 \u0438 \u0432\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c \u0432 \u043f\u043e\u043b\u044f \u043d\u0438\u0436\u0435\",\n                \"buttonLabel\": \"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0435\u0449\u0451\",\n                \"render\": {\n                  \"type\": \"view.group\",\n                  \"content\": {\n                    \"type\": \"view.list\",\n                    \"items\": [\n                      {\n                        \"type\": \"field.text\",\n                        \"placeholder\": \"\u0421\u0441\u044b\u043b\u043a\u0430 \u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u043e\u043c\",\n                        \"data\": {\n                          \"type\": \"data.relative\",\n                          \"path\": \"url\"\n                        },\n                        \"validation\": {\n                          \"type\": \"condition.all\",\n                          \"conditions\": [\n                            {\n                              \"type\": \"condition.all\",\n                              \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u044e\u0434\u0430 \u0441\u0441\u044b\u043b\u043a\u0443\",\n                              \"conditions\": [\n                                {\n                                  \"type\": \"condition.schema\",\n                                  \"schema\": {\n                                    \"type\": \"string\",\n                                    \"pattern\": \"^https?://(.{1,63}\\\\.)+.{2,}(/.*)*$\"\n                                  }\n                                },\n                                {\n                                  \"type\": \"condition.not\",\n                                  \"condition\": {\n                                    \"type\": \"condition.empty\"\n                                  }\n                                }\n                              ]\n                            },\n                            {\n                              \"type\": \"condition.less\",\n                              \"hint\": \"\u041d\u0443\u0436\u043d\u043e \u0443\u0431\u0440\u0430\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0435\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u0438\",\n                              \"data\": {\n                                \"type\": \"helper.sum\",\n                                \"items\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.internal\",\n                                    \"path\": \"result\"\n                                  },\n                                  \"into\": {\n                                    \"type\": \"helper.if\",\n                                    \"condition\": {\n                                      \"type\": \"condition.equals\",\n                                      \"data\": {\n                                        \"type\": \"helper.replace\",\n                                        \"data\": {\n                                          \"type\": \"data.local\",\n                                          \"path\": \"item.url\"\n                                        },\n                                        \"find\": \"http://\",\n                                        \"replace\": \"https://\"\n                                      },\n                                      \"to\": {\n                                        \"type\": \"helper.replace\",\n                                        \"data\": {\n                                          \"type\": \"data.relative\",\n                                          \"path\": \"url\"\n                                        },\n                                        \"find\": \"http://\",\n                                        \"replace\": \"https://\"\n                                      }\n                                    },\n                                    \"then\": 1,\n                                    \"else\": 0\n                                  }\n                                }\n                              },\n                              \"then\": 2\n                            },\n                            {\n                              \"hint\": \"\u042d\u0442\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430\",\n                              \"type\": \"condition.not\",\n                              \"condition\": {\n                                \"type\": \"condition.contains\",\n                                \"data\": {\n                                  \"type\": \"helper.replace\",\n                                  \"data\": {\n                                    \"type\": \"data.relative\",\n                                    \"path\": \"url\"\n                                  },\n                                  \"find\": \"http://\",\n                                  \"replace\": \"https://\"\n                                },\n                                \"in\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.input\",\n                                    \"path\": \"foundUrls\",\n                                    \"default\": []\n                                  },\n                                  \"into\": {\n                                    \"type\": \"helper.replace\",\n                                    \"data\": {\n                                      \"type\": \"data.local\",\n                                      \"path\": \"item\"\n                                    },\n                                    \"find\": \"http://\",\n                                    \"replace\": \"https://\"\n                                  }\n                                }\n                              }\n                            },\n                            {\n                              \"type\": \"condition.not\",\n                              \"hint\": \"\u041d\u0430 \u044d\u0442\u043e\u043c \u0434\u043e\u043c\u0435\u043d\u0435 \u043d\u0435\u0442 \u043f\u0438\u0440\u0430\u0442\u0441\u043a\u0438\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439. \u0415\u0441\u043b\u0438 \u044d\u0442\u043e \u043d\u0435 \u0442\u0430\u043a, \u043d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0437\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0443.\",\n                              \"condition\": {\n                                \"type\": \"condition.any\",\n                                \"conditions\": {\n                                  \"type\": \"helper.transform\",\n                                  \"items\": {\n                                    \"type\": \"data.input\",\n                                    \"path\": \"blackList\",\n                                    \"default\": []\n                                  },\n                                  \"into\": {\n                                    \"type\": \"condition.contains\",\n                                    \"data\": {\n                                      \"type\": \"helper.replace\",\n                                      \"data\": {\n                                        \"type\": \"data.local\",\n                                        \"path\": \"item\"\n                                      },\n                                      \"find\": \"http://\",\n                                      \"replace\": \"https://\"\n                                    },\n                                    \"in\": {\n                                      \"type\": \"helper.join\",\n                                      \"items\": [\n                                        {\n                                          \"type\": \"helper.replace\",\n                                          \"data\": {\n                                            \"type\": \"data.relative\",\n                                            \"path\": \"url\"\n                                          },\n                                          \"find\": \"http://\",\n                                          \"replace\": \"https://\"\n                                        }\n                                      ],\n                                      \"by\": \"\"\n                                    }\n                                  }\n                                }\n                              }\n                            }\n                          ]\n                        }\n                      },\n                      {\n                        \"type\": \"field.file\",\n                        \"data\": {\n                          \"type\": \"data.relative\",\n                          \"path\": \"screenshot\"\n                        },\n                        \"accept\": [\n                          \"image/jpeg\",\n                          \"image/png\"\n                        ],\n                        \"validation\": {\n                          \"type\": \"condition.not\",\n                          \"condition\": {\n                            \"type\": \"condition.empty\",\n                            \"hint\": \"\u043f\u0440\u0438\u043a\u0440\u0435\u043f\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\"\n                          }\n                        }\n                      }\n                    ]\n                  }\n                }\n              }\n            },\n            {\n              \"type\": \"view.divider\"\n            },\n            {\n              \"type\": \"field.checkbox\",\n              \"preserveFalse\": true,\n              \"label\": \"\u0421\u0441\u044b\u043b\u043e\u043a \u043d\u0435\u0442\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"noLinks\"\n              }\n            }\n          ]\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"result\"\n      },\n      \"action\": {\n        \"type\": \"action.bulk\",\n        \"payload\": [\n          {\n            \"$ref\": \"vars.outputLinks\"\n          },\n          {\n            \"$ref\": \"vars.outputScreenshots\"\n          }\n        ]\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"noLinks\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"to\": true\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.internal\",\n          \"path\": \"result\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"result\"\n      },\n      \"condition\": {\n        \"type\": \"condition.not\",\n        \"condition\": {\n          \"type\": \"condition.empty\"\n        }\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.internal\",\n          \"path\": \"noLinks\"\n        },\n        \"payload\": false\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.yandex\"\n        }\n      },\n      \"2\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.vk\"\n        }\n      },\n      \"3\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.mail\"\n        }\n      },\n      \"4\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.rutube\"\n        }\n      },\n      \"5\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.youtube\"\n        }\n      },\n      \"6\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"$ref\": \"vars.dzen\"\n        }\n      },\n      \"7\": {\n        \"type\": \"action.open-link\",\n        \"payload\": \"https://ok.ru/video\"\n      },\n      \"up\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"vars.previewImage\"\n        }\n      },\n      \"down\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"vars.previewImage\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    },\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\"\n      }\n    }\n  ]\n}, {\"action.bulk\":\"1.0.0\",\"action.open-close\":\"1.0.0\",\"action.open-link\":\"1.0.0\",\"action.set\":\"1.0.0\",\"condition.all\":\"1.0.1\",\"condition.any\":\"1.0.1\",\"condition.contains\":\"1.0.1\",\"condition.empty\":\"1.0.1\",\"condition.equals\":\"1.0.1\",\"condition.less\":\"1.0.1\",\"condition.not\":\"1.0.0\",\"condition.schema\":\"1.0.1\",\"core\":\"1.2.2\",\"field.checkbox\":\"1.0.0\",\"field.file\":\"1.1.0\",\"field.list\":\"1.0.1\",\"field.text\":\"1.0.0\",\"helper.if\":\"1.0.0\",\"helper.join\":\"1.0.0\",\"helper.replace\":\"1.0.0\",\"helper.search-query\":\"1.0.0\",\"helper.sum\":\"1.0.1\",\"helper.transform\":\"1.0.1\",\"layout.columns\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.1\",\"plugin.toloka\":\"1.0.5\",\"plugin.trigger\":\"1.0.0\",\"view.action-button\":\"1.0.0\",\"view.divider\":\"1.0.0\",\"view.group\":\"1.0.0\",\"view.image\":\"1.0.2\",\"view.labeled-list\":\"1.0.1\",\"view.list\":\"1.0.0\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\",\n        \"content\": {\n          \"type\": \"view.labeled-list\",\n          \"items\": [\n            {\n              \"label\": \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.query\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0410\u043b\u0438\u0441\u0430\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.reply\"\n                }\n              }\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441\",\n        \"content\": {\n          \"type\": \"view.labeled-list\",\n          \"items\": [\n            {\n              \"label\": \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.next_query\"\n                }\n              }\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041e\u0446\u0435\u043d\u043a\u0430\",\n        \"content\": {\n          \"type\": \"view.list\",\n          \"size\": \"s\",\n          \"items\": [\n            {\n              \"type\": \"field.checkbox-group\",\n              \"label\": \"\u041a \u043a\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0444\u0440\u0430\u0437\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f?\",\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result\"\n              },\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442\",\n                  \"value\": \"nomatch\"\n                }\n              ]\n            },\n            {\n              \"type\": \"field.checkbox-group\",\n              \"disabled\": {\n                \"type\": \"condition.equals\",\n                \"to\": true,\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"result.nomatch\"\n                }\n              },\n              \"options\": {\n                \"type\": \"helper.transform\",\n                \"items\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions\"\n                },\n                \"into\": {\n                  \"type\": \"data.local\",\n                  \"path\": \"item\"\n                }\n              },\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result\"\n              },\n              \"validation\": {\n                \"type\": \"helper.if\",\n                \"condition\": {\n                  \"type\": \"condition.any\",\n                  \"conditions\": [\n                    {\n                      \"type\": \"condition.equals\",\n                      \"data\": {\n                        \"type\": \"data.output\",\n                        \"path\": \"result.nomatch\"\n                      },\n                      \"to\": false\n                    },\n                    {\n                      \"type\": \"condition.empty\",\n                      \"data\": {\n                        \"type\": \"data.output\",\n                        \"path\": \"result.nomatch\"\n                      }\n                    }\n                  ]\n                },\n                \"then\": {\n                  \"type\": \"condition.required\"\n                }\n              }\n            }\n          ]\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"result\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result.nomatch\"\n        },\n        \"to\": true\n      },\n      \"action\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.all\",\n          \"conditions\": [\n            {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result.nomatch\"\n              },\n              \"to\": true\n            },\n            {\n              \"type\": \"condition.not\",\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"result\"\n                },\n                \"to\": {\n                  \"nomatch\": true\n                }\n              }\n            }\n          ]\n        },\n        \"then\": {\n          \"type\": \"action.set\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": \"result\"\n          },\n          \"payload\": {\n            \"nomatch\": true\n          }\n        }\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result.nomatch\"\n        }\n      },\n      \"2\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.0.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.0.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"3\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.1.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.1.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"4\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.2.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.2.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"5\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.3.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.3.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"6\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.4.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.4.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"q\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.5.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.5.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"w\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.6.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.6.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"e\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.7.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.7.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"r\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.8.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.8.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"t\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.9.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.9.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"y\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.10.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.10.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.set": "1.0.0",
            "action.toggle": "1.0.0",
            "condition.all": "1.0.1",
            "condition.any": "1.0.1",
            "condition.empty": "1.0.1",
            "condition.equals": "1.0.1",
            "condition.not": "1.0.0",
            "condition.required": "1.0.1",
            "core": "1.2.1",
            "field.checkbox-group": "1.1.0",
            "helper.if": "1.0.0",
            "helper.join": "1.0.0",
            "helper.transform": "1.0.1",
            "plugin.hotkeys": "1.0.1",
            "plugin.trigger": "1.0.0",
            "view.group": "1.0.0",
            "view.labeled-list": "1.0.1",
            "view.list": "1.0.0",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"assessorlead\",\n    \"task\": \"old\"\n  },\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\",\n        \"content\": {\n          \"type\": \"view.labeled-list\",\n          \"items\": [\n            {\n              \"label\": \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.query\"\n                }\n              }\n            },\n            {\n              \"label\": \"\u0410\u043b\u0438\u0441\u0430\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.reply\"\n                }\n              }\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441\",\n        \"content\": {\n          \"type\": \"view.labeled-list\",\n          \"items\": [\n            {\n              \"label\": \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\",\n              \"content\": {\n                \"type\": \"view.text\",\n                \"content\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.next_query\"\n                }\n              }\n            }\n          ]\n        }\n      },\n      {\n        \"type\": \"view.group\",\n        \"label\": \"\u041e\u0446\u0435\u043d\u043a\u0430\",\n        \"content\": {\n          \"type\": \"view.list\",\n          \"size\": \"s\",\n          \"items\": [\n            {\n              \"type\": \"field.checkbox-group\",\n              \"label\": \"\u041a \u043a\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u0435 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0444\u0440\u0430\u0437\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f?\",\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result\"\n              },\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442\",\n                  \"value\": \"nomatch\"\n                }\n              ]\n            },\n            {\n              \"type\": \"field.checkbox-group\",\n              \"disabled\": {\n                \"type\": \"condition.equals\",\n                \"to\": true,\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"result.nomatch\"\n                }\n              },\n              \"options\": {\n                \"type\": \"helper.transform\",\n                \"items\": {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions\"\n                },\n                \"into\": {\n                  \"type\": \"data.local\",\n                  \"path\": \"item\"\n                }\n              },\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result\"\n              },\n              \"validation\": {\n                \"type\": \"helper.if\",\n                \"condition\": {\n                  \"type\": \"condition.any\",\n                  \"conditions\": [\n                    {\n                      \"type\": \"condition.equals\",\n                      \"data\": {\n                        \"type\": \"data.output\",\n                        \"path\": \"result.nomatch\"\n                      },\n                      \"to\": false\n                    },\n                    {\n                      \"type\": \"condition.empty\",\n                      \"data\": {\n                        \"type\": \"data.output\",\n                        \"path\": \"result.nomatch\"\n                      }\n                    }\n                  ]\n                },\n                \"then\": {\n                  \"type\": \"condition.required\"\n                }\n              }\n            }\n          ]\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"result\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result.nomatch\"\n        },\n        \"to\": true\n      },\n      \"action\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.all\",\n          \"conditions\": [\n            {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"result.nomatch\"\n              },\n              \"to\": true\n            },\n            {\n              \"type\": \"condition.not\",\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"result\"\n                },\n                \"to\": {\n                  \"nomatch\": true\n                }\n              }\n            }\n          ]\n        },\n        \"then\": {\n          \"type\": \"action.set\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": \"result\"\n          },\n          \"payload\": {\n            \"nomatch\": true\n          }\n        }\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"result.nomatch\"\n        }\n      },\n      \"2\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.0.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.0.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"3\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.1.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.1.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"4\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.2.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.2.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"5\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.3.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.3.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"6\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.4.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.4.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"q\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.5.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.5.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"w\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.6.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.6.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"e\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.7.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.7.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"r\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.8.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.8.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"t\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.9.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.9.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"y\": {\n        \"type\": \"helper.if\",\n        \"condition\": {\n          \"type\": \"condition.required\",\n          \"data\": {\n            \"type\": \"data.input\",\n            \"path\": \"row.actions.10.value\"\n          }\n        },\n        \"then\": {\n          \"type\": \"action.toggle\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": {\n              \"type\": \"helper.join\",\n              \"items\": [\n                \"result\",\n                {\n                  \"type\": \"data.input\",\n                  \"path\": \"row.actions.10.value\"\n                }\n              ],\n              \"by\": \".\"\n            }\n          }\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.set\":\"1.0.0\",\"action.toggle\":\"1.0.0\",\"condition.all\":\"1.0.1\",\"condition.any\":\"1.0.1\",\"condition.empty\":\"1.0.1\",\"condition.equals\":\"1.0.1\",\"condition.not\":\"1.0.0\",\"condition.required\":\"1.0.1\",\"core\":\"1.2.1\",\"field.checkbox-group\":\"1.1.0\",\"helper.if\":\"1.0.0\",\"helper.join\":\"1.0.0\",\"helper.transform\":\"1.0.1\",\"plugin.hotkeys\":\"1.0.1\",\"plugin.trigger\":\"1.0.0\",\"view.group\":\"1.0.0\",\"view.labeled-list\":\"1.0.1\",\"view.list\":\"1.0.0\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"product\": \"PRODUCT\",\n    \"service\": \"SERVICE\",\n    \"other\": \"OTHER\",\n    \"product_not_available\": \"PRODUCT_NOT_AVAILABLE\",\n    \"product_available\": \"PRODUCT_AVAILABLE\",\n    \"service_not_available\": \"SERVICE_NOT_AVAILABLE\",\n    \"service_available\": \"SERVICE_AVAILABLE\",\n    \"other_not_available\": \"OTHER_NOT_AVAILABLE\",\n    \"other_available\": \"OTHER_AVAILABLE\",\n    \"tickets\": \"TICKETS\",\n    \"non_purchase\": \"NON_PURCHASE\"\n  },\n  \"view\": {\n    \"type\": \"layout.bars\",\n    \"content\": {\n      \"type\": \"layout.sidebar\",\n      \"content\": {\n        \"type\": \"layout.bars\",\n        \"content\": {\n          \"type\": \"view.image\",\n          \"scrollable\": true,\n          \"url\": {\n            \"type\": \"data.input\",\n            \"path\": \"takenScreen\"\n          }\n        },\n        \"barAfter\": {\n          \"type\": \"view.link\",\n          \"url\": {\n            \"type\": \"data.input\",\n            \"path\": \"url\"\n          }\n        }\n      },\n      \"minWidth\": 1000,\n      \"controlsWidth\": 350,\n      \"controls\": {\n        \"type\": \"view.list\",\n        \"items\": [\n          {\n            \"type\": \"field.radio-group\",\n            \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0437\u0430\u043f\u0440\u043e\u0441\u0430:\",\n            \"options\": [\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0442\u043e\u0432\u0430\u0440\",\n                \"value\": {\n                  \"$ref\": \"vars.product\"\n                }\n              },\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0443\u0441\u043b\u0443\u0433\u0430\",\n                \"value\": {\n                  \"$ref\": \"vars.service\"\n                }\n              },\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u0435\u043b\u044c/\u0431\u0438\u043b\u0435\u0442\u044b/\u0442\u0443\u0440/...\",\n                \"value\": {\n                  \"$ref\": \"vars.tickets\"\n                }\n              },\n              {\n                \"label\": \"\u0414\u0440\u0443\u0433\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441\",\n                \"value\": {\n                  \"$ref\": \"vars.non_purchase\"\n                }\n              }\n            ],\n            \"data\": {\n              \"type\": \"data.internal\",\n              \"path\": \"query_result\"\n            },\n            \"validation\": {\n              \"type\": \"condition.required\",\n              \"data\": \"data.output\"\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.product\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u0443\u043f\u0438\u0442\u044c/\u043d\u0435\u0442 \u0432 \u043d\u0430\u043b\u0438\u0447\u0438\u0438/\u043f\u043e\u043a\u0443\u043f\u043a\u0430 - \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439 \u0441\u0430\u0439\u0442/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.product_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043a\u0443\u043f\u0438\u0442\u044c/\u0437\u0430\u043a\u0430\u0437\u0430\u0442\u044c/\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u044c \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0443/... \u043d\u0430 \u044d\u0442\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435\",\n                  \"value\": {\n                    \"$ref\": \"vars.product_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.service\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f \u043a \u0437\u0430\u043a\u0430\u0437\u0443 \u0443\u0441\u043b\u0443\u0433\u0438\",\n                  \"value\": {\n                    \"$ref\": \"vars.service_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0437\u0430\u043a\u0430\u0437\u0443 \u0443\u0441\u043b\u0443\u0433\u0438\",\n                  \"value\": {\n                    \"$ref\": \"vars.service_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.tickets\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f \u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u043e\u0442\u0435\u043b\u044f/\u0431\u0438\u043b\u0435\u0442\u0430/\u0442\u0443\u0440\u0430/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u043e\u0442\u0435\u043b\u044f/\u0431\u0438\u043b\u0435\u0442\u0430/\u0442\u0443\u0440\u0430/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.non_purchase\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u043f\u043e\u0434\u0440\u0430\u0437\u0443\u043c\u0435\u0432\u0430\u0435\u0442 \u043f\u043e\u043a\u0443\u043f\u043a\u0443/\u043d\u0435\u043b\u044c\u0437\u044f \u043a\u0443\u043f\u0438\u0442\u044c/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043a\u0443\u043f\u0438\u0442\u044c\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          }\n        ]\n      }\n    },\n    \"barBefore\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.list\",\n          \"direction\": \"horizontal\",\n          \"items\": [\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.query_text\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0420\u0435\u0433\u0438\u043e\u043d:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.region_name\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.device\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            }\n          ]\n        },\n        {\n          \"type\": \"view.list\",\n          \"direction\": \"horizontal\",\n          \"items\": [\n            {\n              \"type\": \"view.action-button\",\n              \"label\": \"\u0418\u0441\u043a\u0430\u0442\u044c \u0432 \u042f\u043d\u0434\u0435\u043a\u0441\u0435\",\n              \"action\": {\n                \"type\": \"action.open-link\",\n                \"payload\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query.query_text\"\n                  },\n                  \"engine\": \"yandex\"\n                }\n              }\n            },\n            {\n              \"type\": \"view.action-button\",\n              \"label\": \"\u0418\u0441\u043a\u0430\u0442\u044c \u0432 Google\",\n              \"action\": {\n                \"type\": \"action.open-link\",\n                \"payload\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query.query_text\"\n                  },\n                  \"engine\": \"google\"\n                }\n              }\n            }\n          ]\n        }\n      ]\n    }\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"query_result\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"query_result\"\n        },\n        \"payload\": {\n          \"type\": \"helper.switch\",\n          \"cases\": [\n            {\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": {\n                  \"$ref\": \"vars.product\"\n                },\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"query_result\"\n                }\n              },\n              \"result\": {\n                \"$ref\": \"vars.product\"\n              }\n            },\n            {\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": {\n                  \"$ref\": \"vars.service\"\n                },\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"query_result\"\n                }\n              },\n              \"result\": {\n                \"$ref\": \"vars.service\"\n              }\n            }\n          ],\n          \"default\": {\n            \"$ref\": \"vars.other\"\n          }\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"query_result\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"url_result\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"q\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"type\": \"helper.search-query\",\n          \"query\": {\n            \"type\": \"data.input\",\n            \"path\": \"query.query_text\"\n          },\n          \"engine\": \"yandex\"\n        }\n      },\n      \"w\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"type\": \"helper.search-query\",\n          \"query\": {\n            \"type\": \"data.input\",\n            \"path\": \"query.query_text\"\n          },\n          \"engine\": \"google\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.open-link": "1.0.1",
            "action.set": "1.0.1",
            "condition.equals": "1.1.0",
            "condition.required": "1.1.0",
            "core": "1.3.1",
            "field.radio-group": "1.1.0",
            "helper.if": "1.0.1",
            "helper.join": "1.0.1",
            "helper.search-query": "1.1.1",
            "helper.switch": "1.0.2",
            "layout.bars": "1.0.0",
            "layout.sidebar": "1.0.0",
            "plugin.hotkeys": "1.0.2",
            "plugin.trigger": "1.0.0",
            "view.action-button": "1.0.0",
            "view.image": "1.1.1",
            "view.link": "1.1.0",
            "view.list": "1.0.0",
            "view.markdown": "1.0.1",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"product\": \"PRODUCT\",\n    \"service\": \"SERVICE\",\n    \"other\": \"OTHER\",\n    \"product_not_available\": \"PRODUCT_NOT_AVAILABLE\",\n    \"product_available\": \"PRODUCT_AVAILABLE\",\n    \"service_not_available\": \"SERVICE_NOT_AVAILABLE\",\n    \"service_available\": \"SERVICE_AVAILABLE\",\n    \"other_not_available\": \"OTHER_NOT_AVAILABLE\",\n    \"other_available\": \"OTHER_AVAILABLE\",\n    \"tickets\": \"TICKETS\",\n    \"non_purchase\": \"NON_PURCHASE\"\n  },\n  \"view\": {\n    \"type\": \"layout.bars\",\n    \"content\": {\n      \"type\": \"layout.sidebar\",\n      \"content\": {\n        \"type\": \"layout.bars\",\n        \"content\": {\n          \"type\": \"view.image\",\n          \"scrollable\": true,\n          \"url\": {\n            \"type\": \"data.input\",\n            \"path\": \"takenScreen\"\n          }\n        },\n        \"barAfter\": {\n          \"type\": \"view.link\",\n          \"url\": {\n            \"type\": \"data.input\",\n            \"path\": \"url\"\n          }\n        }\n      },\n      \"minWidth\": 1000,\n      \"controlsWidth\": 350,\n      \"controls\": {\n        \"type\": \"view.list\",\n        \"items\": [\n          {\n            \"type\": \"field.radio-group\",\n            \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0437\u0430\u043f\u0440\u043e\u0441\u0430:\",\n            \"options\": [\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0442\u043e\u0432\u0430\u0440\",\n                \"value\": {\n                  \"$ref\": \"vars.product\"\n                }\n              },\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0443\u0441\u043b\u0443\u0433\u0430\",\n                \"value\": {\n                  \"$ref\": \"vars.service\"\n                }\n              },\n              {\n                \"label\": \"\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u0435\u043b\u044c/\u0431\u0438\u043b\u0435\u0442\u044b/\u0442\u0443\u0440/...\",\n                \"value\": {\n                  \"$ref\": \"vars.tickets\"\n                }\n              },\n              {\n                \"label\": \"\u0414\u0440\u0443\u0433\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441\",\n                \"value\": {\n                  \"$ref\": \"vars.non_purchase\"\n                }\n              }\n            ],\n            \"data\": {\n              \"type\": \"data.internal\",\n              \"path\": \"query_result\"\n            },\n            \"validation\": {\n              \"type\": \"condition.required\",\n              \"data\": \"data.output\"\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.product\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u0443\u043f\u0438\u0442\u044c/\u043d\u0435\u0442 \u0432 \u043d\u0430\u043b\u0438\u0447\u0438\u0438/\u043f\u043e\u043a\u0443\u043f\u043a\u0430 - \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439 \u0441\u0430\u0439\u0442/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.product_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043a\u0443\u043f\u0438\u0442\u044c/\u0437\u0430\u043a\u0430\u0437\u0430\u0442\u044c/\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u044c \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0443/... \u043d\u0430 \u044d\u0442\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435\",\n                  \"value\": {\n                    \"$ref\": \"vars.product_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.service\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f \u043a \u0437\u0430\u043a\u0430\u0437\u0443 \u0443\u0441\u043b\u0443\u0433\u0438\",\n                  \"value\": {\n                    \"$ref\": \"vars.service_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0437\u0430\u043a\u0430\u0437\u0443 \u0443\u0441\u043b\u0443\u0433\u0438\",\n                  \"value\": {\n                    \"$ref\": \"vars.service_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.tickets\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u041d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f \u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u043e\u0442\u0435\u043b\u044f/\u0431\u0438\u043b\u0435\u0442\u0430/\u0442\u0443\u0440\u0430/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u043e\u0442\u0435\u043b\u044f/\u0431\u0438\u043b\u0435\u0442\u0430/\u0442\u0443\u0440\u0430/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          },\n          {\n            \"type\": \"helper.if\",\n            \"condition\": {\n              \"type\": \"condition.equals\",\n              \"data\": {\n                \"type\": \"data.internal\",\n                \"path\": \"query_result\"\n              },\n              \"to\": {\n                \"$ref\": \"vars.non_purchase\"\n              }\n            },\n            \"then\": {\n              \"type\": \"field.radio-group\",\n              \"label\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b:\",\n              \"options\": [\n                {\n                  \"label\": \"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u043f\u043e\u0434\u0440\u0430\u0437\u0443\u043c\u0435\u0432\u0430\u0435\u0442 \u043f\u043e\u043a\u0443\u043f\u043a\u0443/\u043d\u0435\u043b\u044c\u0437\u044f \u043a\u0443\u043f\u0438\u0442\u044c/...\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_not_available\"\n                  }\n                },\n                {\n                  \"label\": \"\u041c\u043e\u0436\u043d\u043e \u043a\u0443\u043f\u0438\u0442\u044c\",\n                  \"value\": {\n                    \"$ref\": \"vars.other_available\"\n                  }\n                }\n              ],\n              \"data\": {\n                \"type\": \"data.output\",\n                \"path\": \"url_result\"\n              },\n              \"validation\": {\n                \"type\": \"condition.required\"\n              }\n            }\n          }\n        ]\n      }\n    },\n    \"barBefore\": {\n      \"type\": \"view.list\",\n      \"items\": [\n        {\n          \"type\": \"view.list\",\n          \"direction\": \"horizontal\",\n          \"items\": [\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0417\u0430\u043f\u0440\u043e\u0441:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.query_text\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0420\u0435\u0433\u0438\u043e\u043d:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.region_name\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            },\n            {\n              \"type\": \"view.list\",\n              \"direction\": \"horizontal\",\n              \"items\": [\n                {\n                  \"type\": \"view.text\",\n                  \"content\": \"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e:\"\n                },\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"helper.join\",\n                    \"items\": [\n                      \"**\",\n                      {\n                        \"type\": \"data.input\",\n                        \"path\": \"query.device\"\n                      },\n                      \"**\"\n                    ]\n                  }\n                }\n              ]\n            }\n          ]\n        },\n        {\n          \"type\": \"view.list\",\n          \"direction\": \"horizontal\",\n          \"items\": [\n            {\n              \"type\": \"view.action-button\",\n              \"label\": \"\u0418\u0441\u043a\u0430\u0442\u044c \u0432 \u042f\u043d\u0434\u0435\u043a\u0441\u0435\",\n              \"action\": {\n                \"type\": \"action.open-link\",\n                \"payload\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query.query_text\"\n                  },\n                  \"engine\": \"yandex\"\n                }\n              }\n            },\n            {\n              \"type\": \"view.action-button\",\n              \"label\": \"\u0418\u0441\u043a\u0430\u0442\u044c \u0432 Google\",\n              \"action\": {\n                \"type\": \"action.open-link\",\n                \"payload\": {\n                  \"type\": \"helper.search-query\",\n                  \"query\": {\n                    \"type\": \"data.input\",\n                    \"path\": \"query.query_text\"\n                  },\n                  \"engine\": \"google\"\n                }\n              }\n            }\n          ]\n        }\n      ]\n    }\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"query_result\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"query_result\"\n        },\n        \"payload\": {\n          \"type\": \"helper.switch\",\n          \"cases\": [\n            {\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": {\n                  \"$ref\": \"vars.product\"\n                },\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"query_result\"\n                }\n              },\n              \"result\": {\n                \"$ref\": \"vars.product\"\n              }\n            },\n            {\n              \"condition\": {\n                \"type\": \"condition.equals\",\n                \"to\": {\n                  \"$ref\": \"vars.service\"\n                },\n                \"data\": {\n                  \"type\": \"data.internal\",\n                  \"path\": \"query_result\"\n                }\n              },\n              \"result\": {\n                \"$ref\": \"vars.service\"\n              }\n            }\n          ],\n          \"default\": {\n            \"$ref\": \"vars.other\"\n          }\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.internal\",\n        \"path\": \"query_result\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"url_result\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"q\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"type\": \"helper.search-query\",\n          \"query\": {\n            \"type\": \"data.input\",\n            \"path\": \"query.query_text\"\n          },\n          \"engine\": \"yandex\"\n        }\n      },\n      \"w\": {\n        \"type\": \"action.open-link\",\n        \"payload\": {\n          \"type\": \"helper.search-query\",\n          \"query\": {\n            \"type\": \"data.input\",\n            \"path\": \"query.query_text\"\n          },\n          \"engine\": \"google\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.open-link\":\"1.0.1\",\"action.set\":\"1.0.1\",\"condition.equals\":\"1.1.0\",\"condition.required\":\"1.1.0\",\"core\":\"1.3.1\",\"field.radio-group\":\"1.1.0\",\"helper.if\":\"1.0.1\",\"helper.join\":\"1.0.1\",\"helper.search-query\":\"1.1.1\",\"helper.switch\":\"1.0.2\",\"layout.bars\":\"1.0.0\",\"layout.sidebar\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.2\",\"plugin.trigger\":\"1.0.0\",\"view.action-button\":\"1.0.0\",\"view.image\":\"1.1.1\",\"view.link\":\"1.1.0\",\"view.list\":\"1.0.0\",\"view.markdown\":\"1.0.1\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.markdown\",\n        \"content\": {\n          \"type\": \"data.input\",\n          \"path\": \"text\"\n        }\n      },\n      {\n        \"type\": \"view.list\",\n        \"items\": {\n          \"type\": \"helper.transform\",\n          \"items\": {\n            \"type\": \"data.input\",\n            \"path\": \"quiz\"\n          },\n          \"into\": {\n            \"type\": \"view.group\",\n            \"content\": {\n              \"type\": \"view.list\",\n              \"items\": [\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"data.local\",\n                    \"path\": \"item.question\"\n                  }\n                },\n                {\n                  \"type\": \"field.radio-group\",\n                  \"options\": {\n                    \"type\": \"data.local\",\n                    \"path\": \"item.options\"\n                  },\n                  \"validation\": {\n                    \"type\": \"condition.required\",\n                    \"hint\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u043e\u0442\u0432\u0435\u0442\u0430\"\n                  },\n                  \"data\": {\n                    \"type\": \"data.output\",\n                    \"path\": {\n                      \"type\": \"helper.join\",\n                      \"items\": [\n                        \"answers\",\n                        {\n                          \"type\": \"data.local\",\n                          \"path\": \"index\"\n                        }\n                      ],\n                      \"by\": \".\"\n                    }\n                  }\n                }\n              ]\n            }\n          }\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"pager\",\n        \"taskWidth\": 730\n      }\n    }\n  ]\n}",
        "lock": {
            "condition.required": "1.0.1",
            "core": "1.2.3",
            "field.radio-group": "1.0.0",
            "helper.join": "1.0.0",
            "helper.transform": "1.0.1",
            "plugin.toloka": "1.0.5",
            "view.group": "1.0.0",
            "view.list": "1.0.0",
            "view.markdown": "1.0.1"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"view\": {\n    \"type\": \"view.list\",\n    \"items\": [\n      {\n        \"type\": \"view.markdown\",\n        \"content\": {\n          \"type\": \"data.input\",\n          \"path\": \"text\"\n        }\n      },\n      {\n        \"type\": \"view.list\",\n        \"items\": {\n          \"type\": \"helper.transform\",\n          \"items\": {\n            \"type\": \"data.input\",\n            \"path\": \"quiz\"\n          },\n          \"into\": {\n            \"type\": \"view.group\",\n            \"content\": {\n              \"type\": \"view.list\",\n              \"items\": [\n                {\n                  \"type\": \"view.markdown\",\n                  \"content\": {\n                    \"type\": \"data.local\",\n                    \"path\": \"item.question\"\n                  }\n                },\n                {\n                  \"type\": \"field.radio-group\",\n                  \"options\": {\n                    \"type\": \"data.local\",\n                    \"path\": \"item.options\"\n                  },\n                  \"validation\": {\n                    \"type\": \"condition.required\",\n                    \"hint\": \"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u043e\u0442\u0432\u0435\u0442\u0430\"\n                  },\n                  \"data\": {\n                    \"type\": \"data.output\",\n                    \"path\": {\n                      \"type\": \"helper.join\",\n                      \"items\": [\n                        \"answers\",\n                        {\n                          \"type\": \"data.local\",\n                          \"path\": \"index\"\n                        }\n                      ],\n                      \"by\": \".\"\n                    }\n                  }\n                }\n              ]\n            }\n          }\n        }\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"pager\",\n        \"taskWidth\": 730\n      }\n    }\n  ]\n}, {\"condition.required\":\"1.0.1\",\"core\":\"1.2.3\",\"field.radio-group\":\"1.0.0\",\"helper.join\":\"1.0.0\",\"helper.transform\":\"1.0.1\",\"plugin.toloka\":\"1.0.5\",\"view.group\":\"1.0.0\",\"view.list\":\"1.0.0\",\"view.markdown\":\"1.0.1\"}, 'https://tb.yandex.net/registry2')"
    },
    {
        "config": "{\n  \"vars\": {\n    \"author\": \"sukhodolskaya\",\n    \"task\": \"old\",\n    \"top_text\": {\n      \"show\": \"yes\",\n      \"message\": \"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d hotkey 3 \u043d\u0430 \u0440\u0430\u0437\u0432\u0435\u0440\u0442\u044b\u0432\u0430\u043d\u0438\u0435/\u0441\u0432\u0435\u0440\u0442\u044b\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438!\"\n    }\n  },\n  \"view\": {\n    \"type\": \"layout.columns\",\n    \"items\": [\n      {\n        \"type\": \"view.image\",\n        \"url\": {\n          \"type\": \"data.input\",\n          \"path\": \"image\"\n        }\n      },\n      {\n        \"type\": \"layout.columns\",\n        \"ratio\": [\n          1,\n          10\n        ],\n        \"minWidth\": 0,\n        \"items\": [\n          {\n            \"type\": \"field.button-radio\",\n            \"label\": \"\u0414\u0430\",\n            \"validation\": {\n              \"type\": \"condition.required\"\n            },\n            \"data\": {\n              \"type\": \"data.output\",\n              \"path\": \"estimation\"\n            },\n            \"valueToSet\": \"OK\"\n          },\n          {\n            \"type\": \"view.list\",\n            \"items\": [\n              {\n                \"type\": \"field.button-radio\",\n                \"label\": \"\u041d\u0435\u0442\",\n                \"validation\": {\n                  \"type\": \"condition.required\"\n                },\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"estimation\"\n                },\n                \"valueToSet\": \"BAD\"\n              },\n              {\n                \"type\": \"field.checkbox-group\",\n                \"validation\": {\n                  \"type\": \"helper.if\",\n                  \"condition\": {\n                    \"type\": \"condition.equals\",\n                    \"data\": {\n                      \"type\": \"data.output\",\n                      \"path\": \"estimation\"\n                    },\n                    \"to\": \"BAD\"\n                  },\n                  \"then\": {\n                    \"type\": \"condition.required\"\n                  }\n                },\n                \"options\": [\n                  {\n                    \"label\": \"\u0422\u043e\u0432\u0430\u0440\u044b \u0434\u043b\u044f \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445\",\n                    \"value\": \"porno\",\n                    \"hint\": \"- \u0421\u0435\u043a\u0441-\u0438\u0433\u0440\u0443\u0448\u043a\u0438 (\u0432\u0438\u0431\u0440\u0430\u0442\u043e\u0440\u044b, \u043d\u0430\u0440\u0443\u0447\u043d\u0438\u043a\u0438, \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u043a\u0430 \u0411\u0414\u0421\u041c \u0438 \u0442.\u0434.)\\n\"\n                  },\n                  {\n                    \"label\": \"\u042d\u0440\u043e\u0442\u0438\u043a\u0430, \u043f\u043e\u0440\u043d\u043e\",\n                    \"value\": \"porno_grey_zone\",\n                    \"hint\": \"- \u041e\u0431\u043d\u0430\u0436\u0435\u043d\u043a\u0430/\u043f\u043e\u0441\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0446\u0435\u043d\u044b\\n- \u041d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0430\u043a\u0446\u0435\u043d\u0442 \u043d\u0430 \u0433\u0440\u0443\u0434\u044c/\u043f\u043e\u043f\u0443/\u0433\u0435\u043d\u0438\u0442\u0430\u043b\u0438\u0438\\n- \u041d\u0430\u0440\u0438\u0441\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0430\u043d\u0438\u043c\u044d) \u0441 \u043d\u0430\u043c\u0435\u043a\u043e\u043c \u043d\u0430 \u044d\u0440\u043e\u0442\u0438\u043a\u0443/\u043f\u043e\u0440\u043d\u043e\\n- \u042d\u0440\u043e\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0431\u0435\u043b\u044c\u0435 \u043d\u0430 \u043c\u043e\u0434\u0435\u043b\u044f\u0445 \u043e\u0431\u043e\u0435\u0433\u043e \u043f\u043e\u043b\u0430 (\u0441\u0442\u0440\u0438\u043d\u0433\u0438, \u043a\u0440\u0443\u0436\u0435\u0432\u043d\u043e\u0435, \u043f\u0440\u043e\u0441\u0432\u0435\u0447\u0438\u0432\u0430\u044e\u0449\u0435\u0435)\"\n                  },\n                  {\n                    \"label\": \"\u0410\u043b\u043a\u043e\u0433\u043e\u043b\u044c, \u043a\u0443\u0440\u0435\u043d\u0438\u0435, \u043d\u0430\u0440\u043a\u043e\u0442\u0438\u043a\u0438\",\n                    \"value\": \"illegal\",\n                    \"hint\": \"- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044f/\u0435\u0435 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043a\u0443\u0440\u0435\u043d\u0438\u0435/\u043f\u0430\u0440\u0435\u043d\u0438\u0435 \u0418 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 \u043d\u0438\u043c\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u043a\u0430 (\u0442\u0430\u0431\u0430\u0447\u043d\u044b\u0435 \u0438\u0437\u0434\u0435\u043b\u0438\u044f, \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0435 \u0441\u0438\u0433\u0430\u0440\u0435\u0442\u044b, \u043a\u0430\u043b\u044c\u044f\u043d\u044b \u0438 \u0442.\u0434.)\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u043d\u0430\u0440\u043a\u043e\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0432\u0435\u0449\u0435\u0441\u0442\u0432\u0430/\u0438\u0445 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435\"\n                  },\n                  {\n                    \"label\": \"\u041a\u0430\u0437\u0438\u043d\u043e, \u0430\u0437\u0430\u0440\u0442\u043d\u044b\u0435 \u0438\u0433\u0440\u044b (\u043d\u0430 \u0434\u0435\u043d\u044c\u0433\u0438, \u0430 \u041d\u0415 \u043d\u0430\u0441\u0442\u043e\u043b\u044c\u043d\u044b\u0435 \u0438\u0433\u0440\u044b)\",\n                    \"value\": \"casino\",\n                    \"hint\": \"- \u041b\u043e\u0433\u043e\u0442\u0438\u043f\u044b \u043a\u0430\u0437\u0438\u043d\u043e (Vavada, \u0412\u0443\u043b\u043a\u0430\u043d, \u0410\u0437\u0438\u043d\u043e 777)\\n- \u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u044b \u0438\u0433\u043e\u0440\u043d\u044b\u0435 \u0441\u0442\u043e\u043b\u044b, \u0438\u0433\u0440\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u044b, \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0441 \u043e\u043d\u043b\u0430\u0439\u043d-\u043a\u0430\u0437\u0438\u043d\u043e/\u0430\u0437\u0430\u0440\u0442\u043d\u044b\u043c\u0438 \u0438\u0433\u0440\u0430\u043c\u0438 \u0438 \u0437\u0430\u0441\u0442\u0430\u0432\u043a\u0438 \u0441 \u0438\u0433\u0440\u043e\u0432\u044b\u0445 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u043e\u0432\\n- \u041f\u0440\u0438\u0437\u044b\u0432 \u043a \u0438\u0433\u0440\u0435 \u043d\u0430 \u0434\u0435\u043d\u044c\u0433\u0438\"\n                  },\n                  {\n                    \"label\": \"\u0414\u0435\u043d\u044c\u0433\u0438, \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435 \u043a\u0430\u0440\u0442\u044b, \u0440\u0435\u043a\u043b\u0430\u043c\u0430 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430/\u0437\u0430\u0439\u043c\u043e\u0432\",\n                    \"value\": \"casino_grey_zone\",\n                    \"hint\": \"- \u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u0443\u043f\u044e\u0440 \u0438\u043b\u0438 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0445 \u043a\u0430\u0440\u0442 (\u043a\u043b\u044e\u0447\u0435\u0439 \u043e\u0442 \u043c\u0430\u0448\u0438\u043d \u0438 \u0442.\u0434.) \u0431\u0435\u0437 \u043f\u0440\u044f\u043c\u043e\u0439 \u0441\u0432\u044f\u0437\u0438 \u0441 \u043a\u0430\u0437\u0438\u043d\u043e\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0430 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430/\u0437\u0430\u0439\u043c\u043e\u0432\"\n                  },\n                  {\n                    \"label\": \"\u041e\u0440\u0443\u0436\u0438\u0435\",\n                    \"value\": \"guns\",\n                    \"hint\": \"- \u0425\u043e\u043b\u043e\u0434\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435, \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0412\u0418\u0414\u041d\u041e \u0440\u0435\u0436\u0443\u0449\u0443\u044e \u0447\u0430\u0441\u0442\u044c\\n- \u041e\u0433\u043d\u0435\u0441\u0442\u0440\u0435\u043b\u044c\u043d\u043e\u0435, \u043f\u043d\u0435\u0432\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435 \u0411\u0415\u0417 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0435\u0433\u043e \u043c\u043e\u0434\u0435\u043b\u0438\\n- \u041c\u0435\u0442\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435\\n- \u041c\u0438\u043d\u044b \u0438 \u0433\u0440\u0430\u043d\u0430\u0442\u044b\\n- \u0420\u0430\u043a\u0435\u0442\u043d\u043e\u0435/\u0442\u043e\u0440\u043f\u0435\u0434\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435\\n- \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u0448\u043e\u043a\u0435\u0440\u044b\"\n                  },\n                  {\n                    \"label\": \"\u041f\u0443\u0433\u0430\u044e\u0449\u0435\u0435/\u0442\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435/\u043e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u043b\u0438 \u043e\u0441\u043a\u043e\u0440\u0431\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\",\n                    \"value\": \"yellow\",\n                    \"hint\": \"- \u041f\u0443\u0433\u0430\u044e\u0449\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u043d\u0435\u0447\u0438\u0441\u0442\u044c (\u0411\u0415\u0417 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0432\u0438\u0434\u0435 \u0444\u0438\u043b\u044c\u043c\u0430/\u043a\u043d\u0438\u0433\u0438/\u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438), \u0441\u0446\u0435\u043d\u044b \u043d\u0430\u0441\u0438\u043b\u0438\u044f, \u0440\u0430\u0441\u0447\u043b\u0435\u043d\u0435\u043d\u043a\u0430, \u0438\u0441\u043a\u0440\u0438\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0442 \u0443\u0436\u0430\u0441\u0430/\u0421\u0418\u041b\u042c\u041d\u041e\u0419 \u0431\u043e\u043b\u0438 \u043b\u0438\u0446\u0430 \u043b\u044e\u0434\u0435\u0439, \u043f\u0440\u0438\u0437\u044b\u0432\u044b \u043a \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0443/\u0441\u043c\u0435\u0440\u0442\u0438, \u0443\u0433\u0440\u043e\u0437\u044b\\n- \u0422\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u043a\u0430\u0434\u0440\u044b \u0441 \u043c\u0435\u0441\u0442\u0430 \u0430\u0432\u0430\u0440\u0438\u0439, \u0441\u0432\u044f\u0437\u044c \u0441 \u0441\u0430\u043c\u043e\u0443\u0431\u0438\u0439\u0441\u0442\u0432\u043e\u043c/\u0430\u0431\u043e\u0440\u0442\u043e\u043c, \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b\\n- \u041e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f - \u0433\u043d\u043e\u0439, \u043f\u0440\u044b\u0449\u0438, \u0432\u043e\u0441\u043f\u0430\u043b\u0435\u043d\u0438\u044f, \u0433\u0440\u044f\u0437\u044c, \u0440\u0430\u0437\u043b\u043e\u0436\u0435\u043d\u0438\u0435, \u043e\u0431\u044a\u0435\u0434\u043a\u0438, \u0440\u0432\u043e\u0442\u0430\\n- \u041e\u0441\u043a\u043e\u0440\u0431\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0435 \u043c\u0430\u0442, \u0436\u0430\u0440\u0433\u043e\u043d, \u0440\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u044e\u0449\u0438\u0435 \u0440\u0430\u0441\u0438\u0437\u043c/\u0441\u0435\u043a\u0441\u0438\u0437\u043c/\u043d\u0430\u0446\u0438\u0437\u043c, \u043e\u0441\u043a\u043e\u0440\u0431\u043b\u044f\u044e\u0449\u0438\u0435 \u0432\u0435\u0442\u0435\u0440\u0430\u043d\u043e\u0432/\u0438\u043d\u0432\u0430\u043b\u0438\u0434\u043e\u0432\"\n                  },\n                  {\n                    \"label\": \"\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430\",\n                    \"value\": \"interface_elements\",\n                    \"hint\": \"- \u0418\u043c\u0438\u0442\u0430\u0446\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043a\u043d\u043e\u043f\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u0436\u0430\u0442\u044c; \u043a\u0443\u0440\u0441\u043e\u0440, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u0434\u0432\u0438\u0433\u0430\u0442\u044c)\"\n                  },\n                  {\n                    \"label\": \"\u0420\u0435\u043a\u043b\u0430\u043c\u0430 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0433\u043e/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0433\u043e\\\" \u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u044f, \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0438/\u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438/\u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f\",\n                    \"value\": \"yellow_grey_zone\",\n                    \"hint\": \"- \u041d\u0435 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430, \u043e\u0431\u0435\u0449\u0430\u044e\u0449\u0438\u0435 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0435/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0435\\\" \u0438\u0441\u0446\u0435\u043b\u0435\u043d\u0438\u0435/\u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u0435/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u0435 \u0441\u0430\u043c\u043e\u0447\u0443\u0432\u0441\u0442\u0432\u0438\u044f \u0438\u043b\u0438 \u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438: \u0411\u0410\u0414\u044b, \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430\\n- \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0434\u043e \u0438/\u0438\u043b\u0438 \u043f\u043e\u0441\u043b\u0435 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0433\u043e/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0433\u043e\\\" \u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u044f/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0438/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f/\u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438\"\n                  },\n                  {\n                    \"label\": \"\u041d\u0435\u044f\u0441\u043d\u043e, \u0447\u0442\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043e\",\n                    \"value\": \"undefined\",\n                    \"hint\": \"- \u041d\u0435\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442, \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044b\u0439 \u043d\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0435\"\n                  }\n                ],\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"reasons\"\n                }\n              }\n            ]\n          }\n        ]\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\",\n        \"taskWidth\": 690\n      },\n      \"notifications\": [\n        {\n          \"type\": \"helper.if\",\n          \"condition\": {\n            \"type\": \"condition.equals\",\n            \"to\": \"yes\",\n            \"data\": {\n              \"$ref\": \"vars.top_text.show\"\n            }\n          },\n          \"then\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"$ref\": \"vars.top_text.message\"\n            }\n          }\n        }\n      ]\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"estimation\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"to\": \"OK\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"reasons\"\n      },\n      \"condition\": {\n        \"type\": \"condition.not\",\n        \"condition\": {\n          \"type\": \"condition.empty\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": \"reasons\"\n          }\n        }\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"BAD\"\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"OK\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"BAD\"\n      },\n      \"3\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"view.items.0\"\n        }\n      },\n      \"q\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.porno\"\n        }\n      },\n      \"w\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.porno_grey_zone\"\n        }\n      },\n      \"e\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.illegal\"\n        }\n      },\n      \"r\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.casino\"\n        }\n      },\n      \"t\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.casino_grey_zone\"\n        }\n      },\n      \"y\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.guns\"\n        }\n      },\n      \"a\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.yellow\"\n        }\n      },\n      \"s\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.interface_elements\"\n        }\n      },\n      \"d\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.yellow_grey_zone\"\n        }\n      },\n      \"f\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.undefined\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}",
        "lock": {
            "action.open-close": "1.0.0",
            "action.set": "1.0.0",
            "action.toggle": "1.0.0",
            "condition.empty": "1.0.0",
            "condition.equals": "1.0.0",
            "condition.not": "1.0.0",
            "condition.required": "1.0.0",
            "core": "1.0.0",
            "field.button-radio": "1.0.0",
            "field.checkbox-group": "1.0.0",
            "helper.if": "1.0.0",
            "layout.columns": "1.0.0",
            "plugin.hotkeys": "1.0.0",
            "plugin.toloka": "1.0.0",
            "plugin.trigger": "1.0.0",
            "view.image": "1.0.0",
            "view.list": "1.0.0",
            "view.text": "1.0.0"
        },
        "settings": {
            "showFinish": True,
            "showFullscreen": True,
            "showInstructions": True,
            "showMessage": True,
            "showReward": True,
            "showSkip": True,
            "showSubmit": True,
            "showTimer": True,
            "showTitle": True
        },
        "type": "tb",
        "assets": {
            "script_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.js"
            ],
            "style_urls": [
                "https://yastat.net/s3/tb/launcher.template/_/master.825664685.2020-11-19.6390a7cf.css"
            ]
        },
        "markup": "",
        "styles": "",
        "script": "window.configureTemplate({\n  \"vars\": {\n    \"author\": \"sukhodolskaya\",\n    \"task\": \"old\",\n    \"top_text\": {\n      \"show\": \"yes\",\n      \"message\": \"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d hotkey 3 \u043d\u0430 \u0440\u0430\u0437\u0432\u0435\u0440\u0442\u044b\u0432\u0430\u043d\u0438\u0435/\u0441\u0432\u0435\u0440\u0442\u044b\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438!\"\n    }\n  },\n  \"view\": {\n    \"type\": \"layout.columns\",\n    \"items\": [\n      {\n        \"type\": \"view.image\",\n        \"url\": {\n          \"type\": \"data.input\",\n          \"path\": \"image\"\n        }\n      },\n      {\n        \"type\": \"layout.columns\",\n        \"ratio\": [\n          1,\n          10\n        ],\n        \"minWidth\": 0,\n        \"items\": [\n          {\n            \"type\": \"field.button-radio\",\n            \"label\": \"\u0414\u0430\",\n            \"validation\": {\n              \"type\": \"condition.required\"\n            },\n            \"data\": {\n              \"type\": \"data.output\",\n              \"path\": \"estimation\"\n            },\n            \"valueToSet\": \"OK\"\n          },\n          {\n            \"type\": \"view.list\",\n            \"items\": [\n              {\n                \"type\": \"field.button-radio\",\n                \"label\": \"\u041d\u0435\u0442\",\n                \"validation\": {\n                  \"type\": \"condition.required\"\n                },\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"estimation\"\n                },\n                \"valueToSet\": \"BAD\"\n              },\n              {\n                \"type\": \"field.checkbox-group\",\n                \"validation\": {\n                  \"type\": \"helper.if\",\n                  \"condition\": {\n                    \"type\": \"condition.equals\",\n                    \"data\": {\n                      \"type\": \"data.output\",\n                      \"path\": \"estimation\"\n                    },\n                    \"to\": \"BAD\"\n                  },\n                  \"then\": {\n                    \"type\": \"condition.required\"\n                  }\n                },\n                \"options\": [\n                  {\n                    \"label\": \"\u0422\u043e\u0432\u0430\u0440\u044b \u0434\u043b\u044f \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445\",\n                    \"value\": \"porno\",\n                    \"hint\": \"- \u0421\u0435\u043a\u0441-\u0438\u0433\u0440\u0443\u0448\u043a\u0438 (\u0432\u0438\u0431\u0440\u0430\u0442\u043e\u0440\u044b, \u043d\u0430\u0440\u0443\u0447\u043d\u0438\u043a\u0438, \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u043a\u0430 \u0411\u0414\u0421\u041c \u0438 \u0442.\u0434.)\\n\"\n                  },\n                  {\n                    \"label\": \"\u042d\u0440\u043e\u0442\u0438\u043a\u0430, \u043f\u043e\u0440\u043d\u043e\",\n                    \"value\": \"porno_grey_zone\",\n                    \"hint\": \"- \u041e\u0431\u043d\u0430\u0436\u0435\u043d\u043a\u0430/\u043f\u043e\u0441\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0446\u0435\u043d\u044b\\n- \u041d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0430\u043a\u0446\u0435\u043d\u0442 \u043d\u0430 \u0433\u0440\u0443\u0434\u044c/\u043f\u043e\u043f\u0443/\u0433\u0435\u043d\u0438\u0442\u0430\u043b\u0438\u0438\\n- \u041d\u0430\u0440\u0438\u0441\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0430\u043d\u0438\u043c\u044d) \u0441 \u043d\u0430\u043c\u0435\u043a\u043e\u043c \u043d\u0430 \u044d\u0440\u043e\u0442\u0438\u043a\u0443/\u043f\u043e\u0440\u043d\u043e\\n- \u042d\u0440\u043e\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0431\u0435\u043b\u044c\u0435 \u043d\u0430 \u043c\u043e\u0434\u0435\u043b\u044f\u0445 \u043e\u0431\u043e\u0435\u0433\u043e \u043f\u043e\u043b\u0430 (\u0441\u0442\u0440\u0438\u043d\u0433\u0438, \u043a\u0440\u0443\u0436\u0435\u0432\u043d\u043e\u0435, \u043f\u0440\u043e\u0441\u0432\u0435\u0447\u0438\u0432\u0430\u044e\u0449\u0435\u0435)\"\n                  },\n                  {\n                    \"label\": \"\u0410\u043b\u043a\u043e\u0433\u043e\u043b\u044c, \u043a\u0443\u0440\u0435\u043d\u0438\u0435, \u043d\u0430\u0440\u043a\u043e\u0442\u0438\u043a\u0438\",\n                    \"value\": \"illegal\",\n                    \"hint\": \"- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0430\u043b\u043a\u043e\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0446\u0438\u044f/\u0435\u0435 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043a\u0443\u0440\u0435\u043d\u0438\u0435/\u043f\u0430\u0440\u0435\u043d\u0438\u0435 \u0418 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u0430\u044f \u0441 \u043d\u0438\u043c\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u043a\u0430 (\u0442\u0430\u0431\u0430\u0447\u043d\u044b\u0435 \u0438\u0437\u0434\u0435\u043b\u0438\u044f, \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0435 \u0441\u0438\u0433\u0430\u0440\u0435\u0442\u044b, \u043a\u0430\u043b\u044c\u044f\u043d\u044b \u0438 \u0442.\u0434.)\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u043d\u0430\u0440\u043a\u043e\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0432\u0435\u0449\u0435\u0441\u0442\u0432\u0430/\u0438\u0445 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435\"\n                  },\n                  {\n                    \"label\": \"\u041a\u0430\u0437\u0438\u043d\u043e, \u0430\u0437\u0430\u0440\u0442\u043d\u044b\u0435 \u0438\u0433\u0440\u044b (\u043d\u0430 \u0434\u0435\u043d\u044c\u0433\u0438, \u0430 \u041d\u0415 \u043d\u0430\u0441\u0442\u043e\u043b\u044c\u043d\u044b\u0435 \u0438\u0433\u0440\u044b)\",\n                    \"value\": \"casino\",\n                    \"hint\": \"- \u041b\u043e\u0433\u043e\u0442\u0438\u043f\u044b \u043a\u0430\u0437\u0438\u043d\u043e (Vavada, \u0412\u0443\u043b\u043a\u0430\u043d, \u0410\u0437\u0438\u043d\u043e 777)\\n- \u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u044b \u0438\u0433\u043e\u0440\u043d\u044b\u0435 \u0441\u0442\u043e\u043b\u044b, \u0438\u0433\u0440\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u044b, \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0441 \u043e\u043d\u043b\u0430\u0439\u043d-\u043a\u0430\u0437\u0438\u043d\u043e/\u0430\u0437\u0430\u0440\u0442\u043d\u044b\u043c\u0438 \u0438\u0433\u0440\u0430\u043c\u0438 \u0438 \u0437\u0430\u0441\u0442\u0430\u0432\u043a\u0438 \u0441 \u0438\u0433\u0440\u043e\u0432\u044b\u0445 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u043e\u0432\\n- \u041f\u0440\u0438\u0437\u044b\u0432 \u043a \u0438\u0433\u0440\u0435 \u043d\u0430 \u0434\u0435\u043d\u044c\u0433\u0438\"\n                  },\n                  {\n                    \"label\": \"\u0414\u0435\u043d\u044c\u0433\u0438, \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435 \u043a\u0430\u0440\u0442\u044b, \u0440\u0435\u043a\u043b\u0430\u043c\u0430 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430/\u0437\u0430\u0439\u043c\u043e\u0432\",\n                    \"value\": \"casino_grey_zone\",\n                    \"hint\": \"- \u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u0443\u043f\u044e\u0440 \u0438\u043b\u0438 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0445 \u043a\u0430\u0440\u0442 (\u043a\u043b\u044e\u0447\u0435\u0439 \u043e\u0442 \u043c\u0430\u0448\u0438\u043d \u0438 \u0442.\u0434.) \u0431\u0435\u0437 \u043f\u0440\u044f\u043c\u043e\u0439 \u0441\u0432\u044f\u0437\u0438 \u0441 \u043a\u0430\u0437\u0438\u043d\u043e\\n- \u0420\u0435\u043a\u043b\u0430\u043c\u0430 \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430/\u0437\u0430\u0439\u043c\u043e\u0432\"\n                  },\n                  {\n                    \"label\": \"\u041e\u0440\u0443\u0436\u0438\u0435\",\n                    \"value\": \"guns\",\n                    \"hint\": \"- \u0425\u043e\u043b\u043e\u0434\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435, \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0412\u0418\u0414\u041d\u041e \u0440\u0435\u0436\u0443\u0449\u0443\u044e \u0447\u0430\u0441\u0442\u044c\\n- \u041e\u0433\u043d\u0435\u0441\u0442\u0440\u0435\u043b\u044c\u043d\u043e\u0435, \u043f\u043d\u0435\u0432\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435 \u0411\u0415\u0417 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u043d\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0435\u0433\u043e \u043c\u043e\u0434\u0435\u043b\u0438\\n- \u041c\u0435\u0442\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435\\n- \u041c\u0438\u043d\u044b \u0438 \u0433\u0440\u0430\u043d\u0430\u0442\u044b\\n- \u0420\u0430\u043a\u0435\u0442\u043d\u043e\u0435/\u0442\u043e\u0440\u043f\u0435\u0434\u043d\u043e\u0435 \u043e\u0440\u0443\u0436\u0438\u0435\\n- \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u0448\u043e\u043a\u0435\u0440\u044b\"\n                  },\n                  {\n                    \"label\": \"\u041f\u0443\u0433\u0430\u044e\u0449\u0435\u0435/\u0442\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435/\u043e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u043b\u0438 \u043e\u0441\u043a\u043e\u0440\u0431\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\",\n                    \"value\": \"yellow\",\n                    \"hint\": \"- \u041f\u0443\u0433\u0430\u044e\u0449\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u043d\u0435\u0447\u0438\u0441\u0442\u044c (\u0411\u0415\u0417 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0432 \u0432\u0438\u0434\u0435 \u0444\u0438\u043b\u044c\u043c\u0430/\u043a\u043d\u0438\u0433\u0438/\u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438), \u0441\u0446\u0435\u043d\u044b \u043d\u0430\u0441\u0438\u043b\u0438\u044f, \u0440\u0430\u0441\u0447\u043b\u0435\u043d\u0435\u043d\u043a\u0430, \u0438\u0441\u043a\u0440\u0438\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0442 \u0443\u0436\u0430\u0441\u0430/\u0421\u0418\u041b\u042c\u041d\u041e\u0419 \u0431\u043e\u043b\u0438 \u043b\u0438\u0446\u0430 \u043b\u044e\u0434\u0435\u0439, \u043f\u0440\u0438\u0437\u044b\u0432\u044b \u043a \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0443/\u0441\u043c\u0435\u0440\u0442\u0438, \u0443\u0433\u0440\u043e\u0437\u044b\\n- \u0422\u0440\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u043a\u0430\u0434\u0440\u044b \u0441 \u043c\u0435\u0441\u0442\u0430 \u0430\u0432\u0430\u0440\u0438\u0439, \u0441\u0432\u044f\u0437\u044c \u0441 \u0441\u0430\u043c\u043e\u0443\u0431\u0438\u0439\u0441\u0442\u0432\u043e\u043c/\u0430\u0431\u043e\u0440\u0442\u043e\u043c, \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b\\n- \u041e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f - \u0433\u043d\u043e\u0439, \u043f\u0440\u044b\u0449\u0438, \u0432\u043e\u0441\u043f\u0430\u043b\u0435\u043d\u0438\u044f, \u0433\u0440\u044f\u0437\u044c, \u0440\u0430\u0437\u043b\u043e\u0436\u0435\u043d\u0438\u0435, \u043e\u0431\u044a\u0435\u0434\u043a\u0438, \u0440\u0432\u043e\u0442\u0430\\n- \u041e\u0441\u043a\u043e\u0440\u0431\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f: \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0435 \u043c\u0430\u0442, \u0436\u0430\u0440\u0433\u043e\u043d, \u0440\u0435\u043a\u043b\u0430\u043c\u0438\u0440\u0443\u044e\u0449\u0438\u0435 \u0440\u0430\u0441\u0438\u0437\u043c/\u0441\u0435\u043a\u0441\u0438\u0437\u043c/\u043d\u0430\u0446\u0438\u0437\u043c, \u043e\u0441\u043a\u043e\u0440\u0431\u043b\u044f\u044e\u0449\u0438\u0435 \u0432\u0435\u0442\u0435\u0440\u0430\u043d\u043e\u0432/\u0438\u043d\u0432\u0430\u043b\u0438\u0434\u043e\u0432\"\n                  },\n                  {\n                    \"label\": \"\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430\",\n                    \"value\": \"interface_elements\",\n                    \"hint\": \"- \u0418\u043c\u0438\u0442\u0430\u0446\u0438\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 (\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043a\u043d\u043e\u043f\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u0436\u0430\u0442\u044c; \u043a\u0443\u0440\u0441\u043e\u0440, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u0434\u0432\u0438\u0433\u0430\u0442\u044c)\"\n                  },\n                  {\n                    \"label\": \"\u0420\u0435\u043a\u043b\u0430\u043c\u0430 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0433\u043e/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0433\u043e\\\" \u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u044f, \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0438/\u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438/\u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f\",\n                    \"value\": \"yellow_grey_zone\",\n                    \"hint\": \"- \u041d\u0435 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430, \u043e\u0431\u0435\u0449\u0430\u044e\u0449\u0438\u0435 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0435/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0435\\\" \u0438\u0441\u0446\u0435\u043b\u0435\u043d\u0438\u0435/\u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u0435/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u0435 \u0441\u0430\u043c\u043e\u0447\u0443\u0432\u0441\u0442\u0432\u0438\u044f \u0438\u043b\u0438 \u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438: \u0411\u0410\u0414\u044b, \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430\\n- \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0434\u043e \u0438/\u0438\u043b\u0438 \u043f\u043e\u0441\u043b\u0435 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0433\u043e/\\\"\u0447\u0443\u0434\u0435\u0441\u043d\u043e\u0433\u043e\\\" \u043f\u043e\u0445\u0443\u0434\u0435\u043d\u0438\u044f/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0438/\u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f/\u0432\u043d\u0435\u0448\u043d\u043e\u0441\u0442\u0438\"\n                  },\n                  {\n                    \"label\": \"\u041d\u0435\u044f\u0441\u043d\u043e, \u0447\u0442\u043e \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043e\",\n                    \"value\": \"undefined\",\n                    \"hint\": \"- \u041d\u0435\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442, \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044b\u0439 \u043d\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0435\"\n                  }\n                ],\n                \"data\": {\n                  \"type\": \"data.output\",\n                  \"path\": \"reasons\"\n                }\n              }\n            ]\n          }\n        ]\n      }\n    ]\n  },\n  \"plugins\": [\n    {\n      \"type\": \"plugin.toloka\",\n      \"layout\": {\n        \"kind\": \"scroll\",\n        \"taskWidth\": 690\n      },\n      \"notifications\": [\n        {\n          \"type\": \"helper.if\",\n          \"condition\": {\n            \"type\": \"condition.equals\",\n            \"to\": \"yes\",\n            \"data\": {\n              \"$ref\": \"vars.top_text.show\"\n            }\n          },\n          \"then\": {\n            \"type\": \"view.text\",\n            \"content\": {\n              \"$ref\": \"vars.top_text.message\"\n            }\n          }\n        }\n      ]\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"estimation\"\n      },\n      \"condition\": {\n        \"type\": \"condition.equals\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"to\": \"OK\"\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons\"\n        },\n        \"payload\": {\n          \"$empty\": true\n        }\n      }\n    },\n    {\n      \"type\": \"plugin.trigger\",\n      \"onChangeOf\": {\n        \"type\": \"data.output\",\n        \"path\": \"reasons\"\n      },\n      \"condition\": {\n        \"type\": \"condition.not\",\n        \"condition\": {\n          \"type\": \"condition.empty\",\n          \"data\": {\n            \"type\": \"data.output\",\n            \"path\": \"reasons\"\n          }\n        }\n      },\n      \"action\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"BAD\"\n      }\n    },\n    {\n      \"1\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"OK\"\n      },\n      \"2\": {\n        \"type\": \"action.set\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"estimation\"\n        },\n        \"payload\": \"BAD\"\n      },\n      \"3\": {\n        \"type\": \"action.open-close\",\n        \"view\": {\n          \"$ref\": \"view.items.0\"\n        }\n      },\n      \"q\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.porno\"\n        }\n      },\n      \"w\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.porno_grey_zone\"\n        }\n      },\n      \"e\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.illegal\"\n        }\n      },\n      \"r\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.casino\"\n        }\n      },\n      \"t\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.casino_grey_zone\"\n        }\n      },\n      \"y\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.guns\"\n        }\n      },\n      \"a\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.yellow\"\n        }\n      },\n      \"s\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.interface_elements\"\n        }\n      },\n      \"d\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.yellow_grey_zone\"\n        }\n      },\n      \"f\": {\n        \"type\": \"action.toggle\",\n        \"data\": {\n          \"type\": \"data.output\",\n          \"path\": \"reasons.undefined\"\n        }\n      },\n      \"type\": \"plugin.hotkeys\"\n    }\n  ]\n}, {\"action.open-close\":\"1.0.0\",\"action.set\":\"1.0.0\",\"action.toggle\":\"1.0.0\",\"condition.empty\":\"1.0.0\",\"condition.equals\":\"1.0.0\",\"condition.not\":\"1.0.0\",\"condition.required\":\"1.0.0\",\"core\":\"1.0.0\",\"field.button-radio\":\"1.0.0\",\"field.checkbox-group\":\"1.0.0\",\"helper.if\":\"1.0.0\",\"layout.columns\":\"1.0.0\",\"plugin.hotkeys\":\"1.0.0\",\"plugin.toloka\":\"1.0.0\",\"plugin.trigger\":\"1.0.0\",\"view.image\":\"1.0.0\",\"view.list\":\"1.0.0\",\"view.text\":\"1.0.0\"}, 'https://tb.yandex.net/registry2')"
    }
]


@pytest.fixture
def example_view_spec(request):
    return EXAMPLES[request.param]
