## Разработка переехала в аркадию, теперь либа живет в library/python/ylock

## ЧТО ЭТО
Библиотека для удобной работы с распределенными локами (блокировками), которая имеет простой интерфейс и умеет использовать разные бекэнды.

## Использование

```python
import ylock

manager = ylock.create_manager(
    backend='zookeeper',
    hosts=['host1:2181', 'host2:2181'],
    prefix='myprefix'
)


# пытаемся взять лок, либо ждем пока он освободится
lock = manager.lock('lock-name')

with lock:
    do_something_exclusively()
    

# пытаемся взять лок, но если он занят, то ничего не делаем
lock = manager.lock('another-lock-name', block=False)

with lock as is_locked_successfully:
    if is_locked_successfully:
        do_something_exclusively()
```

### Блокирующий/неблокирующий режим

Лок можно попробовать взять в двух режимах. В блокирующем, когда взятие лока блокирует процесс до того момента, пока лок не будет доступен. Неблокирующий – сразу возвращает результат в виде флага, который символизирует успешность операции.

### Класс менеджера

Объект менеджера поддерживает внутри себя подключение к выбранному бекэнду и создает объекты локов.

Методы:

* `def lock(self, name, timeout=None, block=None)` – создает и возвращает объект лока с заданным именем `name`. `block` – флаг блокировки. `timeout` – таймаут после которого лок сам освобождается.

* `def lock_from_context(self, context)` – создает объект лока и возвращает его по заданному контексту `context`.

* `def close(self)` – закрывает соединение с бекэндом. Рекомендуется вызывать этот метод, когда менеджер больше не нужен и можно закрыть соединение.


Вспомогательная функция `ylock.create_manager` создает менеджер для заданного бекэнда.

Параметры:
 * `backend` – название бекэнда. См. раздел "доступные бекэнды". 
 
 Плюс параметры для конкретного бекэнда.


### Класс лока

Объекты лока создаются менеджером и содержат в себе всю необходимую логику для работы с блокировкой.

Методы:
* `def acquire(self)` - берет лок и возвращает флаг успешности операции.

* `def release(self)` – отпускает лок и возвращает флаг успешности операции.

* `def get_context(self)` – возвращает некий контекст лока, который можно передать в метод `create_from_context` менеджера и получить тот же лок в том же состоянии.

### Декоратор `locked`

Для удобства блокировки каких-то готовых частей логики можно использовать декоратор `ylock.decorators.locked`.

Параметры:
 * `name` – имя лока.
 * `manager` – объект менеджера.

Опциональные параметры:
 * `timeout` – таймаут лока.
 * `block` – флаг блокировки.

Пример использования:
```(python)
from ylock import decorators


@decorators.locked('lock-name', manager)    
def do_something():
    ....
```

### Доступные бекэнды

* `zookeeper` – использует ZooKeeper.

    Параметры:
    * `hosts` – список хостов для подключения к бекэнду. 
    * `prefix` – префикс названия локов.

    Опциональные параметры:
    * `connect_timeout` – таймаут на подключение.


* `mongodb` – использует MongoDB.

    Параметры:
    * `hosts` – список хостов для подключения к бекэнду.
    * `prefix` – префикс названия локов.
 
    Опциональные параметры:
    * `retry_count` – число проверок доступности лока в блокирующем режиме.
    * `sleep_interval` – интервал между проверками доступности лока.
    * `db_name` – название базы.
    * `collection_name` – название коллекции в базе.


* `yt` – использует YT. Инструкция для подключения на Вики - https://wiki.yandex-team.ru/tools/dev/locke/

    Параметры:
    * `token` – OAuth токен роботного пользователя для аутентификации в кластере YT.

    Опциональные параметры:
    * `proxy` – имя кластера в YT, например, 'hahn'. Значение по-умочанию - 'locke'.
    * `prefix` – имя аккаунта/директории в YT. Значение по-умочанию - 'tmp'.
