import argparse
import logging
import yaml
import time

from load.projects.bfg2020.src.bfg import BFG

parser = argparse.ArgumentParser()
parser.add_argument("-c", "--config", type=str, help="path to bfg config", default='bfg.yaml')
args = parser.parse_args()


def main():
    with open(args.config) as cfg:
        config_dict = yaml.load(cfg.read(), Loader=yaml.FullLoader)

    logging.basicConfig(level=config_dict.get('log_level', 'INFO'))

    bfg = BFG(config_dict)
    bfg.configure()
    bfg.prepare_test()
    bfg.start_test()

    while bfg.is_test_finished() == -1:
        time.sleep(1)


if __name__ == "__main__":
    main()
