import os
import logging
from dotenv import load_dotenv

logger = logging.getLogger(__name__)


class EnvironmentConfig:
    __slots__ = [
        # server
        'ENV_TYPE',
        'SERVER_URL',
        'SERVER_PORT',
        'CLUSTER_ID',
        'AGENT_REQUEST_FREQUENCY',
        'MAX_WORKERS',
        'MAX_QUEUE',

        'CLICKHOUSE_HOST',
        'CLICKHOUSE_PORT',
        'CLICKHOUSE_USER',
        'CLICKHOUSE_DBNAME',
        'DB_CERT_FILE',

        'POSTGRESQL_HOST',
        'POSTGRESQL_USER',
        'POSTGRESQL_PORT',
        'POSTGRESQL_DBNAME',

        'IMAGES_FOLDER_ID',

        'CERT_PATH',
        'CERT_KEY_PATH',

        'UNIFIED_AGENT_URI',
        'PROMETHEUS_PUSHGATEWAY',

        'PERMANENT_LOG_LEVEL',
        'ENABLE_LOCAL_LOGGING',

        # cloud helper
        'ACCESS_SERVICE_HOST',
        'ACCESS_SERVICE_PORT',

        'COMPUTE_HOST',
        'COMPUTE_PORT',

        'RESOURCE_MANAGER_HOST',
        'RESOURCE_MANAGER_PORT',

        'OBJECT_STORAGE_URL',
        'OBJECT_STORAGE_DEFAULT_BUCKET',
        'OBJECT_STORAGE_HTTP_HOST',
        'OBJECT_STORAGE_HTTP_PORT',
        'OBJECT_STORAGE_HOST',
        'OBJECT_STORAGE_PORT',

        'KMS_HOST',
        'KMS_PORT',
        'KMS_KEY_ID',
        'KMS_AAD',

        'TARGET_AGENT_VERSION',

        'TEST_MODE',

        'LOGGING_HOST',
        'LOGGING_PORT',

        'HEALTHCHECK_PORT',
    ]

    def __getattr__(self, name):
        self.__setattr__(name, os.getenv(name))
        return self.__getattribute__(name)


def load_config(config_path):
    if os.path.exists(config_path):
        load_dotenv(config_path)
        logger.info(f"Load environment variables from {config_path}")
    else:
        raise FileNotFoundError(f'There is no config file: {config_path}')
