from load.projects.cloud.loadtesting.db.tables import JobConfigTable


class JobConfigQueries:
    def __init__(self, session):
        self._session = session

    def get(self, config_id: str) -> JobConfigTable:
        return self._session.query(JobConfigTable).filter(JobConfigTable.id == config_id).first()

    def get_by_job_id(self, job_id: str) -> JobConfigTable:
        return self._session.query(JobConfigTable).filter(JobConfigTable.job_id == job_id).first()
