CREATE TYPE jobs_statuses AS ENUM ('CREATED', 'FAILED', 'INITIATED', 'PREPARING', 'RUNNING', 'FINISHING', 'FINISHED', 'POST_PROCESS', 'STOPPING', 'STOPPED', 'NOT_FOUND');
CREATE TYPE generators_enum AS ENUM ('GENERATOR_UNSPECIFIED', 'PHANTOM', 'PANDORA');
CREATE TYPE client_statuses_enum AS ENUM ('STATUS_UNSPECIFIED', 'PREPARING_TEST', 'READY_FOR_TEST', 'TESTING', 'TANK_FAILED');
CREATE TYPE statuses_enum AS ENUM ('STATUS_UNSPECIFIED', 'PREPARING_TEST', 'READY_FOR_TEST', 'TESTING', 'TANK_FAILED', 'PROVISIONING', 'STOPPING', 'STOPPED', 'STARTING', 'RESTARTING', 'UPDATING', 'ERROR', 'CRASHED', 'DELETING', 'LOST_CONNECTION_WITH_TANK', 'INITIALIZING_CONNECTION');
CREATE TYPE types_enum AS ENUM ('STOP');
CREATE TYPE resources_enum AS ENUM ('TANK', 'JOB');
CREATE TYPE signal_statuses_enum AS ENUM ('WAITING', 'EXECUTING', 'DONE');


CREATE TABLE ammos
(
    n         SERIAL NOT NULL,
    id        VARCHAR(50),
    name      VARCHAR(50),
    link      VARCHAR(50),
    content   VARCHAR,
    folder_id VARCHAR(50),
    PRIMARY KEY (n),
    UNIQUE (id)
);


CREATE TABLE tanks
(
    n                           SERIAL NOT NULL,
    id                          VARCHAR(50),
    compute_instance_id         VARCHAR(50),
    client_status               client_statuses_enum,
    status                      statuses_enum,
    client_updated_at           TIMESTAMP WITHOUT TIME ZONE,
    folder_id                   VARCHAR(50),
    tank_folder_id              VARCHAR(50),
    created_at                  TIMESTAMP WITHOUT TIME ZONE DEFAULT (now() AT TIME ZONE 'utc') NOT NULL,
    compute_instance_updated_at TIMESTAMP WITHOUT TIME ZONE,
    description                 VARCHAR(256),
    service_account_id          VARCHAR(50),
    preset_id                   VARCHAR(50),
    tank_version                VARCHAR(50),
    errors                      VARCHAR(50),
    name                        VARCHAR(50),
    labels                      VARCHAR(50),
    current_job                 VARCHAR(50),
    PRIMARY KEY (n),
    UNIQUE (id),
    UNIQUE (compute_instance_id)
);


CREATE TABLE signals
(
    n            SERIAL NOT NULL,
    job_id       VARCHAR,
    type         types_enum,
    status       signal_statuses_enum,
    operation_id VARCHAR,
    created_at   TIMESTAMP WITHOUT TIME ZONE,
    done_at      TIMESTAMP WITHOUT TIME ZONE,
    PRIMARY KEY (n)
);



CREATE TABLE operations
(
    n                      SERIAL NOT NULL,
    id                     VARCHAR(50),
    folder_id              VARCHAR(50),
    compute_operation_id   VARCHAR(50),
    target_resource_id     VARCHAR(50),
    target_resource_type   resources_enum,
    description            VARCHAR,
    created_at             TIMESTAMP WITHOUT TIME ZONE DEFAULT (now() AT TIME ZONE 'utc') NOT NULL,
    created_by             VARCHAR(50),
    modified_at            TIMESTAMP WITHOUT TIME ZONE,
    done                   BOOLEAN,
    error                  VARCHAR,
    metadata               JSON,
    done_resource_snapshot JSON,
    PRIMARY KEY (n),
    UNIQUE (id)
);


CREATE TABLE presets
(
    n           SERIAL NOT NULL,
    id          VARCHAR(50),
    name        VARCHAR(50),
    description VARCHAR(256),
    disk_size   BIGINT,
    memory      BIGINT,
    cores       INTEGER,
    PRIMARY KEY (n),
    UNIQUE (id)
);


INSERT INTO presets
VALUES (1, '1', 'small', 'small tests', 16106127360, 2147483648, 2),
       (2, '2', 'medium', 'medium tests', 32212254720, 4294967296, 4),
       (3, '3', 'large', 'large tests', 64424509440, 8589934592, 8);



CREATE TABLE jobs
(
    n                   SERIAL NOT NULL,
    id                  VARCHAR(50),
    folder_id           VARCHAR(50),
    name                VARCHAR,
    description         VARCHAR,
    labels              HSTORE,
    status              jobs_statuses,
    status_updated_at   TIMESTAMP WITHOUT TIME ZONE,
    created_at          TIMESTAMP WITHOUT TIME ZONE DEFAULT (now() AT TIME ZONE 'utc') NOT NULL,
    started_at          TIMESTAMP WITHOUT TIME ZONE,
    finished_at         TIMESTAMP WITHOUT TIME ZONE,
    updated_at          TIMESTAMP WITHOUT TIME ZONE,
    target_address      VARCHAR(50),
    target_port         INTEGER,
    version             VARCHAR(50),
    generator           generators_enum,
    cases               VARCHAR[],
    favorite            BOOLEAN,
    tank_id             VARCHAR,
    errors              VARCHAR[],
    internal_tank_error VARCHAR,
    PRIMARY KEY (n),
    UNIQUE (id),
    FOREIGN KEY (tank_id) REFERENCES tanks (id) ON DELETE SET NULL
);



CREATE TABLE ammo_job
(
    ammos_id VARCHAR(50),
    jobs_id  VARCHAR(50),
    FOREIGN KEY (ammos_id) REFERENCES ammos (id),
    FOREIGN KEY (jobs_id) REFERENCES jobs (id)
);



CREATE TABLE configs
(
    n           SERIAL NOT NULL,
    id          VARCHAR(50),
    raw_content VARCHAR,
    content     JSON,
    job_id      VARCHAR,
    PRIMARY KEY (n),
    UNIQUE (id),
    FOREIGN KEY (job_id) REFERENCES jobs (id)
);
