CREATE TYPE agent_version_statuses AS ENUM ('TARGET', 'ACTUAL', 'DEPRECATED', 'OUTDATED', 'TESTING');

CREATE TABLE agent_versions
(
    image_id     VARCHAR,
    status       agent_version_statuses,
    arc_hash     VARCHAR,
    arc_revision INTEGER,
    description  VARCHAR,
    created_at   TIMESTAMP WITHOUT TIME ZONE DEFAULT (now() AT TIME ZONE 'utc') NOT NULL,
    PRIMARY KEY (image_id)
);

ALTER TABLE tanks
    ADD agent_version VARCHAR;

ALTER TABLE tanks
    ADD CONSTRAINT agent_version_link
        FOREIGN KEY (agent_version)
            REFERENCES agent_versions (image_id)
            ON DELETE set null ON UPDATE cascade;
