CREATE TABLE IF NOT EXISTS loadtesting.monitoring_verbose_data
(
    time        DateTime,
    job_id      UInt32,
    target_host String,
    metric_type String,
    metric_name String,
    value       Float64
)
    ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/monitoring_verbose_data', '{replica}')
    PARTITION BY toYYYYMM(time)
    ORDER BY (job_id, time);

CREATE TABLE IF NOT EXISTS loadtesting.monitoring_verbose_data_buffer AS loadtesting.monitoring_verbose_data ENGINE =
    Buffer(loadtesting, monitoring_verbose_data, 16, 10, 100, 10000, 1000000, 10000000, 20000000);
