from sqlalchemy.orm import Query

from load.projects.cloud.loadtesting.db.tables import PresetTable
from load.projects.cloud.loadtesting.logan import lookup_logger


class PresetQueries:
    def __init__(self, session):
        self._session = session

    def get(self, preset_id):
        result = self._session.query(PresetTable).filter(PresetTable.id == preset_id).first()
        lookup_logger().debug(f"Get preset from PG: {result}")
        return result

    def list(self, offset=None, limit=None):
        query: Query = self._session.query(PresetTable)
        if offset is not None:
            query = query.offset(offset)
        if limit is not None:
            query = query.limit(limit)
        result = query.all()
        lookup_logger().debug(f"Preset list: {result}")
        return result
