import sqlalchemy
from enum import Enum as PyEnum
from sqlalchemy import Column, String, DateTime
from sqlalchemy.dialects.postgresql import ENUM as SqlEnum

from load.projects.cloud.loadtesting.db.connection import BASE


class Status(PyEnum):
    TARGET = 'TARGET'
    ACTUAL = 'ACTUAL'
    DEPRECATED = 'DEPRECATED'
    OUTDATED = 'OUTDATED'
    TESTING = 'TESTING'
    UNSET = 'UNSET'
    UNKNOWN = 'UNKNOWN'


# TODO: Move to Tanker
STATUS_COMMENTS = {
    'ru': {
        Status.DEPRECATED.value: 'Существует более актуальная версия агента. '
                           'Часть функциональности может не поддерживаться',
        Status.OUTDATED.value: 'Версия агента устарела. Пересоздайте агент или обновите его вручную',
        Status.ACTUAL.value: 'Установлена последняя версия агента',
        Status.UNSET.value: 'Версия агента неизвестна сервису. В случае, если он работает некорректно, пересоздайте агент '
                      'или обратитесь в поддержку',
        Status.UNKNOWN.value: 'Версия агента неизвестна сервису. В случае, если он работает некорректно, пересоздайте агент или '
                        'обратитесь в поддержку',
        Status.TARGET.value: 'Установлена последняя версия агента',
        Status.TESTING.value: 'Тестовая версия агента'
    },
    'en': {
        Status.DEPRECATED.value: 'The agent version is deprecated. Some features may be not supported',
        Status.OUTDATED.value: 'The agent version is outdated. Re-create agent or update it manually',
        Status.ACTUAL.value: 'The latest agent version',
        Status.UNSET.value: 'The agent version is unknown. In case it\'s working incorrectly re-create agent '
                            'or ask support for help',
        Status.UNKNOWN.value: 'The agent version is unknown. In case it\'s working incorrectly re-create agent '
                            'or ask support for help',
        Status.TARGET.value: 'The latest agent version',
        Status.TESTING.value: 'Testing agent version'
    }
}


class AgentVersionTable(BASE):
    __tablename__ = 'agent_versions'
    __table_args__ = {'extend_existing': True}

    image_id = Column('image_id', String(), primary_key=True)
    status = Column('status', SqlEnum(*[s.value for s in Status], name='agent_version_statuses'))

    hash = Column('arc_hash', String())
    revision = Column('arc_revision', String())
    description = Column('description', String())
    created_at = Column('created_at', DateTime, server_default=sqlalchemy.sql.func.now())
