from sqlalchemy import Column, String, Integer, ForeignKey, Table
from sqlalchemy.orm import relationship

from load.projects.cloud.loadtesting.db.connection import BASE


ammo_job_table = Table('ammo_job', BASE.metadata,
                       Column('ammos_id', ForeignKey('ammos.id')),
                       Column('jobs_id', ForeignKey('jobs.id'))
                       )


class AmmoTable(BASE):
    __tablename__ = "ammos"
    __table_args__ = {"extend_existing": True}

    n = Column('n', Integer(), primary_key=True, autoincrement=True)
    id = Column('id', String(50), unique=True)
    folder_id = Column('folder_id', String(50))
    storage_id = Column(String, ForeignKey('storages.id', ondelete='SET NULL'))
    storage = relationship('StorageTable', back_populates='ammos')
    s3_name = Column('name', String(50))
    link = Column('link', String(50))
    content = Column('content', String)

    jobs = relationship('JobTable', secondary=ammo_job_table, backref='ammos')
