from sqlalchemy import Column, String, Integer, ForeignKey, JSON
from sqlalchemy.orm import relationship

from load.projects.cloud.loadtesting.db.connection import BASE


class JobConfigTable(BASE):
    __tablename__ = 'configs'
    __table_args__ = {'extend_existing': True}

    n = Column('n', Integer(), primary_key=True, autoincrement=True)
    id = Column('id', String(50), unique=True)
    raw_content = Column('raw_content', String)
    content = Column('content', JSON)

    job_id = Column(String, ForeignKey('jobs.id', ondelete='CASCADE'))
    job = relationship('JobTable', back_populates='config')
