from enum import Enum as PyEnum

from sqlalchemy.dialects.postgresql import ENUM as SqlEnum
from sqlalchemy import Column, DateTime, String, Integer, text, Boolean, JSON
from load.projects.cloud.loadtesting.db.connection import BASE


# TODO: del old
class ResourceType(PyEnum):
    AGENT = 'AGENT'
    TANK = 'TANK'
    JOB = 'JOB'
    STORAGE = 'STORAGE'


class OperationTable(BASE):
    __tablename__ = 'operations'
    n = Column('n', Integer(), primary_key=True, autoincrement=True)
    id = Column('id', String(50), unique=True)
    folder_id = Column('folder_id', String(50))
    foreign_operation_id = Column('foreign_operation_id', String(50))
    target_resource_id = Column('target_resource_id', String(50))
    target_resource_type = Column('target_resource_type',
                                  SqlEnum(*[r.value for r in ResourceType], name='resources_enum'))
    description = Column('description', String)
    created_at = Column('created_at', DateTime, nullable=False, server_default=text("now()"))
    created_by = Column('created_by', String(50))
    modified_at = Column('modified_at', DateTime)
    done = Column('done', Boolean, default=False)
    error = Column('error', String)
    resource_metadata = Column('metadata', JSON)
    done_resource_snapshot = Column('done_resource_snapshot', JSON)

    def __str__(self):
        return f"Operation: operation_id={self.id}, folder_id={self.folder_id}, {self.target_resource_type}={self.target_resource_id}. {self.description}"
