CREATE TYPE jobs_statuses AS ENUM ('CREATED', 'FAILED', 'INITIATED', 'PREPARING', 'RUNNING', 'FINISHING', 'FINISHED', 'POST_PROCESS', 'STOPPING', 'STOPPED', 'AUTOSTOPPED');
CREATE TYPE generators_enum AS ENUM ('GENERATOR_UNSPECIFIED', 'PHANTOM', 'PANDORA');
CREATE TYPE statuses_enum AS ENUM ('STATUS_UNSPECIFIED', 'CREATING', 'PREPARING_TEST', 'READY_FOR_TEST', 'TESTING', 'FAILED', 'RESTARTING', 'DELETING', 'PROVISIONING', 'STOPPING', 'STOPPED', 'STARTING', 'UPDATING', 'ERROR', 'CRASHED', 'LOST_CONNECTION_WITH_TANK', 'INITIALIZING_CONNECTION', 'TANK_FAILED');
CREATE TYPE client_statuses_enum AS ENUM ('STATUS_UNSPECIFIED', 'PREPARING_TEST', 'READY_FOR_TEST', 'TESTING', 'TANK_FAILED');
CREATE TYPE agent_version_statuses AS ENUM ('TARGET', 'ACTUAL', 'DEPRECATED', 'OUTDATED', 'TESTING');
CREATE TYPE types_enum AS ENUM ('STOP');
CREATE TYPE signal_statuses_enum AS ENUM ('WAITING', 'EXECUTING', 'DONE');
CREATE TYPE resources_enum AS ENUM ('TANK', 'JOB', 'STORAGE');

CREATE TABLE agent_versions (
	image_id VARCHAR NOT NULL,
	status agent_version_statuses,
	arc_hash VARCHAR,
	arc_revision INTEGER,
	description VARCHAR,
	created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT timezone('utc'::text, now()) NOT NULL,
	CONSTRAINT agent_versions_pkey PRIMARY KEY (image_id)
)

;

CREATE TABLE storages (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	folder_id VARCHAR(50),
	bucket VARCHAR(50),
	created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT timezone('utc'::text, now()) NOT NULL,
	name VARCHAR,
	description VARCHAR,
	labels HSTORE,
	CONSTRAINT storages_pkey PRIMARY KEY (n),
	CONSTRAINT storages_id_key UNIQUE (id)
)

;

CREATE TABLE signals (
	n SERIAL NOT NULL,
	job_id VARCHAR,
	type types_enum,
	operation_id VARCHAR,
	created_at TIMESTAMP WITHOUT TIME ZONE,
	done_at TIMESTAMP WITHOUT TIME ZONE,
	status signal_statuses_enum,
	CONSTRAINT signals_pkey PRIMARY KEY (n)
)

;

CREATE TABLE operations (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	folder_id VARCHAR(50),
	description VARCHAR,
	created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT now() NOT NULL,
	created_by VARCHAR(50),
	modified_at TIMESTAMP WITHOUT TIME ZONE,
	done BOOLEAN,
	error VARCHAR,
	done_resource_snapshot JSON,
	target_resource_id VARCHAR(50),
	target_resource_type resources_enum,
	metadata JSON,
	compute_operation_id VARCHAR(50),
	foreign_operation_id VARCHAR(50),
	CONSTRAINT operations_pkey PRIMARY KEY (n),
	CONSTRAINT operations_id_key UNIQUE (id)
)

;

CREATE TABLE presets (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	name VARCHAR(50),
	description VARCHAR,
	disk_size BIGINT,
	memory BIGINT,
	cores INTEGER,
	CONSTRAINT presets_pkey PRIMARY KEY (n),
	CONSTRAINT presets_id_key UNIQUE (id)
)

;

CREATE TABLE tanks (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	compute_instance_id VARCHAR(50),
	status statuses_enum,
	client_updated_at TIMESTAMP WITHOUT TIME ZONE,
	folder_id VARCHAR(50),
	tank_folder_id VARCHAR(50),
	created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT now() NOT NULL,
	compute_instance_updated_at TIMESTAMP WITHOUT TIME ZONE,
	description VARCHAR(256),
	service_account_id VARCHAR(50),
	preset_id VARCHAR(50),
	errors VARCHAR(50),
	client_status client_statuses_enum,
	name VARCHAR(50),
	labels VARCHAR(50),
	current_job VARCHAR(50),
	tank_version VARCHAR(50),
	agent_version VARCHAR,
	CONSTRAINT tanks_pkey PRIMARY KEY (n),
	CONSTRAINT agent_version_link FOREIGN KEY(agent_version) REFERENCES agent_versions (image_id) ON DELETE SET NULL ON UPDATE CASCADE,
	CONSTRAINT tanks_id_key UNIQUE (id),
	CONSTRAINT tanks_compute_instance_id_key UNIQUE (compute_instance_id)
)

;

CREATE TABLE ammos (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	name VARCHAR(50),
	link VARCHAR(50),
	content VARCHAR,
	folder_id VARCHAR(50),
	storage_id VARCHAR(50),
	bucket VARCHAR(50),
	CONSTRAINT ammos_pkey PRIMARY KEY (n),
	CONSTRAINT storage_id_fkey FOREIGN KEY(storage_id) REFERENCES storages (id) ON DELETE SET NULL,
	CONSTRAINT ammos_id_key UNIQUE (id)
)

;

CREATE TABLE jobs (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	folder_id VARCHAR(50),
	name VARCHAR,
	description VARCHAR,
	labels HSTORE,
	status jobs_statuses,
	status_updated_at TIMESTAMP WITHOUT TIME ZONE,
	created_at TIMESTAMP WITHOUT TIME ZONE DEFAULT now() NOT NULL,
	started_at TIMESTAMP WITHOUT TIME ZONE,
	finished_at TIMESTAMP WITHOUT TIME ZONE,
	updated_at TIMESTAMP WITHOUT TIME ZONE,
	target_address VARCHAR(50),
	target_port INTEGER,
	version VARCHAR(50),
	generator generators_enum,
	cases VARCHAR[],
	favorite BOOLEAN,
	tank_id VARCHAR,
	errors VARCHAR[],
	internal_tank_error VARCHAR,
	imbalance_point INTEGER,
	imbalance_ts TIMESTAMP WITHOUT TIME ZONE,
	logging_log_group_id VARCHAR,
	CONSTRAINT jobs_pkey PRIMARY KEY (n),
	CONSTRAINT jobs_tank_id_fkey FOREIGN KEY(tank_id) REFERENCES tanks (id),
	CONSTRAINT tank FOREIGN KEY(tank_id) REFERENCES tanks (id) ON DELETE SET NULL,
	CONSTRAINT jobs_id_key UNIQUE (id)
)

;
CREATE INDEX idx_jobs_folder_id ON jobs (folder_id);

CREATE TABLE configs (
	n SERIAL NOT NULL,
	id VARCHAR(50),
	raw_content VARCHAR,
	content JSON,
	job_id VARCHAR,
	CONSTRAINT configs_pkey PRIMARY KEY (n),
	CONSTRAINT configs_job_id_fkey FOREIGN KEY(job_id) REFERENCES jobs (id) ON DELETE CASCADE,
	CONSTRAINT configs_id_key UNIQUE (id)
)

;

CREATE TABLE ammo_job (
	ammos_id VARCHAR(50),
	jobs_id VARCHAR(50),
	CONSTRAINT ammo_job_ammos_id_fkey FOREIGN KEY(ammos_id) REFERENCES ammos (id),
	CONSTRAINT ammo_job_jobs_id_fkey FOREIGN KEY(jobs_id) REFERENCES jobs (id)
)

;
