from sqlalchemy import Column, String, Integer, BigInteger
from load.projects.cloud.loadtesting.db.connection import BASE


class PresetTable(BASE):
    __tablename__ = 'presets'
    n = Column('n', Integer(), primary_key=True, autoincrement=True)
    id = Column('id', String(50), unique=True)
    name = Column('name', String(50))
    description = Column('description', String(256))
    disk_size = Column('disk_size', BigInteger)
    memory = Column('memory', BigInteger)
    cores = Column('cores', Integer)

    def __str__(self):
        return f"Preset {self.id} with name {self.name}. Disk {self.disk_size}, memory {self.memory}, cores {self.cores}"
