from enum import Enum as PyEnum

from sqlalchemy import Column, DateTime, String, Integer
from sqlalchemy.dialects.postgresql import ENUM as SqlEnum

from load.projects.cloud.loadtesting.db.connection import BASE


class SignalType(PyEnum):
    STOP = 'STOP'


class Status(PyEnum):
    WAITING = 'WAITING'
    EXECUTING = 'EXECUTING'
    DONE = 'DONE'


class SignalTable(BASE):
    __tablename__ = 'signals'
    __table_args__ = {'extend_existing': True}

    n = Column('n', Integer(), primary_key=True, autoincrement=True)

    job_id = Column('job_id', String)
    type = Column('type', SqlEnum(*[s.value for s in SignalType], name='types_enum'))
    status = Column('status', SqlEnum(*[s.value for s in Status], name='statuses_enum'))
    operation_id = Column('operation_id', String)
    created_at = Column('created_at', DateTime)
    done_at = Column('done_at', DateTime)
