from sqlalchemy import Column, String, Integer, DateTime, text
from sqlalchemy.orm import relationship

from load.projects.cloud.loadtesting.db.connection import BASE


class StorageTable(BASE):
    __tablename__ = "storages"
    __table_args__ = {"extend_existing": True}

    n = Column('n', Integer(), primary_key=True, autoincrement=True)
    id = Column('id', String(50), unique=True)
    folder_id = Column('folder_id', String(50))
    bucket = Column('bucket', String(50))
    created_at = Column('created_at', DateTime, nullable=False, server_default=text("now()"))
    name = Column('name', String(50))
    description = Column('description', String(256))
    labels = Column('labels', String(50))

    ammos = relationship('AmmoTable', back_populates='storage')
