#Стрельбы в loadtesting-server
##Генерация патронов
Все патроны в *.template.
Где:
- users.template - это пользовательские запросы, которые прилеатют от фронта
- agent.template - это запросы от агентов
- остальные - это однотипные запросы разложенные по отдельным файлам

Перед стрельбой в запросы нужно прописать валидный YC_TOKEN. Подразумевается, что у вас в переменных окружения уже есть актуальный токен, который ранее вы получили при помощи команды:
```bash
export YC_TOKEN=$(yc iam create-token)
```
Далее, вы запускаете команду:
```bash
cat users.template | python3 ammo.py > users.ammo
```
и в результате у вас рабочие патроны для стрельбы в users.ammo, с YC_TOKEN из вашего текущего окружения.

##Запуск стрельбы
Сейчас есть несколько конфигов:
- load.yaml - для стрельбы смесью запросов на разладку(измеряем максимальную производительность)
- load_const.yaml - стрельба смесью запросов с постоянной нагрузкой
- load_agent.yaml - если хотите пострелять только запросами от агента
- load_users.yaml - если хотите пострелять пользовательскими запросами

##Особенности стрельбы на разладку
В конфиге load.yaml сейчас 2 pandora пула, которые условно называются Users и Agent.
- Схема нагрузки в Users пуле сконфигурированна так, что скорость каждого инстанса ограниченна сейчас 1 запросам раз в 5 сек. Делается это через опцию пушки <rps-per-instance: true>  и схемой нагрузки <{type: const, ops: 0.2, duration: 900s}>. А дальше мы увеличиваем нагрузку, путем постепенного добавления инстансов в <startup>:
<
             startup:
               - {type: once, times: 2}
               - {type: const, duration: 30s, ops: 0}
               - {type: once, times: 2}
               - {type: const, duration: 30s, ops: 0}
               - {type: once, times: 2}
>
т.е. здесь мы в начале стрельбы сразу стартуем 2 инстанса, затем 30 секунд ждем и добавляем еще +2 инстанса. Потом опять ждем и ещё +2 инстанса.
По сути у нас каждый инстанс - это пользователь, который со скорость 1 раз в 5 секунд дергает на фронте какой-то запрос. И по ходу теста мы увеличиваем количество одновременных пользователей, добавляя новых инстансов.
- Схема нагрузки в Agent пуле - это некая постоянная фоновая нагрузка от запущенных агентов на loadtesting-server. Сейчас она примерна равна 2 rps на один инстанс в продакшене.
