import io

from sqlalchemy import create_engine, MetaData


def dump_schema(engine, file_path):
    metadata = MetaData()
    metadata.reflect(engine)
    buf = io.BytesIO()

    def dump(sql, *multiparams, **params):
        f = sql.compile(dialect=engine.dialect)
        buf.write(str(f).encode('utf-8'))
        buf.write(b';\n')

    new_engine = create_engine(engine.url, strategy='mock', executor=dump)
    metadata.create_all(new_engine, checkfirst=True)
    with open(file_path, 'wb+') as schema:
        schema.write(buf.getvalue())
