from load.projects.cloud.loadtesting.db.tables import AgentVersionTable
import load.projects.cloud.loadtesting.server.admin.proto.agent_versions_pb2 as agent_versions_pb2


def db_version_from_message(message: agent_versions_pb2.Version) -> AgentVersionTable:
    db_version = AgentVersionTable(image_id=message.id,
                                   description=message.description,
                                   status=agent_versions_pb2.VersionStatus.Name(message.status),
                                   )
    if message.hash:
        db_version.hash = message.hash
    if message.revision:
        db_version.revision = message.revision
    return db_version


def message_from_db_version(version: AgentVersionTable) -> agent_versions_pb2.Version:
    kw = {
        'id': version.image_id,
        'description': version.description,
        'status': agent_versions_pb2.VersionStatus.Value(version.status),
    }
    if version.revision is not None:
        kw['revision'] = version.revision
    if version.hash is not None:
        kw['hash'] = version.hash
    return agent_versions_pb2.Version(**kw)
