import load.projects.cloud.loadtesting.server.admin.proto.server_pb2 as server_pb2
import load.projects.cloud.loadtesting.server.admin.proto.server_pb2_grpc as server_pb2_grpc


class ServerInfo(server_pb2_grpc.ServerServicer):
    def __init__(self, server_to_follow):
        self.server_to_follow = server_to_follow

    def State(self, request, response):
        """
            grpcurl -plaintext  localhost:50055 Server/State
        """
        return server_pb2.StateResponse(
            ActiveRequests=self.server_to_follow._state.active_rpc_count,
            MaxWorkers=self.server_to_follow._state.thread_pool._max_workers,
            MaximumConcurrentRpcs=self.server_to_follow._state.maximum_concurrent_rpcs,
        )
