# import yandex.cloud.priv.loadtesting.agent.v1.monitoring_service_pb2 as messages
# import yandex.cloud.priv.loadtesting.agent.v1.monitoring_service_pb2_grpc as monitoring_grpc
import load.projects.cloud.tank_client.proto.monitoring_service_pb2 as messages
import load.projects.cloud.tank_client.proto.monitoring_service_pb2_grpc as monitoring_grpc

import grpc
from load.projects.cloud.loadtesting.logan import lookup_logger
from load.projects.cloud.loadtesting.server.api.common import utils, handler
from load.projects.cloud.loadtesting.server.publisher.monitoring import push_to_clickhouse


class Monitoring(monitoring_grpc.MonitoringServiceServicer):
    def __init__(self):
        self.logger = lookup_logger('MonitoringPublic')

    class _Create(handler.BasePublicHandler):
        _handler_name = 'Create'

        def proceed(self):
            create_monitoring, job = utils.validate_request_job(
                self.request,
                self.context,
                self.db,
                self.user_token,
                self.request_id,
            )
            push_to_clickhouse(create_monitoring, job)
            return messages.CreateMonitoringResponse(code=0)

    def Create(self, create_monitoring: messages.CreateMonitoringRequest, context: grpc.ServicerContext):
        return self._Create(self.logger).handle(create_monitoring, context)
