# TODO Move to Tanker https://st.yandex-team.ru/CLOUDLOAD-230

# NB: all labels in CreateForm should be in camelCase,
# otherwise Console would not work with it

#

labels = {
    'targetAddress': {
        'label': {
            'ru': 'Адрес цели',
            'en': 'Target address'
        }
    },
    'targetPort': {
        'label': {
            'ru': 'Порт цели',
            'en': 'Target port'
        }
    },
    'ssl': {
        'label': {
            'ru': 'Защищенное соединение',
            'en': 'Secure connection'
        }
    },
    'instances': {
        'label': {
            'ru': 'Тестирующие потоки',
            'en': 'Test instances'
        }
    },
    'loadSchedule': {
        'label': {
            'ru': 'Расписание нагрузки',
            'en': 'Load schedule'
        }
    },
    'loadType': {
        'label': {
            'ru': 'Тип нагрузки',
            'en': 'Load type'
        }
    },
    'loadProfile': {
        'label': {
            'ru': 'Профиль нагрузки',
            'en': 'Load profile'
        }
    },
    'ammoType': {
        'label': {
            'ru': 'Тип запросов',
            'en': 'Ammo type'
        }
    },
    'ammoUrls': {
        'label': {
            'ru': 'Запросы',
            'en': 'Ammo urls'
        }
    },
    'ammoHeaders': {
        'label': {
            'ru': 'Заголовки запросов',
            'en': 'Ammo headers'
        }
    },
    'autostops': {
        'label': {
            'ru': 'Автостоп',
            'en': 'Autostop'
        },
        'help': {
            'ru': 'Настройте условия для автоматической остановки теста. Подробнее см. в документации.',
            'en': 'Set up conditions for automatic test stop. Please refer the docs for details.',
        },
    },
    'autostopType': {
        'label': {
            'ru': 'Тип автостопа',
            'en': 'Autostop type'
        }
    },
    'autostopCriteria': {
        'label': {
            'ru': 'Критерии автостопа',
            'en': 'Autostop criteria'
        }
    },
    'autostopCase': {
        'label': {
            'ru': 'Кейс для автостопа',
            'en': 'Autostop case'
        }
    }
}


def get_form(generator, lang):
    target_address_option = {
        'view_spec': {
            'label': labels['targetAddress']['label'][f'{lang}'],
        },
        'required': True,
        'type': 'STRING',
    }
    target_port_option = {
        'view_spec': {
            'label': labels['targetPort']['label'][f'{lang}'],
        },
        'required': True,
        'value': '80',
        'type': 'NUMBER',
        'minimum': 1,
        'maximum': 65535
    }
    ssl_option = {
        'view_spec': {
            'label': labels['ssl']['label'][f'{lang}'],
        },
        'required': False,
        'value': 'False',
        'type': 'BOOL'
    }
    instances_option = {
        'view_spec': {
            'label': labels['instances']['label'][f'{lang}'],
        },
        'required': False,
        'type': 'NUMBER',
        'minimum': 1,
        'maximum': 1000000  # TODO: should be part of sanity check
    }
    ammo_urls_option = {
        'view_spec': {
            'label': labels['ammoUrls']['label'][f'{lang}'],
        },
        'required': False,
        'type': 'ARRAY',
        'items': {
            'required': False,
            'type': 'STRING',
        },
    }
    ammo_headers_option = {
        'view_spec': {
            'label': labels['ammoHeaders']['label'][f'{lang}'],
        },
        'required': False,
        'type': 'ARRAY',
        'items': {
            'required': False,
            'type': 'STRING',
        },
    }
    load_profile_option = {
        'view_spec': {
            'label': labels['loadProfile']['label'][f'{lang}'],
        },
        'required': True,
        'type': 'ARRAY',
        'items': {
            'type': 'STRING'
        }
    }
    autostop_option = {
        'view_spec': {
            'label': labels['autostops']['label'][f'{lang}'],
            'help': labels['autostops']['help'][f'{lang}'],
        },
        'required': False,
        'type': 'ARRAY',
        'items': {
            'type': 'OBJECT',
            'view_spec': {
                'order': ['autostopType', 'autostopCriteria', ],
            },
            'properties': {
                'autostopType': {
                    'view_spec': {
                        'label': labels['autostopType']['label'][f'{lang}'],
                        'order': [
                            'TIME', 'HTTP', 'NET', 'QUANTILE', 'INSTANCES',
                            'METRIC_LOWER', 'METRIC_HIGHER',
                            'STEADY_CUMULATIVE', 'LIMIT',
                            'TOTAL_TIME', 'TOTAL_HTTP', 'TOTAL_NET',
                            'NEGATIVE_HTTP', 'NEGATIVE_NET',
                            'HTTP_TREND'
                        ],
                    },
                    'type': 'STRING',
                    'enum': [
                        'TIME', 'HTTP', 'NET', 'QUANTILE', 'INSTANCES',
                        'METRIC_LOWER', 'METRIC_HIGHER',
                        'STEADY_CUMULATIVE', 'LIMIT',
                        'TOTAL_TIME', 'TOTAL_HTTP', 'TOTAL_NET',
                        'NEGATIVE_HTTP', 'NEGATIVE_NET',
                        'HTTP_TREND'
                    ]
                },
                'autostopCriteria': {
                    'view_spec': {
                        'label': labels['autostopCriteria']['label'][f'{lang}'],
                    },
                    'type': 'STRING'
                },
            }
        }
    }

    phantom_form = {
        'result_spec': {
            'phantom': {
                'view_spec': {
                    'order': [
                        'target_address', 'target_port', 'ssl', 'instances',
                        'load_schedule',
                        'ammo_type', 'ammo_urls', 'ammo_headers',
                        'autostops'
                    ]
                },
                'properties': {
                    'targetAddress': target_address_option,
                    'targetPort': target_port_option,
                    'ssl': ssl_option,
                    'instances': instances_option,
                    'loadSchedule': {
                        'view_spec': {
                            'label': labels['loadSchedule']['label'][f'{lang}'],
                            'order': ['load_type', 'load_profile']
                        },
                        'required': True,
                        'type': 'OBJECT',
                        'properties': {
                            'loadType': {
                                'view_spec': {
                                    'label': labels['loadType']['label'][f'{lang}'],
                                },
                                'required': True,
                                'type': 'STRING',
                                'enum': ['RPS', 'INSTANCES', 'STPD_FILE']
                            },
                            'loadProfile': load_profile_option,
                        }
                    },
                    'ammoType': {
                        'view_spec': {
                            'label': labels['ammoType']['label'][f'{lang}'],
                        },
                        'required': True,
                        'type': 'STRING',
                        'value': 'URI',
                        'enum': ['URI', 'URIPOST', 'PHANTOM', 'ACCESS']
                    },
                    'ammoUrls': ammo_urls_option,
                    'ammoHeaders': ammo_headers_option,
                    'autostops': autostop_option,
                },
                'type': 'OBJECT',
                'required': False
            }
        }
    }

    pandora_form = {
        'result_spec': {
            'pandora': {
                'view_spec': {
                    'order': [
                        'target_address', 'target_port', 'ssl', 'instances',
                        'load_schedule', 'ammo_type', 'ammo_urls', 'ammo_headers',
                        'autostops'
                    ]
                },
                'properties': {
                    'targetAddress': target_address_option,
                    'targetPort': target_port_option,
                    'ssl': ssl_option,
                    'instances': instances_option,
                    'loadSchedule': {
                        'view_spec': {
                            'label': labels['loadSchedule']['label'][f'{lang}'],
                            'order': ['load_type', 'load_profile']
                        },
                        'required': True,
                        'type': 'OBJECT',
                        'properties': {
                            'loadType': {
                                'view_spec': {
                                    'label': labels['loadType']['label'][f'{lang}'],
                                },
                                'required': True,
                                'type': 'STRING',
                                'value': 'RPS',
                                'enum': ['RPS', ]
                            },
                            'loadProfile': load_profile_option,
                        }
                    },
                    'ammoType': {
                        'view_spec': {
                            'label': labels['ammoType']['label'][f'{lang}'],
                        },
                        'required': True,
                        'type': 'STRING',
                        'value': 'URI',
                        'enum': ['HTTP_JSON', 'RAW', 'URI', 'URIPOST']
                    },
                    'ammoUrls': ammo_urls_option,
                    'ammoHeaders': ammo_headers_option,
                    'autostops': autostop_option,
                },
                'required': False,
                'type': 'OBJECT'
            }
        }
    }

    if generator == 'PANDORA':
        return pandora_form
    elif generator == 'PHANTOM':
        return phantom_form
