from typing import Type

import load.projects.cloud.loadtesting.server.obfuscator.greeter as greeter
import load.projects.cloud.loadtesting.server.obfuscator.job_public as job_public
import load.projects.cloud.loadtesting.server.obfuscator.monitoring_public as monitoring_public
import load.projects.cloud.loadtesting.server.obfuscator.operation as operation
import load.projects.cloud.loadtesting.server.obfuscator.resource_preset as resource_preset
import load.projects.cloud.loadtesting.server.obfuscator.tank_instance as tank_instance
import load.projects.cloud.loadtesting.server.obfuscator.tank_job as tank_job
import load.projects.cloud.loadtesting.server.obfuscator.test_private as test_private
import load.projects.cloud.loadtesting.server.obfuscator.tank_public as tank_public
import load.projects.cloud.loadtesting.server.obfuscator.agent_public as agent_public
import load.projects.cloud.loadtesting.server.obfuscator.test_public as test_public
import load.projects.cloud.loadtesting.server.obfuscator.trail_public as trail_public
import load.projects.cloud.loadtesting.server.obfuscator.storage as storage
import load.projects.cloud.loadtesting.server.obfuscator.agent_registration_public as agent_registration_public
from load.projects.cloud.loadtesting.server.obfuscator.base import Obfuscator

OBFUSCATOR: dict[object, Type[Obfuscator]] = {
    o.target_class: o for o in [
        agent_registration_public.RegisterRequest,
        agent_registration_public.RegisterResponse,
        agent_registration_public.ExternalAgentRegisterRequest,
        greeter.SayHelloRequest,
        greeter.SayHelloResponse,
        job_public.ClaimJobStatusRequest,
        job_public.ClaimJobStatusResponse,
        job_public.GetJobRequest,
        job_public.Job,
        job_public.JobSignalRequest,
        job_public.JobSignalResponse,
        tank_public.ClaimTankStatusRequest,
        tank_public.ClaimTankStatusResponse,
        agent_public.ClaimAgentStatusRequest,
        agent_public.ClaimAgentStatusResponse,
        test_public.Test,
        test_public.CreateTestRequest,
        test_public.UpdateTestRequest,
        monitoring_public.CreateMonitoringRequest,
        monitoring_public.CreateMonitoringResponse,
        trail_public.CreateTrailRequest,
        trail_public.CreateTrailResponse,
        operation.GetOperationRequest,
        operation.Operation,
        operation.ListOperationsRequest,
        operation.ListOperationsResponse,
        resource_preset.GetResourcePresetRequest,
        resource_preset.ResourcePreset,
        resource_preset.ListResourcePresetsRequest,
        resource_preset.ListResourcePresetsResponse,
        storage.GetStorageRequest,
        storage.CreateStorageRequest,
        storage.DeleteStorageRequest,
        storage.UploadStorageObjectRequest,
        storage.Storage,
        storage.StorageObject,
        tank_job.GetTankJobRequest,
        tank_job.TankJob,
        tank_job.ListTankJobsRequest,
        tank_job.ListTankJobsResponse,
        tank_job.CreateTankJobRequest,
        tank_job.UpdateTankJobRequest,
        tank_job.StopTankJobRequest,
        tank_job.DeleteTankJobRequest,
        tank_job.FormRequest,
        tank_job.FormResponse,
        tank_job.GetConfigRequest,
        tank_job.ValidateConfigRequest,
        tank_job.ValidateConfigResponse,
        tank_job.UploadFileResponse,
        tank_job.GetGeneratorsRequest,
        tank_job.GetGeneratorsResponse,
        tank_job.UploadAmmoRequest,
        tank_job.GetFolderStatsRequest,
        tank_job.FolderStats,
        tank_job.GetReportRequest,
        tank_job.TankReport,
        tank_job.GetChartRequest,
        tank_job.TankChart,
        test_private.MonitoringReport,
        test_private.MonitoringChart,
        test_private.GetMonitoringReportRequest,
        tank_instance.GetTankInstanceRequest,
        tank_instance.GetTankInstanceResponse,
        tank_instance.ListTankInstancesRequest,
        tank_instance.TankInstancesList,
        tank_instance.CreateTankInstanceRequest,
        tank_instance.DeleteTankInstanceRequest,
        tank_instance.RestartTankInstanceRequest,
        tank_instance.StopTankInstanceRequest,
        tank_instance.StartTankInstanceRequest,
    ]
}
