from abc import ABC, abstractmethod


class Obfuscator(ABC):
    target_class = None

    def __init__(self, obj):
        if self.target_class != obj.__class__:
            raise ValueError(f'Expected {self.target_class} but got {obj.__class__}')
        self._obj = obj

    @property
    def original(self):
        return self._obj

    @abstractmethod
    def data(self) -> dict:
        ...
